/////////////////////////////////////////////////////////////////////////////////////
//
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
/////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: freelist_manager.h
//
//      Purpose: header file for freelist manager service microblock
//
//
//      History:
//
//      Date            Comment                         				By
//      ---------------------------------------------------------------------------
//
//
//		08/03/03		Created											urn	
//					
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __FREELIST_MANAGER_H__
#define __FREELIST_MANAGER_H__

/////////////////////////////////////////////////////////////////////////////////////

// Number of buffers to be managed 

#ifndef 		FREELIST_MANAGER_NUMBER_OF_BUFFERS	
#define_eval	FREELIST_MANAGER_NUMBER_OF_BUFFERS		BUF_SRAM_SIZE/META_DATA_SIZE
#endif

// First thread for freelist manager 

#ifndef 		FREELIST_MANAGER_FIRST_THREAD
#define 		FREELIST_MANAGER_FIRST_THREAD			0
#endif

// Last thread for freelist manager 

#ifndef 		FREELIST_MANAGER_LAST_THREAD
#define 		FREELIST_MANAGER_LAST_THREAD			7
#endif

// Define the offset in bytes into local memory where we store the bitmap
// THIS MUST BE AT A 16 WORD OR 64 BYTE BOUNDARY

#ifndef			FREELIST_MANAGER_LM_BASE_LEVEL2
#define			FREELIST_MANAGER_LM_BASE_LEVEL2			0
#endif


// Define the offset in bytes into local memory where we store the bitmap
// THIS MUST BE AT A 32 WORD OR 128 BYTE BOUNDARY

#ifndef			FREELIST_MANAGER_LM_BASE_LEVEL3
#define			FREELIST_MANAGER_LM_BASE_LEVEL3			128
#endif

// Maximum number of long words in level 2 (must be a multiple of 16)
// Not all of these may be used as determined by the number of buffers

#ifndef			MAX_NUMBER_IN_LEVEL2				
#define 		MAX_NUMBER_IN_LEVEL2					16
#endif

// Maximum number of long words in level 3 (must be a multiple of 32) 

#ifndef			MAX_NUMBER_IN_LEVEL3					
#define			MAX_NUMBER_IN_LEVEL3					512
#endif

// Define the buffer freelist base as a word offset in SRAM irrespective of channel

#ifndef 		FREELIST_BUFFER_BASE
#define_eval	FREELIST_BUFFER_BASE 		((BUF_SRAM_BASE >> 2) & 0xffffff)
#endif

/////////////////////////////////////////////////////////////////////////////////////

// We keep a 3 level bit vector. The first level is in an absolute register

.reg 	@global_level1_vector 

// Each thread prefetches a buffer handle 

.reg	global_prefetch_buffer_handle 

/////////////////////////////////////////////////////////////////////////////////////

// Global initialization complete signal. Sent by the system_init routine.

.sig volatile 				init_complete_signal		
.addr init_complete_signal	ME_INIT_SIGNAL	 		// Set in dl_system.h

// inter thread signal. Used only once 

.sig volatile				next_thread_signal


/////////////////////////////////////////////////////////////////////////////////////
		
#endif // __FREELIST_MANAGER_H__

/////////////////////////////////////////////////////////////////////////////////////