/***********************************************************************************
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 ************************************************************************************
 *
 * 		File Name: port_rr_scheduler.h
 * 
 * 		Purpose: Header file with data structures for IXP2800 Round Robin scheduler 
 *
 ************************************************************************************
 *
 * 		History:
 *
 * 		Date			Comment										By
 *		---------------------------------------------------------------------------
 *
 *		July 14		Created											urn
 *
 *************************************************************************************/


#ifndef __SCHEDULER_RR_H__
#define __SCHEDULER_RR_H__

/*************************************************************************************/

#include "dl_system.h"

/*************************************************************************************/

#ifdef USE_IMPORT_VAR

.import_var SRAM_ZERO_BLOCK
.import_var SCHED_ROUND_COUNTERS_BASE

#endif 	// USE_IMPORT_VAR

// Signal used for inter-ME synchronization during initialization
 
.sig 	volatile system_init_sig
.addr 	system_init_sig ME_INIT_SIGNAL

/*************************************************************************************
 *
 * Constants 
 *
 ************************************************************************************/
		
    
/* Start location of port bits in equeue/dequeue message*/

#define 		PORT_BITS_START              	16

/* n where 2^n = port structure size in bytes  	*/

#define			PORT_STRUCTURE_SIZE			 	3	

/* the number of bit shift right to convert port offset to T_INDEX value.
   This value is equal to PORT_STRUCTURE_SIZE - 2 since T_Index is in bits [8:2]
*/

#define_eval  	PORT_OFFSET_TO_T_INDEX			(PORT_STRUCTURE_SIZE - 2)


/* Maximum number of packets in flight per port - packets scheduled but 
   not transmitted 
 */
#if ( (TX_PHY_MODE ==  SPI_4_10PORTS) || (TX_PHY_MODE	== SPI_4_16PORTS))

#define 		MAX_IN_FLIGHT				 	16

#else

#define 		MAX_IN_FLIGHT				 	192

#endif	// #if ((TX_PHY_MODE is  SPI_4_10PORTS) or	== SPI_4_16PORTS))



/*************************************************************************************
 *
 * Per port structure maintained in Port Scheduler microengine local memory
 *
 *		  port_packets_enqueued
 *		  port_pkts_scheduled
 *		  port_next
 *  	  port_reserved
 *
 * For each queue there are 4 long words in local memory. Information for 16 queues
 * is cached in local memory (16 * 4 = 64 words)
 *
 * port_pkts_enqueued	: total number of pkts have been enqueued for the port.
 * port_pkts_scheduled	: number of packets scheduled to be dequeued for the port
 * port_next			: link to next port with packets 
 * port_reserved		: reserved 
 *
 ************************************************************************************/
	
/* Packets enqueued on the port currently	*/

#define lm0_port_pkts_enqueued					*l$index0[0]
#define lm1_port_pkts_enqueued					*l$index1[0]	
 
/* Total packets scheduled for dequeue   */

#define lm0_port_pkts_scheduled					*l$index0[1]
#define lm1_port_pkts_scheduled					*l$index1[1]

/* Link to next port with packets */

#define lm0_port_next							*l$index0[2] 
#define lm1_port_next							*l$index1[2] 

	
/*************************************************************************************
 * Packets Transmitted array in Port Scheduler microengine
 *
 * An array of 16 transfer registers that hold the packets transmitted for a port
 * This array will be written by Transmit microengine via reflector write
 *
 * packets_transmitted[16]
 * 
 ************************************************************************************/


/*************************************************************************************
 *
 * Enqueue request from Statistics microengine to port scheduler microengine
 *
 * NN ring interface 
 * 
 *
 * packet_length				 : 32 bits
 * port_number					 : 16 bits
 * queue_number					 : 16 bits
 * sop_handle					 : 32 bits 
 *
 ************************************************************************************/

/*************************************************************************************
 *
 * Enqueue and Dequeue requests from Port Scheduler to QM 
 *
 * NN ring interface for enqueue/dequeue request 
 *
 * dequeue_queue_number			 : bits 31..16
 * enqueue_queue_number			 : bits 15..0
 * sop_handle					 : bits 31..0  
 * eop handle					 : bits 31..0 
 * 
 *				
 ************************************************************************************/


/************************************************************************************/

#endif 		/* __SCHEDULER_RR_H__ */

/************************************************************************************/