/*
 *******************************************************************************
 *                             Intel Proprietary
 *
 * Copyright (c) 2004 By Intel Corporation.  All rights reserved.  
 * No part of this program or publication may be reproduced, transmited,
 * transcribed, stored in a retrieval system, or translated into any language
 * or computer language in any form or by any means, electronic, mechanical,
 * magnetic, optical, chemical, manual, or otherwise, without the prior
 * written permission of:
 *                         Intel Corporation
 *                         2200 Mission College Blvd.
 *                         Santa Clara, CA  95052-8119
 *******************************************************************************
 */

//////////////////////////////////////////////////////////////////////////////////
//
//	read_shared_context()
//
//  A macro that reads a shared data structure from SRAM using the folding
//  algorithm
//
//	inputs:		in_key				:	key to search CAM (GPR)
//				in_context_base		:	base address where all shared structures
//										are kept (GPR)
//				sig_mask			:	signal mask (GPR)
//
//  signals:	
//				sig_read_context	:	signal to read context
//				sig_write_context	:	signal to write context
//		
//	constants:	SIZE_OF_CONTEXT 	:	size of context structure in bytes.
//										Must be a power of 2
//			    CONTEXT_SHIFT		:	log 2 of SIZE_OF_CONTEXT
//
//	outputs:
//				$out_rd_data			:	SRAM read transfer registers where
//										the data read from SRAM is returned
//
//////////////////////////////////////////////////////////////////////////////////

#macro	read_shared_context( in_key, in_context_base, sig_read_context, \
							 sig_write_context, sig_mask, SIZE_OF_CONTEXT, \
							 CONTEXT_SHIFT, $out_rd_data)
.begin

	.reg	cam_result		// result of CAM lookup
	.reg	cam_entry		// entry number from CAM lookup
	.reg	cam_tag			// tag in CAM for entry 
	.reg	offset

	#define_eval NUM_REGS	(SIZE_OF_CONTEXT / 4)

	// Allocate xfer registers for the read and write operations

	xbuf_alloc[$xfer_out, NUM_REGS, write]
	//xbuf_alloc[$xfer_in,  NUM_REGS, read]
	
	// do a cam lookup to see if entry is present

	cam_lookup[ cam_result, in_key ], lm_addr0[0]

	/* Get cam entry */

	alu_shf[cam_entry, 0xf, AND, cam_result, >>3] 

	// check if result shows hit or miss
	
	br_bset[cam_result, 7, end_cam_check#] 

	// its a miss 

  	// Move LRU txc from LM to TX registers. l$index0 points
	// to the beginning of the LRU queue structures
	#define INDEX 	0
	#while (INDEX < NUM_REGS)

		alu[$xfer_out/**/INDEX, --, B, *l$index0[/**/INDEX/**/]]
		#define_eval INDEX (INDEX + 1)

	#endloop
	#undef INDEX 

	// Get CAM tag. 

	cam_read_tag[cam_tag, cam_entry] 

	// Compute the offset in SRAM 

	alu_shf[offset, --, B, cam_tag, <<CONTEXT_SHIFT]

	// swap out LRU structure. 
 
 	sram[write, $xfer_out0, in_context_base, offset, SIZE_OF_CONTEXT], 
		sig_done[sig_write_context]

	// read in the the new structure

	alu_shf[offset, --, B, in_key, <<CONTEXT_SHIFT]
	sram[read, $out_rd_data, in_context_base, offset, SIZE_OF_CONTEXT], 
		sig_done[sig_read_context]

	// update CAM with new tag entry

	cam_write[ cam_entry, in_key, 0]

	// add read signal to the signal mask 

	alu_shf[sig_mask, sig_mask, OR, 1, <<(&sig_read_context)]
	
	// add write signal to the signal mask 

	alu_shf[sig_mask, sig_mask, OR, 1, <<(&sig_write_context)]

end_cam_check#:

	// wait for signal from previous thread and any i/o operations pending

	ctx_arb[--] , defer[1]
		
		local_csr_wr[active_ctx_wakeup_events, sig_mask]

	//xbuf_free(xfer_in)
	xbuf_free($xfer_out)

.end
#endm

///////////////////////////////////////////////////////////////////////////////////


//total_credit_used += packet_size

//round_number = total_credit_used / credit_quantum

//if (round_number > MAX)
//{
//	round_number -= MAX
//	total_credit_used -= MAX * credit_quantum
//}

//queue_count++; flush queue count

//increment packets in round   

/////////////////////////////////////////////////////////////////////////////////////

