/////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
/////////////////////////////////////////////////////////////////////////////////////
//
// Macros for initializing the scheduler and setting up scratch and NN rings
//
/////////////////////////////////////////////////////////////////////////////////////
//
// The ring macros are only called during standalone testing of the scheduler. 
// Typically in a fully integrated application, the XScale or a single microengine 
// sets up all the scratch rings
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __CSIX_SCHEDULER_INIT_UC__
#define __CSIX_SCHEDULER_INIT_UC__

/////////////////////////////////////////////////////////////////////////////////////

#include "wrr_flat_scheduler.h"




///////////////////////////////////////////////////////////////////////////////////////////////////////// 
//
// Initialization routine for Scheduler
//


#ifndef UNIT_TEST

#macro scheduler_init()

.begin

	.reg 	i, count
	.reg 	credit_increment
	.reg 	queue_addr queue_init_word
	.reg	ctx_enable temp



	alu_shf[count, --, B, 1, <<(NUM_PORTS_SHF+NUM_CLASSES_SHF)]
	immed[i, 0]
	immed32[queue_init_word, 0x00010001]
	.while (i < count)
		// Initialize the queue data structure.  Each queue has a credit of 1 and a weight of 1
		alu_shf[queue_addr, --, B, i, <<3]
		local_csr_wr[active_lm_addr_0, queue_addr]
		nop
		nop
		nop
		alu[*l$index0[0], --, B, 0]
		alu[*l$index0[1], --, B, queue_init_word]
		alu[i, i, +, 1]
	.endw

	// maximum packets in flight
	alu[max_pkts_in_flight, --, B, MAX_IN_FLIGHT]

	// cell count mask 
	immed32[fc_count_mask, 0x7fffff]

	// cell count decrement constant
	immed32[cell_count_minus_one, 0x100]

	// Set active and WRR round lists
	alu_shf[temp, --, B, 1, <<LIST_INACTIVE_BIT]
	alu[active, --, B, temp]
	alu[@wrr_round_complete, --, B, temp]

	// Set the NN ring empty threshold to 2 words
	local_csr_rd[ctx_enables]
	immed[ctx_enable, 0]
	alu_shf[ctx_enable, ctx_enable, AND~, 3, <<18]
	alu_shf[ctx_enable, ctx_enable, OR, 2, <<18]
	local_csr_wr[ctx_enables, ctx_enable]	// wait 3 cycles before first use
	local_csr_wr[nn_put, 0]
	local_csr_wr[nn_get, 0]	
	alu[--, --, b, 0]
	alu[--, --, b, 0]
	alu[--, --, b, 0]

	// Set PacketsScheduled to 0

	alu[@packets_scheduled, --, B, 0]

	// Set Packets Transmitted to 0

	alu[@packets_in_flight, --, B, 0]


.end

#endm

#endif

/////////////////////////////////////////////////////////////////////////////////////

#endif // __CSIX_SCHEDULER_INIT_UC__

/////////////////////////////////////////////////////////////////////////////////////