/////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
/////////////////////////////////////////////////////////////////////////////////////
//
// Macros for setting up scratch and NN rings
//
/////////////////////////////////////////////////////////////////////////////////////
//
// These macros are only called during standalone testing of the scheduler. Typically
// in a fully integrated application, the XScale or a single microengine sets up all
// the scratch rings
//
/////////////////////////////////////////////////////////////////////////////////////

#include "scheduler.h"

/////////////////////////////////////////////////////////////////////////////////////
//
// InitScratchRing[ RBASE, RSIZE, RING]
//
// RBASE: Base address of scratch ring. Should be 4 byte aligned
// RSIZE: Size of scratch ring in words. Valid values are 128, 256, 512, 1024
// RING:  Ring number (0..15)
// 
///////////////////////////////////////////////////////////////////////////////////////

#macro	_scheduler_init_scratch_ring(RBASE, RSIZE, RING)
.begin 	

	.sig 	cw1, cw2, cw3						; signals used in cap[write...]
	.reg	$_rhead, $_rtail, $_rbase, _base
 
	// These define_eval are required. Otherwise the caller cannot have spaces
	// in between parameters like init[a, b, c].

	#define_eval RN		RING
	#define_eval RS		RSIZE
	#define_eval RB		RBASE

	immed[$_rhead, 0x0]								; Initialise ring head to 0
	immed[$_rtail, 0x0]								; Initialise ring tail to 0;
	immed[_base, RB]								; Initialise ring base 

	alu_shf[$_rbase, _base, or, RING_SIZE_/**/RS, <<30]; [31:30]= 0 => Ring size is 128

	// Initialise the Scratch Ring base (and size), head and tail.

	// Note: We can Queue a max. of 4 commands to any external unit 
	// (like sram, dram, cap, etc). Beyond this limit the ME will stall.
	// The limit of 4 includes all the commands issued by all other MEs 
	// as well. It is the programmers responsibility to ensure this.

	// Since this is the only thread and ME that is queuing cmds at this time,
	// we can queue 3 commands safely.

	cap[write, $_rbase, SCRATCH_RING_BASE_/**/RN], sig_done[cw1]	; base = 0x1000
	cap[write, $_rhead, SCRATCH_RING_HEAD_/**/RN], sig_done[cw2]	; head = 0
	cap[write, $_rtail, SCRATCH_RING_TAIL_/**/RN], sig_done[cw3]	; tail = 0

	ctx_arb[cw1, cw2, cw3]		

#undef RN
#undef RS
#undef RB

.end
#endm

///////////////////////////////////////////////////////////////////////////////////////
//
// InitRings[]
//
// Initialize the scratch ring used to send dequeue requests to the Queue Manager
// and the next neighbor ring used to receive QM messages from the Queue Manager
//
///////////////////////////////////////////////////////////////////////////////////////

#macro _scheduler_init_rings()
.begin

	.reg 	ctx_enable_data

#ifdef UNIT_TEST

	init_scratch_ring[RING_BASE, RING_SIZE, RING_ID]

#endif
	
	//
	// Set up the CTX_ENABLES local csr for NN ring 
	// 
	// bit 20 NN_MODE = 0 : next neighbor register are written
	//                                      by previous ME 
	//
	// bits [19:18] NN_RING_EMPTY = 0 : NN_EMPTY asserts when
	//                                                  NN_PUT == NN_GET
	//													(default)
	// bits [15:8] CTX enables for contexts 0 to 7
	//

    immed32[ctx_enable_data, 0xFF00]			
    local_csr_wr[CTX_ENABLES, ctx_enable_data] 	


.end
#endm

///////////////////////////////////////////////////////////////////////////////////////
