/////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                 
//
// Change History
// --------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 11/11/01    	Created for Sausalito								Uday Naik
//
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __CSIX_SCHEDULER_H__
#define __CSIX_SCHEDULER_H__


#ifdef USE_IMPORT_VAR

 .import_var SCHED_VOQ_CREDIT_BASE

#else

#endif
/////////////////////////////////////////////////////////////////////////////////////
//
// Constants for the algorithm. These should be replaced with import vars to make the code
// more configurable
//
/////////////////////////////////////////////////////////////////////////////////////

// Number of queue groups (first level of hierarchical bit vector

#define 		NUMBER_OF_QUEUE_GROUPS       32

// Number of queues per group

#define 		NUMBER_OF_QUEUES_PER_GROUP    32


// The queue group and queue in the group are encoded into one id. LSB 5 bits are 
// used for queue and then 5 bits for queue group id

#define 		NUMBER_OF_BITS_FOR_QUEUE	5

// bits for queue group

#define 		NUMBER_OF_BITS_FOR_GROUP	5

// location in local memory where the data structures per queue are stored. The queue
// structures are stored after the bit vectors per queue group. This is computed by 
// using 16 bytes per queue group 

#define_eval    QUEUE_LOCAL_MEM_BASE       (NUMBER_OF_QUEUE_GROUPS << 4)

// 
// Ring id for scratch ring (from system.h)
//

#define_eval 	RING_ID					SCHEDULER_TO_QM_SCR_RING

//
// Ring full value for testing branch state. This depends on which ring you are using
// Eventhough 0-15 rings are possible, the "ring full"input state can be used
// only on rings 0-11. i.e SCR_Ring#_Full is valid only for # = 0-11.
//

#if (RING_ID > 11)

#error			"For Ring > 11, we cannot use the SCR_Ring#_Full input state"

#else

#define_eval	RING_FULL_VALUE			SCR_Ring/**/RING_ID/**/_status
	
#endif

//
// Ring size [31:30]. Hardware representation
// 00 = 128
// 01 = 256
// 10 = 512
// 11 = 1024
//

#define RING_SIZE_128 		0
#define RING_SIZE_256		1
#define RING_SIZE_512		2
#define RING_SIZE_1024		3

//
// Valid values for RING_SIZE are 128, 256, 512 or 1024. (from system.h)
//

#define RING_SIZE			SCHEDULER_TO_QM_SCR_RING_SIZE

//
// Base Address for Scratch Ring. Should be aligned on a 4 byte boundary. 
// (from system.h)
//

#define RING_BASE			SCHEDULER_TO_QM_SCR_RING_BASE

//
// Maximum number of packets (C-Frames actually) in flight
//

#define MAX_IN_FLIGHT		32

//
// Address of the Tx sequence number register used to read tbufs transmitted
//

#define TX_SEQUENCE_0 		0x60

/////////////////////////////////////////////////////////////////////////////////////
//
// Global Data Structures
//
/////////////////////////////////////////////////////////////////////////////////////

//
//  Root vector with 1 bit per queue group. If that bit is 1,
//	then the queue group has data.

.reg @root_empty_vector			

//
//  Root vector with 1 bit per queue group. If that bit is 1,
//	then the queue group is not flow controlled

.reg @root_flow_control_vector	
				

// 
// Number of c-frames in flight (scheduled but not transmitted)
//

.reg @packets_in_flight

//
// Number of c-frames scheduled by scheduler 
//

.reg @packets_scheduled			

/////////////////////////////////////////////////////////////////////////////////////
//
//
// For each queue group there are 4 words in local memory. (32 * 4 =  128 words)
//
// emptyVector 					: Bit vector indicating which queues have data 
//
// flowControlVector			: Bit vector indicating which queues are not 
//								  flow controlled
//
// mask							: Mask used to Round Robin among queues
//
// Reserved						: Reserved
//
/////////////////////////////////////////////////////////////////////////////////////

#define LM_GROUP_EMPTY_VECTOR_INDEX			0
#define LM_GROUP_FC_VECTOR_INDEX 			1
#define LM_GROUP_MASK_INDEX					2

/////////////////////////////////////////////////////////////////////////////////////
//
// For each queue there is 2 bytes in local memory (1024 * 1/2 = 512 words)
//
// queueCurrentCredit			: Current Credit for the queue  (1 byte)
//
// queueCreditIncrement         : The credit increment to be given to a queue at the end of
//                                every round (1 byte)
// 
// Since we are doing WRR, the credit is in # of c-frames
//
//
/////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////
//
// There are 64 ports and 16 classes per port. Ideally we would do Round Robin among 
// ports and WRR on the queues in a port. This would require us to keep 2 32 bit 
// parent vectors each with 32 16-bit vectors at the next level. 
// 
// We have flattened this out. We keep one 32 bit vector for the parent and  32 32-bit 
// vectors at the next level. This means that in each 32 bit vector on the leaf level, there
// are queues from 2 ports. To keep the scheduling property the same as the one stated above
// we will do the following. The sum of the credit quantums for the 16 queues on each of the
// 2 ports must be the same. For e.g. if port 1 and 2 share the 32 bit vector, then the sum of
// the total credit for port 1 must equal the sum of total credit for port 2. This ensures that
// we are doing round robin among port 1 and port 2
//
/////////////////////////////////////////////////////////////////////////////////////

#endif // __CSIX_SCHEDULER_H__

/////////////////////////////////////////////////////////////////////////////////////