/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_sched_internal.h
 *
 * = DESCRIPTION
 *      File contains macros and function declaration internal to Scheduler
 *      core component
 *
 * = AUTHOR
 *      Herman Zaks
 *      Herman.Zaks@intel.com
 *
 * = CHANGE HISTORY
 *      8/16/2002 - Created
 *  $Id: ix_cc_sched_internal.h,v 1.8 2002/10/07 23:27:00 hlzaks Exp $
 **/
#if !defined(__IX_CC_SCHED_INTERNAL_H__)
#define __IX_CC_SCHED_INTERNAL_H__


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/* internal macros */
/**
 * MACRO NAME: IX_SCHED_SET_UBLOCK_SYMBOLS
 *
 * DESCRIPTION: This macro sets microblock symbols into the ix_imported_symbol data structure
 *  @Param:  - INOUT argSymbolStruct -  imported symbol structure .
 *  @Param:  - IN    argValue   - value of the imported variable.
 *  @Param:  - IN    argName    - name of the imported variable
 * @Return: Fills data structure with the name and value
 */
#define IX_SCHED_SET_UBLOCK_SYMBOLS(argSymbolStruct,argValue,argName) \
                            do { \
                            argSymbolStruct.m_Value = argValue; \
                            argSymbolStruct.m_Name = argName; \
                            } \
                            while (0)




/* Configuration functions */
ix_error _ix_cc_sched_update_configuration(ix_cc_sched_context* pContext);
ix_error _ix_cc_sched_patch_microblock(const ix_cc_sched_context* pContext);


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_SCHED_INTERNAL_H__) */
