#ifndef _ATM_TM_THREAD_INIT_UC_
#define _ATM_TM_THREAD_INIT_UC_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/


/*
 *      File Name: atm_tm_thread_init.uc                                         
 *                                                                   
 *      Description: This file contains the thread and next-thread-signal
 *					  initialization for all 8 threads.
 *                                                                   
 *      History: ver 1.0                                             
 *
 */                            

//------------------------------------------------------------------
// _4thread_init()
//
//    Description: Initializes inter-thread signals
//
//    Parameters: None.
//		  Inputs:
//			None.
//		 Outputs:
//			None.
//------------------------------------------------------------------

#macro _4thread_init()

.begin
.reg next_thread

	//branch out into each of the individual threads and set 
	//the intre-thread signal values
	br=ctx[0,thread0#]
	br=ctx[2,thread2#]
	br=ctx[4,thread4#]
	br=ctx[6,thread6#]

thread0#:
	immed[next_thread, 0x2]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread2#:
	immed[next_thread, 0x4]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread4#:
	immed[next_thread, 0x6]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread6#:
	immed[next_thread, 0x0]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

end_thread_init#:
nop
nop

.end
#endm

#macro _8thread_init()

.begin
.reg next_thread

	//branch out into each of the individual threads and set 
	//the intre-thread signal values
	br=ctx[0,thread0#]
	br=ctx[1,thread1#]
	br=ctx[2,thread2#]
	br=ctx[3,thread3#]
	br=ctx[4,thread4#]
	br=ctx[5,thread5#]
	br=ctx[6,thread6#]
	br=ctx[7,thread7#]

thread0#:
	immed[next_thread, 0x1]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread1#:
	immed[next_thread, 0x2]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread2#:
	immed[next_thread, 0x3]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread3#:
	immed[next_thread, 0x4]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread4#:
	immed[next_thread, 0x5]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]


thread5#:
	immed[next_thread, 0x6]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread6#:
	immed[next_thread, 0x7]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

thread7#:
	immed[next_thread, 0x0]
	alu_shf[next_thread_sig_csr_val, next_thread, or, &next_thread_sig, <<3]
	br[end_thread_init#]

end_thread_init#:
nop
nop
.end
#endm


#endif  	//_ATM_TM_THREAD_INIT_UC_