#ifndef _ATM_TM_SHAPER_INIT_UC_
#define _ATM_TM_SHAPER_INIT_UC_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/


/*
 *
 *      File Name: atm_tm_shaper_init.uc                                         
 *                                                                   
 *      Description: This file contains the shaper initialization
 *                                                                   
 *      History: ver 1.0
 *
 */                            

#include <atm_tm.h>

//------------------------------------------------------------------
// atm_tm_shaper_init()
//
//    Description: Initializes shaper microcode
//
//    Parameters: None.
//		  Inputs:
//			None.
// 		 Outputs:
//		 out_sram_base:
//			the SRAM base address for storing VC traffic descriptors
//		 out_mult_fac:		 		
//			needed for division by 106 to obtain the cell tx slot
//		 out_mask_upper:
//			register to mask out parameters in a LW
//		 out_th:
//			value of Time Horizon 
//		 out_gcra_lm_offs:
//			Offset for LM - in no CAM mode
//------------------------------------------------------------------


#macro atm_tm_shaper_init(out_sram_base, out_mult_fac, out_mask_upper, \
						  out_gcra_lm_offs, out_ring_delay, out_mask_for_port_extraction, \
						  out_mask_for_mul_result, out_mask_for_thmask_extraction, out_indirect_ref)
.begin
.reg tmp tmp2


    // LW used to make indirect_read
    immed[tmp,9]
	alu[tmp2, tmp, -, 1]
	alu_shf[tmp2, --, b, tmp2, <<21]
	alu_shf[tmp2, tmp2, or, 1, <<25]
    alu[out_indirect_ref, --, B, tmp2]

	// Init _gcra_param_sram_base
	immed32(out_sram_base, GCRA_PARAM_SRAM_BASE)

	// For division by 106
	move(out_mult_fac, MULT_FAC_FOR_DIVIDE) 

	//Other global masking registers
	//Mask the upper 15 bits of a LW
	move(out_mask_upper, 0x1ffff)

	// Communication delay between shaper and scheduler
	// assuming that ring between shaper and scheduler 
	// can hold up to 64 messages
	move(out_ring_delay, (TIME_CONSTANT*64+1))	
												
	move(out_mask_for_port_extraction, 0x7FF)

   	move(out_mask_for_thmask_extraction, 0x7FF)

	move(out_mask_for_mul_result, 0x7FFF);



#ifndef SHAPER_WITH_CAM	

.reg lm_offset

#ifndef QM_SHAPER_SH_LM_BASE 

/* QM_SHAPER_SH_LM_BASE is needed to specify offset in LM, where the Shaper allocates GCRA params */
#warning "You have to specify whether you want to use CAM (SHAPER_WITH_CAM) or not."

#endif

	// Per thread LM offsets need to be set up at the init stage
	move(lm_offset, QM_SHAPER_SH_LM_BASE)

	local_csr_rd[ACTIVE_CTX_STS]
	immed[out_gcra_lm_offs, 0]
	alu[out_gcra_lm_offs, 0x7, AND, out_gcra_lm_offs]
	alu[out_gcra_lm_offs, --, B, out_gcra_lm_offs, <<6]
	alu[out_gcra_lm_offs, out_gcra_lm_offs, +, lm_offset]

    // We have to clean-up the Local Memory
	// Set the strating address used by the Shaper functionality
	local_csr_wr[active_lm_addr_0, out_gcra_lm_offs]			; setup local memory for the Shaper
    nop
    nop
    nop
    
    // Clean-up the memory cells
	alu[*l$index0[0], --, b, 0]
	alu[*l$index0[1], --, b, 0]
	alu[*l$index0[2], --, b, 0]
	alu[*l$index0[3], --, b, 0]
	alu[*l$index0[4], --, B, 0]
	alu[*l$index0[5], --, b, 0]
	alu[*l$index0[6], --, b, 0]
	alu[*l$index0[7], --, b, 0]
	alu[*l$index0[8], --, b, 0]
	alu[*l$index0[9], --, b, 0] ; Use the zero-VCQ, to write back for the first time

#endif

	//Only thread-7 does the following
	br!=ctx[7,end#]

	; Initialize the NN

	// We need to init NNrings only when use it
	; Bit 20    : NN_MODE       : = 0 Gets NN data from this ME
	; Bit 19:18 : NN_RING_EMPTY : = 0 Eempty flag set when 0 or less entries valid
	; Bits [15:8] CTX enables for contexts 7:0
	.reg ctx_enable_data
	move[ctx_enable_data, 0x0004FF00]
	local_csr_wr[CTX_Enables,ctx_enable_data]
	local_csr_wr[nn_put,0]
	local_csr_wr[nn_get,0]

#ifdef SHAPER_WITH_CAM
	//Clear the CAM
	cam_clear
#endif

        // Initialize TIMESTAMP
        .begin
        .sig cap_read_sig
        .reg $cap_read

        cap[read, $cap_read, MISC_CONTROL], ctx_swap[cap_read_sig]
        alu[$cap_read, 0x80, OR, $cap_read]
        cap[write, $cap_read, MISC_CONTROL], ctx_swap[cap_read_sig]

        .end

	//signal next thread to continue
	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]

end#:
	//sleep and wait on the signal from previous thread
	ctx_arb[next_thread_sig]

.end
#endm

#endif  //_ATM_TM_SHAPER_INIT_UC_