#ifndef _ATM_TM_SHAPER_GCRA_UC_
#define _ATM_TM_SHAPER_GCRA_UC_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*
 *      File Name: atm_tm_shaper_gcra.uc                                         
 *                                                                   
 *      Description: This is contains actual GCRA(t,tau) routines
 *                                                                   
 *      History: ver 1.0                                             
 *
 */

//------------------------------------------------------------------
// gcra_computed_enq()
//
//    Description: 
//
//
//    Parameters:
//		Outputs:
//			out_t1:
//				earliest dparture time
//		Inputs/Outputs:
//			io_TAT_low:
//				Theoretical cell Arrival Time; 32 LSB
//			io_TAT_high:
//				Theoretical cell Arrival Time; 32 MSB
//		Inputs:
//			in_tau:
//				tau; 
//			in_T1:
//				GCRA parameter - inter-cell gap
//			in_lag:
//				the delay between ring put in shaper and ring get in scheduler
//------------------------------------------------------------------
#macro gcra_computed_enq(out_t1, io_TAT_low, io_TAT_high, in_tau, in_T1, in_lag)
.begin
.reg ial1 iah1	; temporary registers
.reg tlo thi	; Timestamps Lo and Hi

	//Get Time
	local_csr_rd[TIMESTAMP_LOW]
	immed[tlo, 0]
	local_csr_rd[TIMESTAMP_HIGH]
	immed[thi, 0]

	//GCRA1
	//t - TAT >= 0?
	alu[ial1, io_TAT_low, -, tlo]
	alu[iah1, io_TAT_high, -carry, thi]
	blt[gcra11#]

	alu[out_t1, --, B, io_TAT_low] 
	alu[io_TAT_low, io_TAT_low, +, in_T1]
	alu[io_TAT_high, io_TAT_high, +carry, 0]
	br[gcra_end#]

gcra11#:
	//t - TAT + tau1 >= 0?
	; Schedule cell NOW
	alu[tlo, tlo, +, in_lag]	; we neeed to postpone cell 
	alu[out_t1, --, B, tlo] 		; because scheduler can't service NOW TQ

	alu[io_TAT_low, in_T1, +, tlo]
	alu[io_TAT_high, thi, +carry, 0]
	
gcra_end#:
.end
#endm



//------------------------------------------------------------------
// dual_gcra()
//
//    Description: 
//
//
//    Parameters:
//		Outputs:
//			out_t1:
//				earliest dparture time
//		Inputs/Outputs:
//			io_TAT_low:
//				Theoretical cell Arrival Time; 32 LSB
//			io_TAT_high:
//				Theoretical cell Arrival Time; 32 MSB
//          io_debit:
//              amount of time in PCR
//          io_debit_limit:
//              maximum allowed time in PCR
//          io_timestamp_type:
//              flag indicating that TDT was calculated to PCR
//		Inputs:
//			in_T1/T2:
//				GCRA parameter - inter-cell gap (PCR/SCR)
//			in_delta:
//				differentce between PCR and SCR; 
//			in_lag:
//				the delay between ring put in shaper and ring get in scheduler
//------------------------------------------------------------------
#macro dual_gcra(out_t1, io_TDT_low, io_TDT_high, io_debit, io_timestamp_type, in_debit_limit, in_T1, in_T2, in_delta, in_lag)
.begin
.reg tlo thi	; Timestamps Lo and Hi
.reg scr_ts_lo scr_ts_hi    ; Recovered SCR timestamps
.reg mdelta_lo mdelta_hi    ; Value used to decrement debit

	//Get Time
	local_csr_rd[TIMESTAMP_LOW]
	immed[tlo, 0]
	local_csr_rd[TIMESTAMP_HIGH]
	immed[thi, 0]

    
    alu[--, io_debit, -, in_debit_limit]
    bge[calc_scr#]

calc_pcr#:
    br_bset[io_timestamp_type, 30, calc_pcr_tstamp_pcr#]

    ; Current TDT was calculated using T2 (T2 = 1/SCR)
calc_pcr_tstamp_scr#:

    ; GCRA(1/PCR, 0)

    ; Set timestamp type to PCR
    alu[io_timestamp_type, io_timestamp_type, OR, 0x1, <<30]

	; Is t > TDT ?
	alu[mdelta_lo, tlo, -, io_TDT_low]
	alu[--, thi, -carry, io_TDT_high]
	bge[pcr_after_scr#]

pcr_before_scr#:    
    ; (t <= TDT)
	alu[out_t1, --, B, io_TDT_low]
    ; calculate next TDT using T1 (T1 = 1/PCR)
	alu[io_TDT_low, io_TDT_low, +, in_T1]
	alu[io_TDT_high, io_TDT_high, +carry, 0]
    ; Increase debit
    alu[io_debit, io_debit, +, in_delta]
	br[end#]

pcr_after_scr#:
    ; (t > TDT) 
	; Schedule cell NOW
	alu[out_t1, tlo, +, in_lag]	; we neeed to postpone cell
                                ; because scheduler can't service NOW TQ
    ; calculate next TDT using T1 (T1 = 1/PCR)
	alu[io_TDT_low, in_T1, +, out_t1]
	alu[io_TDT_high, thi, +carry, 0]
    ; Decrease debit
    alu[io_debit, io_debit, -, mdelta_lo]
    bpl[end#]
    immed[io_debit, 0]
	br[end#]

calc_pcr_tstamp_pcr#:
    ; Current TDT was calculated using T1 (T1 = 1/PCR)

    ; Recover SCR timestamp
	alu[scr_ts_lo, io_TDT_low, +, in_delta]
	alu[scr_ts_hi, io_TDT_high, +carry, 0]

    ; GCRA(1/PCR, 0)
	; Is t > TDT ?
	alu[mdelta_lo, tlo, -, io_TDT_low]
	alu[--, thi, -carry, io_TDT_high]
	bge[pcr_after_pcr#]

pcr_before_pcr#:    
    ; (t <= TDT)
	alu[out_t1, --, B, io_TDT_low]
    ; calculate next TDT using T1 (T1 = 1/PCR)
	alu[io_TDT_low, io_TDT_low, +, in_T1]
	alu[io_TDT_high, io_TDT_high, +carry, 0]
    ; Increase debit
    alu[io_debit, io_debit, +, in_delta]
    ; No need to set timestamp type to PCR because it's already set
	br[end#]

pcr_after_pcr#:
    ; (t > TDT)
	; Schedule cell NOW
	alu[out_t1, tlo, +, in_lag]	; we neeed to postpone cell
                                ; because scheduler can't service NOW TQ
    ; calculate next TDT using T1 (T1 = 1/PCR)
	alu[io_TDT_low, in_T1, +, out_t1]
	alu[io_TDT_high, thi, +carry, 0]
    ; Check if the cell is after SCR timestamp
	alu[mdelta_lo, tlo, -, scr_ts_lo]
	alu[mdelta_hi, thi, -carry, scr_ts_hi]
	bge[pcr_after_pcr2#]
    ; The cell is before SCR timestamp
    ; Need to add (-mdelta_lo) to debit
    alu[io_debit, io_debit, -, mdelta_lo]
    ; No need to set timestamp type to PCR because it's already set
	br[end#]

pcr_after_pcr2#:
    ; The cell is after SCR timestamp
	alu[io_debit, io_debit, -, mdelta_lo]
	alu[--, 0, -carry, mdelta_hi]
    br>=0[end#]
    immed[io_debit, 0]
	br[end#]


calc_scr#:
    br_bset[io_timestamp_type, 30, calc_scr_tstamp_pcr#]

    ; Current TDT was calculated using T2 (T2 = 1/SCR)
    ; GCRA(1/SCR, 0)
	; Is t > TDT ?
	alu[mdelta_lo, tlo, -, io_TDT_low]
	alu[mdelta_hi, thi, -carry, io_TDT_high]
	bge[scr_after_scr#]

scr_before_scr#:
    ; (t <= TDT) 
	alu[out_t1, --, B, io_TDT_low]
    ; calculate next TDT
	alu[io_TDT_low, io_TDT_low, +, in_T2]
	alu[io_TDT_high, io_TDT_high, +carry, 0]
    ; No need to set timestamp type to SCR because it's already set
 	br[end#]

scr_after_scr#:
    ; (t > TAT1) 
	; Schedule cell NOW
	alu[out_t1, tlo, +, in_lag]	; we neeed to postpone cell
                                ; because scheduler can't service NOW TQ
    ; calculate next TDT
	alu[io_TDT_low, in_T2, +, out_t1]
	alu[io_TDT_high, thi, +carry, 0]

    ; Check if the cell is after SCR timestamp
	alu[io_debit, io_debit, -, mdelta_lo]
	alu[--, 0, -carry, mdelta_hi]
    br>=0[end#]
    immed[io_debit, 0]
	br[end#]
   ; No need to set timestamp type to SCR because it's already set
   br[end#]

calc_scr_tstamp_pcr#:
    ; Current TDT was calculated using T1 (T1 = 1/PCR)

    ; Recover SCR timestamp
	alu[scr_ts_lo, io_TDT_low, +, in_delta]
	alu[scr_ts_hi, io_TDT_high, +carry, 0]

   ; Set timestamp type to SCR
    alu[io_timestamp_type, io_timestamp_type, AND~, 0x1, <<30]

    ; GCRA(1/SCR, 0)
	; Is t > TDT ?
	alu[mdelta_lo, tlo, -, io_TDT_low]
	alu[mdelta_hi, thi, -carry, io_TDT_high]
	bge[scr_after_pcr#]

scr_before_pcr#:
    ; (t <= TDT) 
	alu[out_t1, --, B, io_TDT_low]
    ; calculate next TDT
	alu[io_TDT_low, io_TDT_low, +, in_T2]
	alu[io_TDT_high, io_TDT_high, +carry, 0]
    ; Increase debit
    alu[io_debit, io_debit, +, in_delta]
    ; No need to set timestamp type to SCR because it's already set
 	br[end#]

scr_after_pcr#:
    ; (t > TAT1)
	; Schedule cell NOW
	alu[out_t1, tlo, +, in_lag]	; we neeed to postpone cell
                                ; because scheduler can't service NOW TQ
    ; calculate next TDT
	alu[io_TDT_low, in_T2, +, out_t1]
	alu[io_TDT_high, thi, +carry, 0]

    ; Check if the cell is after SCR timestamp
	alu[mdelta_lo, tlo, -, scr_ts_lo]
	alu[mdelta_hi, thi, -carry, scr_ts_hi]
	bge[scr_after_pcr2#]
    ; The cell is before SCR timestamp
    ; Need to add (-mdelta_lo) to debit
    alu[io_debit, io_debit, -, mdelta_lo]
    ; No need to set timestamp type to PCR because it's already set
	br[end#]

scr_after_pcr2#:
    ; The cell is after SCR timestamp
	alu[io_debit, io_debit, -, mdelta_lo]
	alu[--, 0, -carry, mdelta_hi]
    br>=0[end#]
    immed[io_debit, 0]

end#:
.end
#endm



//------------------------------------------------------------------
// gcra_computed_deq()
//
//    Description: 
//
//
//    Parameters:
//		Outputs:
//			out_t1:
//				earliest dparture time
//		Inputs/Outputs:
//			io_TAT_low:
//				Theoretical cell Arrival Time; 32 LSB
//			io_TAT_high:
//				Theoretical cell Arrival Time; 32 MSB
//		Inputs:
//			in_tau:
//				tau; 
//			in_T1:
//				GCRA parameter - inter-cell gap
//			in_lag:
//				the delay between ring put in shaper and ring get in scheduler
//------------------------------------------------------------------
#macro gcra_computed_deq(out_t1, io_TAT_low, io_TAT_high, in_tau, in_T1, in_lag)
.begin
.reg ial1 iah1	; temporary registers
.reg tlo thi	; Timestamps Lo and Hi

	//GCRA1
	//t - TAT >= 0?
	//Get Time
	local_csr_rd[TIMESTAMP_LOW]
	immed[tlo, 0]
	local_csr_rd[TIMESTAMP_HIGH]
	immed[thi, 0]
	
    ; Is (t > TAT1) ?
	alu[ial1, tlo, -, io_TAT_low]
	alu[iah1, thi, -carry, io_TAT_high]
	bgt[increment_TAT#]

    ; (t <= TAT1)
	alu[ial1, ial1, +, in_tau]
	alu[iah1, iah1, +carry, 0]
	//Cell is conformant. 
	bgt[gcra_11#]

start_case#:
	alu[out_t1, io_TAT_low, -, in_tau]
	alu[io_TAT_low, io_TAT_low, + , in_T1]
	alu[io_TAT_high, io_TAT_high, +carry, 0]

	br[gcra_end#]

gcra_11#:
	; Schedule cell NOW
	alu[tlo, tlo, +, in_lag]		; we neeed to postpone cell 
	alu[out_t1, --, B, tlo] 		; because scheduler can't service NOW TQ

	alu[io_TAT_low, io_TAT_low, + , in_T1]
	alu[io_TAT_high, io_TAT_high, +carry, 0]

	br[gcra_end#]

increment_TAT#:
	; Schedule cell NOW
	alu[tlo, tlo, +, in_lag]			; we neeed to postpone cell 
	alu[out_t1, --, B, tlo] 		; because scheduler can't service NOW TQ

	alu[io_TAT_low, tlo, + , in_T1]
	alu[io_TAT_high, thi, +carry, 0]
	br[gcra_end#]

gcra_end#:
.end
#endm

#endif /* _ATM_TM_SHAPER_GCRA_UC_ *
