#ifndef	ATM_TM_DEFS_H
#define	ATM_TM_DEFS_H

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.  
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*

	PORTINFO Table

	    3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 
        1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
       +---------------+---------------+---------------+---------------+
    LW0| RT_for_LBR_TQ |             CurTQ			   |  Reserved  | F|
       +---------------+---------------+---------------+---------------+	
    LW1|            RTQnum			   |             NRTQnum		   |
       +---------------+---------------+---------------+---------------+
    LW2|             DQRTlen	       |            DQNRTlen           |
       +---------------+---------------+---------------+---------------+
    LW3|    RTQlen	   |    NRTQlen    | Working_RTQlen|Working_NRTQlen|
       +---------------+---------------+---------------+---------------+
    LW4|    Schcount   |     MaxTQmask          | Reserved              |
       +---------------+---------------+---------------+---------------+
    LW5|            UBRTQnum		   |             DQUBRTlen		   |
       +---------------+---------------+---------------+---------------+
    LW6|             TQ_offset		   |   UBRTQlen    |Working_UBRTQle|
       +---------------+---------------+---------------+---------------+
    LW7|Rtdq_p |Rtdq_c |Nrtdq_p|Nrtdq_c|Ubrdq_p|Ubrdq_c| UBRwPRIcache  |
       +---------------+---------------+---------------+---------------+

 
 R - Reserved
 F - Flow Control
 Rtdq_p - Rtdq_lm_producer
 Rtdq_c - Rtdq_lm_consumer
 Nrtdq_p - Nrtdq_lm_producer
 Nrtdq_c - Nrtdq_lm_consumer
 Ubrdq_p - Ubrdq_lm_producer
 Ubrdq_c - Ubrdq_lm_consumer

  --------------------------------------------------------------------------------

	UPBwPRI table

	    3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 
        1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
       +---------------+---------------+---------------+---------------+
    LW0|              UBR_1vcq           |        UBR_1len             |
       +---------------+---------------+---------------+---------------+	
    LW1|              UBR_2vcq           |        UBR_2len             |
       +---------------+---------------+---------------+---------------+
    LW2|              UBR_3vcq           |        UBR_3len             |
       +---------------+---------------+---------------+---------------+
    LW3|              UBR_4vcq           |        UBR_4len             |
       +---------------+---------------+---------------+---------------+
    LW4|              UBR_5vcq           |        UBR_5len             |
       +---------------+---------------+---------------+---------------+
    LW5|              UBR_6vcq           |        UBR_6len             |
       +---------------+---------------+---------------+---------------+
    LW6|              UBR_7vcq           |        UBR_7len             |
       +---------------+---------------+---------------+---------------+
    LW7|              UBR_8vcq           |        UBR_8len             |
       +---------------+---------------+---------------+---------------+

*/

/*
	PORTSHAPING Table

	      32               16                 0
	      +-----------------+-----------------+
	    0 |            port number            |
	      +-----------------+-----------------+
  	    1 |            port number            |
	      +-----------------+-----------------+
				     	   ...
    	  +-----------------+-----------------+
MAX_PORTS |            port number            |
    	  +-----------------------------------+

*/
 /*
	Departure Queue (DQ) Table

    32               16                 0
    +-----------------+-----------------+---RTDQ cache
  0 |     RTQ len     |   RTQ number	|
    +-----------------+-----------------+
  1 |     RTQ len     |   RTQ number	|
    +-----------------+-----------------+
  2 |     RTQ len     |   RTQ number	|
    +-----------------+-----------------+
  3 |     RTQ len     |   RTQ number	|
    +-----------------+-----------------+---NRTDQ cache
  4 |     NRTQ len    |  NRTQ number	|
    +-----------------+-----------------+
  5 |     NRTQ len    |  NRTQ number	|
    +-----------------+-----------------+
  6 |     NRTQ len    |  NRTQ number	|
    +-----------------+-----------------+
  7 |     NRTQ len    |  NRTQ number	|
    +-----------------+-----------------+---UBRDQ cache
  8 |   UBRTQ len     |  UBRTQ number	|
    +-----------------+-----------------+
  9 |   UBRTQ len     |  UBRTQ number	|
    +-----------------+-----------------+
 10 |   UBRTQ len     |  UBRTQ number	|
    +-----------------+-----------------+
 11 |   UBRTQ len     |  UBRTQ number	|
    +-----------------+-----------------+---Reserved
 13 |              Reserved             |
    +-----------------+-----------------+
 14 |              Reserved             |
    +-----------------+-----------------+
 15 |              Reserved             |
    +-----------------+-----------------+
 16 |              Reserved             |
    +-----------------+-----------------+

*/

/*
	GCRA Table
	    3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 
        1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
       +---------------+---------------+---------------+---------------+
    LW0| TAT1_low													   |
       +---------------+---------------+---------------+---------------+	
    LW1| TAT1_high													   |
       +---------------+---------------+---------------+---------------+
    LW2| TAT2_low												       |
       +---------------+---------------+---------------+---------------+
    LW3| TAT2_high													   |
       +---------------+---------------+---------------+---------------+
    LW4|R R| PRI |       Port#         | X - GFR credit				   |
       +---------------+---------------+---------------+---------------+
    LW5|     tau1      |            T1								   |
       +---------------+---------------+---------------+---------------+
    LW6|     tau2										 |   code	   |
       +---------------+---------------+---------------+---------------+
    LW7| resv.| LR    |            T2								   |
       +---------------+---------------+---------------+---------------+
    LW8|             QUANTIZATION ERROR          |        THmask       |
       +-----------------------------------------+---------------------+

     R - reserved

*/

/* TQ Table - this table has the same structure for RT, NRT and UBR traffic class
			  	     LW(AGGREGATION)		         LW2	 LW1  	 LW0
			   +-------+-------+-------+--...--+-------+-------+-------+
Element1	   | VCQ#  | VCQ#  | VCQ#  |  ...  | VCQ#  | VCQ#  | VCQ#  |
			   +-------+-------+-------+--...--+-------+-------+-------+
Element2	   | VCQ#  | VCQ#  | VCQ#  |  ...  | VCQ#  | VCQ#  | VCQ#  |
			   +-------+-------+-------+--...--+-------+-------+-------+
								   ................
			   +-------+-------+-------+--...--+-------+-------+-------+
Element TQ_TOT | VCQ#  | VCQ#  | VCQ#  |  ...  | VCQ#  | VCQ#  | VCQ#  |
			   +-------+-------+-------+--...--+-------+-------+-------+

*/

/* TQlen Table - this table has the same structure for RT, NRT and UBR traffic class
			      LW0
			   +--------+
Element 1	   | TQ len |
			   +--------+
Element 2	   | TQ len |
			   +--------+
							    ...
			   +--------+
Element TQ_TOT | TQ len |
			   +--------+

*/

/* These are design specific values - do NOT change it! */
#define MAX_STATIC_PORTS                8
#define MAX_CACHED_PORTS                16

/* size of DQ table for one port */
#define	DQ_ELEMENT_SIZE_LOG2			6
#define	DQ_ELEMENT_SIZE					(1<<DQ_ELEMENT_SIZE_LOG2) /* (4 * 3 * 4 + 16)  bytes */

/* size of single PortShaping entry */
#define PORTSHAPING_ENTRY_SIZE_LOG2		2
#define PORTSHAPING_ENTRY_SIZE			(1<<PORTSHAPING_ENTRY_SIZE_LOG2)

/* size of UBRwPRI entry in bytes */
#define UBR_WPRI_ENTRY_SIZE_LOG2		5
#define UBR_WPRI_ENTRY_SIZE				(1<<UBR_WPRI_ENTRY_SIZE_LOG2) /* (8 * 4) bytes */
/* size of PortInfo entry in bytes */
#define PORTINFO_ENTRY_SIZE_LOG2        6
#define PORTINFO_ENTRY_SIZE				(1<<PORTINFO_ENTRY_SIZE_LOG2) /* (16 * 4) bytes */

/* size of Port specific tables in bytes
 * When Port specific tables are in SDRAM then
 * UBRwPRI is placed after Portinfo table
 */
#define PORTDATA_SDRAM_ENTRY_SIZE_LOG2	7
#define PORTDATA_SDRAM_ENTRY_SIZE		(1<<PORTDATA_SDRAM_ENTRY_SIZE_LOG2)
#define PORTDATA_SRAM_ENTRY_SIZE_LOG2	6
#define PORTDATA_SRAM_ENTRY_SIZE		(1<<PORTDATA_SRAM_ENTRY_SIZE_LOG2)

/* HBR Indicator longword */
#define HBR_TQ_INDICATOR_SIZE 4

/* Size of each GCRA entry (in bytes) */
#define GCRA_ENTRY_SIZE_LOG				6
#define GCRA_ENTRY_SIZE					(1<<GCRA_ENTRY_SIZE_LOG)
/* size of the HBR TQ in SRAM */
#define HBR_TQ_SRAM_SIZE				128

/* Multiplier of TQ size - common for all Classes of Service */
#define		TQ_SIZE_MUL						(AGGREGATION_LOG2+1)	/* 2xAGGREGATION elements */

/* Size of a single TQ */
#define 	TQ_MAX_LEN						(1<<TQ_SIZE_MUL)
#define 	TQ_SIZE_SHIFT					(TQ_SIZE_MUL + 2)
#define 	TQ_SIZE							(1<<TQ_SIZE_SHIFT)

/* Size of time queues (in bytes) given as exponent of 2 */
#define		TQLEN_ENTRY_SIZE_SHIFT			2
#define		TQLEN_ENTRY_SIZE				(1<<TQLEN_ENTRY_SIZE_SHIFT)

/* THmask field size in bits */
#define THMASK_SIZE_LOG2                    11

/* Defines N in 2^N formula. If N increse, precision of dividing increse too, but */
/* range of computing decrese. Don't change this !!! */
#define	POW_OF_PRECISION			        15

#ifndef IXP_CLOCK
    #error "IXP_CLOCK not defined !!!"
#endif


/* Number of uE cycles per one timestamp tick. Don't change this, it's h/w dependent !!! */
#define     ONE_TIMESTAMP							16

/* Defines time of single Aggregation slot in timestamps (don't use brackets !!!) */
#ifdef IXP2800
	#ifdef OC48
        #define			ONE_TRANS_SLOT					248
        #define         LINK_RATE_PCR                    (IXP_CLOCK/ONE_TRANS_SLOT)
	#else 
        #ifdef DUAL_OC24    /* This is special mode with two scheduler MEs having OC-24 each */
            #define			ONE_TRANS_SLOT					496
            #define         LINK_RATE_PCR                   ( (IXP_CLOCK/ONE_TRANS_SLOT)/2)
        #else
            #ifdef OC12
                #define			ONE_TRANS_SLOT					992
                #define         LINK_RATE_PCR                    (IXP_CLOCK/ONE_TRANS_SLOT)
            #else
                #error "There is no LineRate definition for ATM TM 4.1 scheduler - OC48 or OC12"
            #endif /* OC12 */
        #endif /* DUAL_OC24 */
    #endif /* OC48 */
#else /* !IXP2800 */
	#ifdef OC48
		#define 		ONE_TRANS_SLOT				106
        #define         LINK_RATE_PCR                (IXP_CLOCK/ONE_TRANS_SLOT)
    #else
        #ifdef OC12
		    #define 		ONE_TRANS_SLOT				426
            #define         LINK_RATE_PCR                (IXP_CLOCK/ONE_TRANS_SLOT)
	    #else
            #error "There is no LineRate definition for ATM TM 4.1 scheduler - OC48 or OC12"
        #endif /* OC12 */
    #endif /* OC48 */
#endif /* IXP2800 */

/*needed for divide by 106 or 248 to obtain the cell tx slot*/
#define     TIME_CONSTANT                   ONE_TRANS_SLOT/ONE_TIMESTAMP

/*  Needed for division in shaper
    (tslot * (ONE_TIMESTAMP / ONE_TRANS_SLOT)) is almost equal to 
	(tslot * (MULT_FAC_FOR_DIVIDE >> MULT_FAC_FOR_DIVIDE))
	The deviation dependt on POW_OF_PRECISION
	We do this trick, because ALU is not able to divide. 
*/
#ifdef DUAL_OC24    /* This is special mode with two scheduler MEs having OC-24 each */

    #define 		MULT_FAC_FOR_DIVIDE			((((1 << POW_OF_PRECISION)*ONE_TIMESTAMP)/ONE_TRANS_SLOT)*2)

#else /* !DUAL_OC24 */

    #define 		MULT_FAC_FOR_DIVIDE			(((1 << POW_OF_PRECISION)*ONE_TIMESTAMP)/ONE_TRANS_SLOT)

#endif /* DUAL_OC24 */


#ifdef MICROCODE

#ifdef SUPPORT_2K_PORTS

    /* PortInfo & UBRwPRI structures address base in LM
     * Each of 16 PortInfo entries is 16 LW 
     */
    #define 		PORTINFO_LM_BASE				0x000
    #define 		PORTINFO_LM_SIZE				(MAX_CACHED_PORTS*PORTINFO_ENTRY_SIZE)	

    /* PortShaping base address in LM
     * Portshaping table cache is 16 elements
     */
    #define 		PORTSHAPING_LM_BASE				(PORTINFO_LM_BASE + PORTINFO_LM_SIZE)
    #define 		PORTSHAPING_STRUCT_SIZE			(MAX_CACHED_PORTS*PORTSHAPING_ENTRY_SIZE)

    /* Departure queue cache in LM
     * Each DQ table is 16LW (only 12LW are used)
     */
    #define 		DQ_CACHE_LM_BASE				(PORTSHAPING_LM_BASE + PORTSHAPING_STRUCT_SIZE)
    #define			DQ_CACHE_ENTRY_SIZE				(MAX_CACHED_PORTS*DQ_ELEMENT_SIZE)

    /* Time queue base for the HBR VCs in scheduler local memory
     */
    #define			HBR_TQ_LM_BASE 					(DQ_CACHE_LM_BASE + DQ_CACHE_ENTRY_SIZE)
    #define			HBR_TQ_LM_SIZE 					(HBR_TQ_SRAM_SIZE)

    /* HBR/UBR VCQ cell count base in scheduler local memory
     */
    #define			VCQ_LEN_LM_BASE 				(HBR_TQ_LM_BASE + HBR_TQ_LM_SIZE)
    #define			VCQ_LEN_LM_SIZE					(HBR_TQ_SRAM_SIZE *2)

#else /* SUPPORT_2K_PORTS */

    /* PortInfo structure address base in LM 
     * There is place for up to 8 ports, each PortInfo entry is 16LWs
     */
    #define 		PORTINFO_LM_BASE				0x000
    #define 		PORTINFO_LM_SIZE				(MAX_STATIC_PORTS*PORTINFO_ENTRY_SIZE)
    
    /* UBRwPRI structure address base in LM 
     * There is place for up to 8 ports, each UBRwPRI entry is 8LWs
     */
    #define 		UBRWPRI_LM_BASE					(PORTINFO_LM_BASE + PORTINFO_LM_SIZE)
    #define 		UBRWPRI_LM_SIZE					(MAX_STATIC_PORTS*UBR_WPRI_ENTRY_SIZE)

    /* PortShaping base address in LM
     * Portshaping table cache is 16 elements
     */
    #define 		PORTSHAPING_LM_BASE				(UBRWPRI_LM_BASE + UBRWPRI_LM_SIZE)
    #define 		PORTSHAPING_STRUCT_SIZE			(MAX_CACHED_PORTS*PORTSHAPING_ENTRY_SIZE)

    /* Departure queue cache in LM
     * Each DQ table is 16LW (only 12LW are used)
     */
    #define 		DQ_CACHE_LM_BASE				(PORTSHAPING_LM_BASE + PORTSHAPING_STRUCT_SIZE)
    #define			DQ_CACHE_ENTRY_SIZE				(MAX_STATIC_PORTS*DQ_ELEMENT_SIZE)

    /* Time queue base for the HBR VCs in scheduler local memory
     */
    #define			HBR_TQ_LM_BASE 					(DQ_CACHE_LM_BASE + DQ_CACHE_ENTRY_SIZE)
    #define			HBR_TQ_LM_SIZE 					(HBR_TQ_SRAM_SIZE)

    /* HBR/UBR VCQ cell count base in scheduler local memory
     */
    #define			VCQ_LEN_LM_BASE 				(HBR_TQ_LM_BASE + HBR_TQ_LM_SIZE)
    #define			VCQ_LEN_LM_SIZE					(HBR_TQ_SRAM_SIZE * 2)

#endif /* SUPPORT_2K_PORTS */

/*
    #if (VCQ_LEN_LM_BASE+VCQ_LEN_LM_SIZE) > (640*4)
	    #error "Too many MAX_ATM_PORTS, there is no LM to fit data structures to"
    #endif
*/


/*------------------------------------------------------------------------------
 * ATM TM4.1 SCHEDULER definitions
 */

/* We have to define how many ports is serviced by each Scheduler */
#ifdef FIRST_SCHEDULER_ME
	#define 	MAX_ATM_PORTS_PER_ME						(MAX_ATM_PORTS/2)
#else
	#ifdef SECOND_SCHEDULER_ME
		#define 	MAX_ATM_PORTS_PER_ME					(MAX_ATM_PORTS/2)
	#else
		#define 	MAX_ATM_PORTS_PER_ME					(MAX_ATM_PORTS/1)
	#endif
#endif

#else /* MICROCODE */



#endif /* MICROCODE */

#endif /* ATM_TM_DEFS_H */
