/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      ATM TM4.1 Core Component - packet handler
 *
 * = FILENAME
 *      ix_cc_atmtm41_pkt_handlers.c
 *
 * = DESCRIPTION
 *      The file defines packet handler interface functions.
 *
 * = AUTHOR
 *       Jaroslaw Kogut
 *       jaroslaw.kogut@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 */



/**
 * System defined include files
 */


/**
 * User defined include files
 */
#include "ix_cc_error.h"

#include "ix_rm.h"
#include "ix_ossl.h"

#include "ix_cc.h"
#include "bindings.h"
#include "cc/ix_cc_atmsar.h"
#include "cc/ix_cc_atmsar_plugin.h"
#include "cc/ix_cc_atmtm41_cci.h"
#include "cc/internal/ix_cc_atmtm41_private.h"


/**
 * Preprocessor symbols and Macros used in this file
 */

/**
 * Type definitions whose scope is limited to this file
 */


/**
 * Variable declarations global to this file only. Externs are followed by 
 * static variables.
 */


/** 
 * Extern function prototypes.
 */


/** 
 * Static function prototypes.
 */


/** 
 * Function definitions.
 */



/**
 * NAME: ix_cc_atmtm41_pkt_handler
 *
 * DESCRIPTION: This is the only registered function to receive exception packets from
 * high priority queue of ATM RX microblock. This function sends the packet to stack driver
 * (ie, recieves only local delivery packets). 
 * 
 * @Param:  - IN arg_hBuffer: handle to a buffer which contains exception packets
 *  from ATM RX microblock
 * @Param: - IN arg_ExceptionCode: will be ignored.
 * @Param: - IN arg_pContext: pointer to ATM RX core component context.
 * @Param:  - OUT none
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_SEND_FAIL - error from CCI
 * 
 */

ix_error ix_cc_atmtm41_pkt_handler(
ix_buffer_handle arg_hBuffer,  
ix_uint32 arg_ExceptionCode,
void* arg_pContext)
{

    ix_error err = IX_SUCCESS;

  
    switch(arg_ExceptionCode)
    {
    default:
        IX_ERROR_CRT(ix_rm_buffer_free_chain(arg_hBuffer),IX_CC_ERROR_SEND_FAIL,0);
        return IX_ERROR_WARNING(IX_CC_ERROR_UNDEFINED_EXCEP,
                               ("undefined exception code"));
        break;
    }/* end switch */


    if(err != IX_SUCCESS)
    {
        IX_ERROR_CRT(ix_rm_buffer_free_chain(arg_hBuffer),IX_CC_ERROR_SEND_FAIL,0);
        return IX_ERROR_WARNING(IX_CC_ERROR_SEND_FAIL,
                                ("packet send failed - high priority"));
    }/* end if (err != IX_SUCCESS) */     

   
   return IX_SUCCESS;

} /* end ix_cc_atmtm41_pkt_handler */

