/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      ATM RX Core Component - message handler
 *
 * = FILENAME
 *      ix_cc_atmtm41_msg_handler.c
 *
 * = DESCRIPTION
 *      The file defines message handler interface functions.
 *
 * = AUTHOR
 *       Jaroslaw Kogut
 *       jaroslaw.kogut@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *     
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 */


/**
 * System defined include files
 */
#include "ix_cc_error.h"
#include "ix_ossl.h"
#include "ix_rm.h"
#include "ix_cc.h"
#include "ix_cc_macros.h"
#include "ix_cc_properties.h"
#include "bindings.h"
#include "cc/ix_cc_msup.h"
#include "cc/ix_cc_atmsar.h"
#include "cc/ix_cc_atmsar_plugin.h"

/**
 * User defined include files
 */
#include "cc/ix_cc_atmtm41_cci.h"
#include "cc/internal/ix_cc_atmtm41_private.h"


/**
 * Preprocessor symbols and Macros used in this file
 */
/* Flag fornot to send report to msg support lib*/
#define IX_CC_ATMTM41_SEND_NO_RESPONSE 1 

/**
 * Type definitions whose scope is limited to this file
 */
typedef union ix_u_cc_atmtm41_msg_handler_return_data
{
} ix_cc_atmtm41_msg_handler_return_data;

/**
 * Variable declarations global to this file only. Externs are followed by 
 * static variables.
 */

/** 
 * Extern function prototypes.
 */


/** 
 * Static function prototypes.
 */


/** 
 * Function definitions.
 */


/**
 * NAME: ix_cc_atmtm41_msg_handler
 *
 * DESCRIPTION:
 *    This primitive is the message handler function for this core component.
 *    The core component receives messages from other core component through
 *    this message handler function and internally it calls appropriate library
 *    function to process the message. This message handler shall be used to
 *    update dynamic properties.
 * 
 * @Param:  IN  arg_hDataToken : buffer handle embedding information for the
 *                   message passed in arg_UserData.
 * @Param:  IN  arg_UserData : message type
 * @Param:  IN  arg_pContext: pointer to this component context that will be
 *                  passed to the core component when a message arrives. This
 *                  context was defined by the core component and passed to
 *                  core components infrastructure through core component
 *                  init function.
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 *    IX_CC_ERROR_NULL - null argument
 *    IX_CC_ERROR_UNDEFINED_MSG - un supported message
 *    IX_CC_ATMTM41_ERROR_MSG_LIBRARY - error from message support library
 *    IX_CC_ATMTM41_ERROR_BUFFER_FREE - error from RM for freeing buffer
 */
ix_error ix_cc_atmtm41_msg_handler(
ix_buffer_handle arg_hDataToken,  
ix_uint32 arg_UserData,
void* arg_pContext)
{
#if 0
    ix_error err = IX_SUCCESS;
    void *pContext = NULL;
    void *pMsg = NULL;
    void *pRetMsg = NULL;
    /*ix_cc_atmtm41_msg_handler_return_data msgRetData;*/
    ix_uint32 msgRetLength = 0;
    ix_uint32 noResponse = 0;  

    
    /* Validate arg_pContext */
    if(arg_pContext == NULL)
    {
        return IX_ERROR_WARNING(IX_CC_ERROR_NULL,
                                ("arg_pContext is NULL"));
    }/* end if(arg_pContext == NULL) */

    if((arg_UserData < IX_CC_COMMON_MSG_ID_FIRST) ||
       (arg_UserData >= _IX_CC_ATMTM41_MSG_LAST))
    {
    
        return IX_ERROR_WARNING(IX_CC_ERROR_UNDEFINED_MSG,
                                ("Invalid Message Type"));
    }/* end if */

    /*IX_MSUP_EXTRACT_MSG(arg_hDataToken,&pMsg,&pContext);*/

    /* Check for route messages, next hop message, icmp messages and statistics message*/
    switch(arg_UserData)
    {
        /* the message is not used now */
    case IX_CC_ATMTM41_TEST_MSG:
        noResponse = IX_CC_ATMTM41_SEND_NO_RESPONSE;
        _IX_CC_ATMTM41_DBG_INIT(("Test message received...\n"));
        break;
    default:
        if(pMsg == NULL)
        {
            return IX_ERROR_WARNING(IX_CC_ERROR_NULL,
                                    ("Invalid Buffer"));
        }/* end if(pContext == NULL) */
        IX_ERROR_CRT(ix_rm_buffer_free_chain(arg_hDataToken),
                     IX_CC_ATMTM41_ERROR_BUFFER_FREE,0);  
        return IX_ERROR_WARNING(IX_CC_ERROR_UNDEFINED_MSG,
                                ("Invalid Message Type"));
        break;
    }/* end switch(arg_UserData) */


    if(noResponse == IX_CC_ATMTM41_SEND_NO_RESPONSE)
    {
        IX_ERROR_CRT(ix_rm_buffer_free_chain(arg_hDataToken),
                     IX_CC_ATMTM41_ERROR_BUFFER_FREE,0);  
        return IX_SUCCESS;
    }/* end if no need to send message to msg support lib*/


    /* send return message, length and retrieved context to message support library */
    err = ix_cc_msup_send_reply_msg(pContext,pRetMsg,msgRetLength,err);
    if(err != IX_SUCCESS)
    {
        err = IX_ERROR_WARNING(IX_CC_ATMTM41_ERROR_MSG_LIBRARY,
                               ("Send reply message failed"));
    }/* endif (err != IX_SUCCESS) */

    IX_ERROR_CRT(ix_rm_buffer_free_chain(arg_hDataToken),
                 IX_CC_ATMTM41_ERROR_BUFFER_FREE,0);
    return err;
#else
    return IX_SUCCESS;
#endif
} /* end ix_cc_atmtm41_msg_handler */

