/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2400 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      ATM RX Core Component
 *
 * = FILENAME
 *      ix_cc_atmtm41.h
 *
 * = DESCRIPTION
 *      This file defines all exported data types and function prototypes
 *
 * = AUTHOR
 *       Jaroslaw Kogut
 *       jaroslaw.kogut@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *     
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * 
 */

#if !defined(__IX_CC_ATMTM41_CCI_H__)
#define __IX_CC_ATMTM41_CCI_H__

#include "ix_rm.h"
#include "ix_ossl.h"
#include "ix_cc.h"
#include "ix_cc_properties.h"

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * TYPENAME: ix_cc_atmtm41_error_code
 * 
 * DESCRIPTION: This enumerated type will describe atmtm41 error codes
 *
 */
typedef enum ix_e_cc_atmtm41_error_code
{
    IX_CC_ATMTM41_ERROR_FIRST = IX_ERROR_MAKE_GROUP(CC_ATMTM41),
    IX_CC_ATMTM41_ERROR_SUCCESS = IX_CC_ATMTM41_ERROR_FIRST,

    IX_CC_ATMTM41_ERROR_FAILED_PATCHING,
    IX_CC_ATMTM41_ERROR_REGISTRY,
    IX_CC_ATMTM41_ERROR_BUFFER_FREE,

    IX_CC_ATMTM41_ERROR_CCI,
    IX_CC_ATMTM41_ERROR_INVALID_CONTEXT,
    IX_CC_ATMTM41_ERROR_INVALID_CALLBACK,
    IX_CC_ATMTM41_ERROR_INVALID_INPUT_PARAM,
    IX_CC_ATMTM41_ERROR_INVALID_BUFFER,
    IX_CC_ATMTM41_ERROR_MSG_LIBRARY,
    IX_CC_ATMTM41_ERROR_INVALID_PACKET,
    IX_CC_ATMTM41_ERROR_INVALID_MASK,

    IX_CC_ATMTM41_ERROR_INVALID_FLAGS,
    IX_CC_ATMTM41_ERROR_INVALID_PACKETS_TO_DRAIN,
    IX_CC_ATMTM41_ERROR_INVALID_PARAM,

    IX_CC_ATMTM41_ERROR_CALLBACK,
    
    /* unknown error code */
    IX_CC_ATMTM41_ERROR_UNKNOWN,
    IX_CC_ATMTM41_ERROR_LAST
} ix_cc_atmtm41_error_code;


/******************************************************************************
 *              CORE COMPONENT INFOSTRUCTURE (CCI) FUNCTIONS
 *****************************************************************************/

/**
 * NAME: ix_cc_atmtm41_init
 *
 * DESCRIPTION: 
 * 
 * @Param:  IN  arg_hCcHandle: handle to ATM RX core component, created by core
 *                 component infrastructure; This shall be used later to get
 *                 other (to add event handler) services from core component
 *                 infrastructure.
 *
 * @Param:  OUT arg_ppContext: location where the pointer to the control block
 *                 allocated by the core component will be stored. The control
 *                 block is internal to the core component and it contains
 *                 information about  internal data structures, allocated memory
 *                 and other relevant information. Later this pointer to be
 *                 passed into fini() function for freeing memory and other
 *                 house keeping operations when the component is being
 *                 destroyed.
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 *    IX_CC_ERROR_OOM   - memory allocation failure      
 *    IX_CC_ATMTM41_ERROR_FAILED_PATCHING   - patching failures                      
 *    IX_CC_ERROR_OOM_64BIT_COUNTER - 64 bit counter creation failure
 *    IX_CC_ATMTM41_ERROR_CCI - failure from CCI 
 */
ix_error ix_cc_atmtm41_init(
ix_cc_handle arg_hCcHandle,
void** arg_ppContext);


/**
 * NAME: ix_cc_atmtm41_fini
 *
 * DESCRIPTION: 
 * 
 * @Param:  IN arg_hCcHandle : handle to ATM RX core component
 * @Param:  IN arg_pContext : ppointer to the control block memory
 *                 allocated earlier in ix_cc_atmtm41_init function.
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 *    IX_CC_ATMTM41_ERROR_INVALID_INPUT_PARAM - invalid input parameter(s)
 *    IX_CC_ERROR_OOM   - failure of memory deletion                
 *    IX_CC_ERROR_OOM_64BIT_COUNTER - failure of  64 bit counter deletion 
 *    IX_CC_ATMTM41_ERROR_CCI - failure from CCI
 */
ix_error ix_cc_atmtm41_fini(
ix_cc_handle arg_hCcHandle,
void* arg_pContext);


/**
 * NAME: ix_cc_atmtm41_msg_handler
 *
 * DESCRIPTION:
 *    This primitive is the message handler function for ATM RX core component.
 *    The core component receives messages from other core component through
 *    this message handler function and internally it calls appropriate library
 *    function to process the message. This message handler shall be used to
 *    update dynamic properties.
 * 
 * @Param:  IN  arg_hDataToken: buffer handle embedding information for the
 *                  message passed in arg_UserData.
 * @Param:  IN  arg_UserData: message type
 * @Param:  IN  arg_pContext: pointer to the core component context that will be
 *                  passed to the core component when a message arrives. This
 *                  context was defined by the core component and passed to core
 *                  components infrastructure through core component init
 *                  function.
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 *    IX_CC_ERROR_NULL - null argument
 *    IX_CC_ATMTM41_ERROR_INVALID_CONTEXT - context is unusable
 *    IX_CC_ERROR_UNDEFINED_MSG - un supported message
 *    IX_CC_ATMTM41_ERROR_MSG_LIBRARY - error from message support library
 */
ix_error ix_cc_atmtm41_msg_handler(
ix_buffer_handle arg_hDataToken,
ix_uint32 arg_UserData,
void* arg_pContext);

/**
 * NAME: ix_cc_atmtm41_pkt_handler
 *
 * DESCRIPTION:
 *    This is the only registered function to receive exception packets from
 *    ATM RX microblock
 * 
 * @Param:  IN  arg_hDataToken: handle to a buffer which contains exception
 *                  packets from ATM RX microblock
 * @Param:  IN  arg_ExceptionCode: will be ignored.
 * @Param:  IN  arg_pContext: pointer to the core component context that will be
 *                  passed to the core component when a message arrives. This
 *                  context was defined by the core component and passed to core
 *                  components infrastructure through init function.
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 *    IX_SUCCESS - Lookup successful
 *    IX_CC_ATMTM41_ERROR_CCI - error from CCI
 */
ix_error ix_cc_atmtm41_pkt_handler(
ix_buffer_handle arg_hDataToken,  
ix_uint32 arg_ExceptionCode,
void* arg_pContext);


/******************************************************************************
 *                   LEVEL 0 API (LIBRARY) FUNCTIONS
 *****************************************************************************/


/******************************************************************************
 *                    MESSAGE HELPER FUNCTIONS
 *****************************************************************************/


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_ATMTM41_CCI_H__) */
