////////////////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name:ppp.uc
//
//      Purpose: This file contains the  macro which implements the 
//		PPP deencupsolation
//
//      History:
//
//
//      Date            Comment                         			By
//      --------------------------------------------------------------------------------	
//
//      05/29/2002      Created                         			David Meng
//
//
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef	__PPP_UC__
#define	__PPP_UC__

/////////////////////////////////////////////////////////////////////////////////////////

//	Include Files

// include xbuf.uc from IXPblocks portable library
#include	"xbuf.uc"
#include	"sig_macros.uc"
#include	"dl_source.uc"
#include 	"ppp.h"

// include Ether files for initialization, utilities such as


/////////////////////////////////////////////////////////////////////////////////////////

//	Constants 
//	None.

/////////////////////////////////////////////////////////////////////////////////////////

//	Global Registers
//	Use DL variables.

/////////////////////////////////////////////////////////////////////////////////////////

//	Global Signals
//	None.

/////////////////////////////////////////////////////////////////////////////////////////
//
// _ppp_decap()
//
//	 	Description: 
//
//		
//
//	 	Outputs:
//
//		
//		
//
//		Inputs:
//
//		
//
//		
//		
//
//		
//		
//		Size: 
//
//		
//
////////////////////////////////////////////////////////////////////////////////////////
#macro	_ppp_decap()

.begin
.reg offset
.reg size
		
		// update 	offset

		dl_meta_get_offset[offset]
		alu[offset, offset, +, PPP_HEADER_LENGTH]
		dl_meta_set_offset[offset]

		// update paket size

		dl_meta_get_packet_size[size]
		alu[size, size, -, PPP_HEADER_LENGTH]
		dl_meta_set_packet_size[size]

		dl_meta_get_buffer_size[size]
		alu[size, size, -, PPP_HEADER_LENGTH]
		dl_meta_set_buffer_size[size]
.end 
#endm

/////////////////////////////////////////////////////////////////////////////////////////
//
// _ppp_classify()
//
//	 	Description: 
//
//		
//
//	 	Outputs:
//			dl_next_block
//			
//		
//
//		Inputs:
//			$$iphdr0: PPP frame type and IP version
//		
//
//		
//		
//
//		
//		
//		Size: 
//
//		
//
////////////////////////////////////////////////////////////////////////////////////////
#macro	_ppp_classify(in_header, IN_HEADER_OFFSET)

.begin
.reg	type
	
	_ppp_get_pkt_type(type, in_header, IN_HEADER_OFFSET)

	.if(type == PPP_IPV4)									; This is an IP packet .
		dl_meta_set_header_type(PPP_IPV4_TYPE)				; Set IPv4 type.
		alu[dl_next_block, --, B, BID_PPP_DECAP_NEXT1]
	.elif(type == PPP_MPLS_UNICAST)
		dl_meta_set_header_type(PPP_MPLS_TYPE)				; Set MPLS type.
		alu[dl_next_block, --, B, BID_PPP_DECAP_NEXT2]	 
	.elif(type == PPP_IPV6)									; This is an IPv6 packet.
		dl_meta_set_header_type(PPP_IPV6_TYPE)				; Set IPv4 type.
		alu[dl_next_block, --, B, BID_PPP_DECAP_NEXT3]
	.else
		dl_meta_set_header_type(UNKNOWN_TYPE)
		dl_set_exception(BID_POS, 1)
		alu[dl_next_block, --, B, BID_EXCEPTION]			; Send the packet to core.
	.endif

.end 
#endm

/////////////////////////////////////////////////////////////////////////////////////////
//
// _ppp_encap()
//
//	 	Description: 
//
//		
//
//	 	Outputs:
//
//		
//		
//
//		Inputs:
//
//		
//
//		
//		
//
//		
//		
//		Size: 
//
//		
//
////////////////////////////////////////////////////////////////////////////////////////
#macro	_ppp_encap()

.begin
.reg offset
.reg size
		
		// update 	offset

		dl_meta_get_offset[offset]
		alu[offset, offset, -, PPP_HEADER_LENGTH]
		dl_meta_set_offset[offset]

		// update paket size

		dl_meta_get_packet_size[size]
		alu[size, size, +, PPP_HEADER_LENGTH]
		dl_meta_set_packet_size[size]

		dl_meta_get_buffer_size[size]
		alu[size, size, +, PPP_HEADER_LENGTH]
		dl_meta_set_buffer_size[size]
.end 
#endm


///////////////////////////////////////////////////////////////////////////////
//
// _ppp_get_pkt_type()
//
//	 	Description: 
//				get PPP packet type 
//			
//
//	 	Outputs:
//				type:	PPP packet type
//		Inputs:
//
//			ppp_hdr_buf		:	ppp packet header buffer 
//		Size: 
//
//			1 instructions at a minimum. (max depends on the loop)
//
///////////////////////////////////////////////////////////////////////////////

#macro _ppp_get_pkt_type(type, ppp_buf, pkt_offset)
.begin
	xbuf_extract[type, ppp_buf, pkt_offset,\
				PPP_TYPE_START, PPP_TYPE_LEN]				; get frame type

.end
#endm


///////////////////////////////////////////////////////////////////////////////
//
// _ppp_decap_classify(ppp_hdr_buf)
//
//	 	Description: 
//				
//				PPP packet decap and classification
//			
//
//	 	Outputs:
//				dl_next_block
//		Inputs:
//			
//			ppp_hdr_buf		:	Ethernet header buffer 
//		Size: 
//
//			 instructions at a minimum. (max depends on the loop)
//
///////////////////////////////////////////////////////////////////////////////

#macro _ppp_decap_classify(in_header,IN_HEADER_OFFSET)

	br!=byte[dl_next_block,0,BID_POS,ppp_decap_classify_end#]
	_ppp_decap()

#ifdef	INCLUDE_PKT_CKSUM
		// since we removed the PPP header, we need to update the packet 
		// checksum.
		.begin
		.reg over_all_cksum hdr_cksum
		
			// We assume 2 byte protocol field as PPP header.

			xbuf_extract[hdr_cksum, in_header, IN_HEADER_OFFSET, 0, 2)
			dl_meta_get_cksum(over_all_cksum)
			// now we need to subtract this from the overall checksum
			alu[hdr_cksum, --, ~B, hdr_cksum]
			alu[hdr_cksum, over_all_cksum, + , hdr_cksum]
			alu[over_all_cksum, 0x0, +carry, hdr_cksum]	// upper 16bits might be set
			dl_meta_set_cksum(over_all_cksum)
		.end
#endif

	_ppp_classify(in_header, IN_HEADER_OFFSET)

ppp_decap_classify_end#:
#endm

#endif	//	__PPP_UC__