/*--------------------------------------------------------------------------
 *                                                                     
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *--------------------------------------------------------------------------
 */

#ifndef	__PPP_C__
#define	__PPP_C__

#include	"ppp.h"
#include	"ixp_ipv4.c"
	
extern __declspec(gp_reg) int 	dlNextBlock;
extern dl_meta_t dlMeta;

/**************************************************************************
 * _ppp_get_pkt_type
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE	int _ppp_get_pkt_type(void *p_pkt,UINT in_offset,mem_t memType)
{
	int type;

	type = _buf_byte_extract((UINT*)p_pkt,in_offset,PPP_HEADER_LENGTH,memType);

	return (type);

}


/**************************************************************************
 * _ppp_decap
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE void	_ppp_decap(void)
{
	/* simply strip off the PPP header */

	dlMeta.offset += PPP_HEADER_LENGTH;
	dlMeta.bufferSize -= PPP_HEADER_LENGTH;
	dlMeta.packetSize -= PPP_HEADER_LENGTH;

	return;
}

/**************************************************************************
 * _ppp_classify
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE void	_ppp_classify(void *p_pkt,UINT in_offset,mem_t memType)
{
	int type;

	type = _ppp_get_pkt_type(p_pkt,in_offset,memType);

	if (type == PPP_IPV4)
	{
		dlMeta.headerType = PPP_IPV4_TYPE;
		dlNextBlock = TARGET_PPP_IPV4;
	}
#ifdef MPLSoPPP_DECAP
	else if (type == PPP_MPLS_UNICAST)
	{
		dlMeta.headerType = MPLS_TYPE;
		dlNextBlock = TARGET_PPP_MPLS;
	}
	else if (type == PPP_MPLSCP)
	{
		dlMeta.headerType = MPLSCP_TYPE;
		dlNextBlock = TARGET_PPP_MPLSCP;
	}
#endif
	else if (type == PPP_IPV6)
	{
		dlMeta.headerType = PPP_IPV6_TYPE;
		dlNextBlock = TARGET_PPP_IPV6;
	}
	else
	{
		dlMeta.headerType = UNKNOWN_TYPE;
		dlNextBlock = TARGET_PPP_EXCEPTION;
	}

	return;

}

/**************************************************************************
 * _ppp_decap_classify
 *
 *		Descrpiton 	:
 *		
 *		Outputs		:
 *
 *		Inputs		:
 */
INLINE void	ppp_decap_classify(void *p_pkt,UINT in_offset,mem_t memType)
{
	
	if (dlNextBlock != BID_POS)
		return;

	_ppp_decap();

	_ppp_classify(p_pkt,in_offset,memType);

	return;
}

#endif	// end __PPP_C__