/*------------------------------------------------------------------------------
                                                                      
                   I N T E L   P R O P R I E T A R Y                   
                                                                       
      COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
      THE PRIOR WRITTEN PERMISSION OF :                                
                                                                       
                         INTEL  CORPORATION                            
                                                                      
                      2200 MISSION COLLEGE BLVD                        
                                                                       
                SANTA  CLARA,  CALIFORNIA  95052-8119                  
                                                                       
------------------------------------------------------------------------------



      File Name: 	llc_snap_decap.h

      Purpose: 	This file contains #defines for LLC/SNAP decap block
					

      History:


      Date            Comment                         By
      ------------------------------------------------------------------------

		07/9/2002		Created							Minal Patel

------------------------------------------------------------------------------*/


#ifndef	_LLC_SNAP_DECAP_H_
#define _LLC_SNAP_DECAP_H_

/* ===========================================================================*/
/*		Currently llc_snap_decap() handles raw frames without encapsulation
		(IPv4) and LLC-SNAP encapsulation (EtherType_IPv4) ONLY				  */
/* ===========================================================================*/


/* The offset at which the header starts in __PKTHDR, which is read from DRAM */
#define 	AAL5_HDR_OFFSET			0


/*---------------------------------------------------------------------------*/
/*	  Packet Protocols/Payload types										 */
/*---------------------------------------------------------------------------*/
								
#define 	PKT_PROTO_NULL			0x0   /* Null protocol; denotes an 
											   unsupported protocol  	 */
#define 	PKT_PROTO_LLC_SNAP		0x1   /*  LLC-SNAP encapsulation 	 */	
#define 	PKT_PROTO_IPV4			0x2   /*  IP version 4 		  		 */
#define 	PKT_PROTO_IPV6			0x3   /*  IP version 6          	 */
#define 	PKT_PROTO_ETHER			0x4   /*  Ethernet.         	   	 */
#define 	PKT_PROTO_ARP			0x5   /*  ARP  					     */
#define 	PKT_PROTO_PPP_DISCOVERY	0x6   /*  PPP DISCOVERY   	         */
#define 	PKT_PROTO_PPP_SESSION	0x7   /*  PPP SESSION				 */
#define		PKT_PROTO_MPLS_UNICAST	0x8	  /*  MPLS unicast               */

/*---------------------------------------------------------------------------*/
/*  LLC (IEEE 802.2) encapsulation with SNAP header (IEEE 802.1a)			 */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
	LLC-type1 (un acknowledged connectionless mode)

				|---------------------------|
				|  DSAP  |   SSAP  |  Ctrl  |
				|---------------------------|
					1B		1B			1B
	SNAP header
				|--------------------------------------------|
				|			OUI				|		PID	     |
				|--------------------------------------------|
								3B				    2B
				Organizationally Unique ID	| Protocol ID


				OUI = 00 00 00 (for Ethernet type)
				So we would just check for PID values in SNAP header.
---------------------------------------------------------------------------*/

#define 	LLC_SNAP				0xAAAA03	

#define 	LLC_SNAP_HDR_SIZE		8					/* in bytes */

#define		SNAP_HDR_PID_START		6					/* in bytes */
#define 	SNAP_HDR_PID_SZ			2					/* in bytes */


/*  EtherType values in SNAP header	for different types of PDUs */

#define 	ETHER_IPV4_PID				0x0800	/* IP version 4 	   */
#define 	ETHER_IPV6_PID				0x86DD	/* IP version 6 	   */
#define 	ETHER_ARP_PID				0x0806	/* ARP 				   */
#define 	ETHER_PPP_DISCOVERY_PID		0x8863 	/* PPP Discovery phase */
#define 	ETHER_PPP_SESSION_PID		0x8864 	/* PPP Session phase   */
#define		ETHER_MPLS_UNICAST_PID		0x8847  /* MPLS unicast        */
#define		ETHER_MPLS_MULTICAST_PID	0x8848  /* MPLS multicast      */


/*---------------------------------------------------------------------------*/
/* LLC (IEEE 802.2) encapsulation for routed PDU in ISO NLPID format         */
/*  				Currently NOT supporting LLC-NLPID						 */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
	LLC-type1 (un acknowledged connectionless mode)

				|---------------------------|
				|  DSAP  |   SSAP  |  Ctrl  |
				|---------------------------|
					1B		1B			1B
	NLPID
				|--------|
				| NLPID  |
				|--------|
					1B				   
				Protocol ID

---------------------------------------------------------------------------*/

#define		LLC_NLPID				0xFEFE03	

#define 	LLC_NLPID_HDR_SIZE		4					/* in bytes */

#define		NLPID_START				3					/* in bytes */
#define 	NLPID_SZ				1					/* in bytes */

/* Some possible LLC/NLPID protocol ids:  */
#define 	NLPID_NULL				0x00	/*   Null network layer 
												(must not be used)*/
#define 	NLPID_SNAP				0x80	/*   SNAP.                      */
#define 	NLPID_ISO_CLNP			0x81	/*   ISO CLNP.                  */
#define 	NLPID_ISO_ESIS			0x82	/*   ISO ESIS.                  */
#define 	NLPID_ISO_ISIS			0x83	/*   ISO ISIS.                  */
#define 	NLPID_IP				0xCC	/*   IP (must not be used for IP 
												 over ATM. Instead IP datagrams 
												 must be identified by a SNAP 
												 header) */
/* 
	From RFC 2684 

	"LLC Encapsulation" method allows multiplexing of multiple protocols over a
	single ATM VC. The protocol type of each PDU is identified by a prefixed
	IEEE 802.2 LLC header

    In "VC Multiplexing" (without LLC header) each VC carries PDUs of
    exactly one protocol type.

*/			
#endif	// _LLC_SNAP_DECAP_H_

