/*//////////////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name:eher.h
//
//      Purpose: This file contains the  constants used in the Ethernet frame
//				 processing micro code 
//
//      History:
//
//
//      Date            Comment                         			By
//      --------------------------------------------------------------------------------	
//
//      06/13/2002      Created                         			David Meng
//
//
////////////////////////////////////////////////////////////////////////////////////////*/

#ifndef		__ETHER_H__
#define		__ETHER_H__

#define		ETHER_HEADER_OFFSET		0
#define 	MAC_HI_START			0
#define		MAC_LO_START			4
#define		FRAME_TYPE_START		12
#define		ETHER_IP_VER_START		14

#define 	MAC_HI_LEN				4
#define		MAC_LO_LEN				2
#define		FRAME_TYPE_LEN			2
#define		IP_VER_LEN				1
#define		IP_VER_MSK				0xF

#define ETHER_HEADER_LENGTH			14
#define ETHER_CRC_LENGTH			4

#ifdef	INCLUDE_PKT_CKSUM
#define	ETHER_PROTO_START			8
#define	ETHER_PROTO_LEN				2
#endif

#define	ETHER_RX_UCAST				0x1
#define	ETHER_RX_MCAST				0x2
#define	ETHER_RX_BCAST				0x4
#define ETHER_MCAST_BIT				24
#define ETHER_BC_MAC_HI				0xFFFFFFFF
#define ETHER_BC_MAC_LO				0xFFFF


#define ETHER_IPV4					0x0800
#define ETHER_ARP					0x0806
#define ETHER_IPV6					0x86DD
#define ETHER_MPLS_UCAST			0x8847
#define ETHER_MPLS_MCAST			0x8848
#define ETHER_PPP_DISCOVERY 		0x8863 	/* PPP Discovery phase */
#define ETHER_PPP_SESSION			0x8864


#define	ETHER_IPV4_TYPE				0x01
#define ETHER_IPV6_TYPE				0x02
#define	ETHER_ARP_TYPE				0x03
#define	ETHER_MPLS_UCAST_TYPE		0x04
#define	ETHER_MPLS_MCAST_TYPE		0x05
#define	ETHER_PPP_DISCOVERY_TYPE	0x06
#define	ETHER_PPP_SESSION_TYPE		0x07

#ifndef UNKNOWN_TYPE
#define UNKNOWN_TYPE				0x00
#endif

#endif	//	end __ETHER_H__


