/*--------------------------------------------------------------------------
 *                                                                     
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  2003 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *--------------------------------------------------------------------------
 */

#ifndef	__ETHER_C__
#define	__ETHER_C__

#include	"ether.h"
#include	"ixp_ipv4.c"

#define FRAME_TYPE_LENGTH    2
	

/**************************************************************************
 * _ether_get_pkt_type
 *
 *		Descripton 	:
 *          Return the ethernet type of the packet.
 *		
 *		Outputs		:
 *          None
 *
 *		Inputs		:
 *          p_pkt:      pointer to buffer containing packet.
 *          in_offset:  offset of start of ethernet header in packet buffer.
 *          mem_type :  memory type of header buffer
 * 
 *      Returns:
 *          Ethernet type extracted from packet header.
 */
INLINE	int _ether_get_pkt_type(
    void *p_pkt,
    unsigned int in_offset,
    mem_t mem_type)
{
	int type;
	unsigned int field_start = in_offset + FRAME_TYPE_START;

	type = _buf_byte_extract(
	    (UINT*)p_pkt, field_start, FRAME_TYPE_LENGTH, mem_type);

	return (type);

}


/**************************************************************************
 * _ether_decap
 *
 *		Descripton 	:
 *          Update the packet meta data to remove the ethernet header.
 *		
 *		Outputs		:
 *          None.
 *
 *		Inputs		:
 *          None.
 *
 *      Returns:
 *          None.
 */
INLINE void	_ether_decap(void)
{
	/* simply strip off the ethernet header */

	dlMeta.offset += ETHER_HEADER_LENGTH;
	dlMeta.bufferSize -= ETHER_HEADER_LENGTH;
	dlMeta.packetSize -= ETHER_HEADER_LENGTH;

	return;
}

/**************************************************************************
 * _ether_classify
 *
 *		Descripton 	:
 *          Determine the correct value for the meta data header type based
 *          on the ethernet packet type.
 *		
 *		Outputs		:
 *          None.
 *
 *		Inputs		:
 *          p_pkt:      pointer to buffer containing packet.
 *          in_offset:  offset of start of ethernet header in packet buffer.
 *          mem_type :  memory type of header buffer
 * 
 *      Returns:
 *          None.
 */
INLINE void	_ether_classify(
    void *p_pkt,
    unsigned int in_offset,
    mem_t mem_type)
{
	int type;

	type = _ether_get_pkt_type(p_pkt, in_offset, mem_type);

	if (type == ETHER_IPV4)
	{
		dlMeta.headerType = ETHER_IPV4_TYPE;
		dlNextBlock = ETHER_NEXT_IPV4;
	}
	else if (type == ETHER_IPV6)
	{
		dlMeta.headerType = ETHER_IPV6_TYPE;
		dlNextBlock = ETHER_NEXT_IPV6;
	}
	else
	{
		dlMeta.headerType = UNKNOWN_TYPE;
		dlNextBlock = IX_EXCEPTION;
	}

	return;

}

/**************************************************************************
 * ether_decap_classify
 *
 *		Descripton 	:
 *          Remove the ethernet header of the packet and set the header
 *          type.
 *		
 *		Outputs		:
 *          None.
 *
 *		Inputs		:
 *          p_pkt:      pointer to buffer containing packet.
 *          in_offset:  offset of start of ethernet header in packet buffer.
 *          mem_type :  memory type of header buffer
 * 
 *      Returns:
 *          None.
 */
INLINE void	ether_decap_classify(
    void *p_pkt,
    unsigned int in_offset,
    mem_t mem_type)
{
	
	if (dlNextBlock != BID_ETHER)
		return;

	_ether_decap();

	_ether_classify(p_pkt, in_offset, mem_type);

	return;
}

#endif	// end __ETHER_C__