///////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: qm_shaper_init.uc
//
//      Purpose: Performs initialization of two combined functionalities, Queue
//               Manager and AAL5 Shaper.
//				 
//      History:
//
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      01/03/2003      Created                         Jacek Wysoczynski
//
//
/////////////////////////////////////////////////////////////////////////////

#ifndef QM_SHAPER_INIT
#define QM_SHAPER_INIT

#include <atm_tm_shaper_init.uc>

///////////////////////////////////////////////////////////////////////////////
//  Main initialization part
///////////////////////////////////////////////////////////////////////////////
//
// _qm_shaper_init
//
//	 	Description: 
//			Combined functionality initialization code. 
//
//	 	Outputs:
//			Both components as well as the common code is initialized here
//
//		Inputs:
//
//		Size: 
//
///////////////////////////////////////////////////////////////////////////////
#macro _qm_shaper_init()
.begin
	
	// Initialization specific for Queue Manager
	_qm_common_init()

	// Initialization specific for Shaper
	atm_tm_shaper_init(_gcra_param_sram_base, mult_fac, mask_upper15, \
						gcra_lm_offset, @ring_delay, mask_for_port_extraction, \
						mask_for_mul_result, mask_for_thmask_extraction, \
                        @_indirect_read9)

	// Part of the initialization is performed only one time
	.if (ctx() == 0)

        // Perform one time init actions
		// NOTE: QM macro waits for the signal that system is initialized
        _qm_one_time_init()

        // Initialize LM with shaper data
        move(@_qm_shaper_lm_base, QM_SHAPER_SH_LM_BASE)
        .begin
        .reg lm_addr, index, offset
        .sig gcra_param_read_sig

            xbuf_alloc($$gcra_params, 10, read)

            move(lm_addr, QM_SHAPER_SH_LM_BASE)
            immed[index, 0]
            local_csr_wr[active_lm_addr_0, lm_addr]
            nop
            nop
            nop
            .while(index < 16)
                alu[offset, --, B, index, <<GCRA_ENTRY_SIZE_LOG]
                alu[--, --, B, 0x18, <<21]
                sram[read, $$gcra_params[0], _gcra_param_sram_base, offset, max_9], indirect_ref, ctx_swap[gcra_param_read_sig]

                alu[*l$index0[0], --, B, $$gcra_params[0]]
                alu[*l$index0[1], --, B, $$gcra_params[1]]
                alu[*l$index0[2], --, B, $$gcra_params[2]]
                alu[*l$index0[3], --, B, $$gcra_params[3]]
                alu[*l$index0[4], --, B, $$gcra_params[4]]
                alu[*l$index0[5], --, B, $$gcra_params[5]]
                alu[*l$index0[6], --, B, $$gcra_params[6]]
                alu[*l$index0[7], --, B, $$gcra_params[7]]
                alu[*l$index0[8], --, B, $$gcra_params[8]]

                alu[index, index, +, 1]

                alu[lm_addr, lm_addr, +, GCRA_ENTRY_SIZE]
                local_csr_wr[active_lm_addr_0, lm_addr]
                nop
                nop
                nop
            .endw

            xbuf_free($$gcra_params)
        .end
 
	.endif



.end
#endm

#endif //QM_SHAPER_INIT
