////////////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119 
//
//		
//		Change History
// 		--------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 12/11/01    	Ingress Queue Manager for Sausalito  				Aneet Chopra                 
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////////

#ifndef QMMACRO_UC
#define QMMACRO_UC

#ifdef EGRESS
	#include "qm_packet_include.h" ; packet based queue manager
#else
	#include "qm_cell_include.h" ; cel lbased queue manager
#endif

///////////////////////////////////////////////////////////////////////////////
// signal_next_ctx
//	 	Description: Signal next context (thread) in the same ME. This macro is
//		to be used by threads 0 to 6. (Thread 7 has no next thread). 
//      No error checking done on signal number.
//
//	 	Outputs:
//			None
//
//		Inputs:
//			in_sig			Signal number (0-0xF).
//		
//		Size:   			3 instructions
///////////////////////////////////////////////////////////////////////////////	

#macro _qm_signal_next_ctx[in_snc_temp]

	local_csr_wr[SAME_ME_SIGNAL, in_snc_temp]		; Signal the next thread

#endm

///////////////////////////////////////////////////////////////////////////////
// QM_set_signal_next_ctx_reg
//	 	Description: This Macro sets the next_context_reg which is to be used
//		to signal the next context.
//
//	 	Outputs:
//			None
//
//		Inputs:
//			None
//		
//		Size:   			6 instructions
///////////////////////////////////////////////////////////////////////////////	

#macro _qm_set_signal_next_ctx_reg[]

	.local dummy
	

	br=ctx[7, ctx_7#]
				
		// for all other context signal next context

		move[dummy, 0x80]
		alu[gl_next_context_sig, dummy, OR, SIG_1, <<3]
		br[sig_reg_setting_done#]
ctx_7#:
	
		// if its ctx 7 then need to signal context 0

		move[dummy, 0]
		alu[gl_next_context_sig, dummy, OR, SIG_1, <<3]

sig_reg_setting_done#:

	.endlocal
#endm

////////////////////////////////////////////////////////////////////////
/////////// //////Initialization MACROS  ///////////// //////////////////
/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Macro Name  :  _qm_nn_init
// Description : Macro to initialize next neighbour index register
// Output      : Nil
// Input       : Nil
// Constant    : Nil
// Size		   : 5
///////////////////////////////////////////////////////////////////////////////
#macro _qm_nn_init[]

.local ctx_enable_data

	// initialization
	// bit 20 in CTX_ENABLE - NN_MODE = 0 : next neighbor register are written
	//                                      by previous ME 
	// bits [19:18] in CTX_ENABLE - NN_RING_EMPTY = 0 : NN_EMPTY asserts when
	//                                                  NN_PUT == NN_GET
	// bits [15:8] CTX enables for contexts 0 to 7
	// initialize local csr CTX_ENABLES to 0xFF00, local csr NN_PUT and NN_GET
	// to 0

	immed[ctx_enable_data, 0xFF00]				; set low word value
    immed_w1[ctx_enable_data, 0x0000]           ; set high word value
    local_csr_wr[CTX_ENABLES, ctx_enable_data] 	; initialize CTX_ENABLES
    local_csr_wr[NN_PUT, 0]						; initialize NN_PUT
    local_csr_wr[NN_GET, 0]	

.endlocal

#endm


///////////////////////////////////////////////////////////////////////////////
// Macro Name  :  _qm_lm_init
// Description : Macro to initialize local memory index register
// Output      : Nil
// Input       : in_num, in_entry 
// Size        : 1 
///////////////////////////////////////////////////////////////////////////////
#macro _qm_lm_init[in_num, in_entry]

	.local lm_addr

	local_csr_wr[active_lm_addr_/**/in_num, in_entry]

	.endlocal 

#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_q_array_init
// Description : Macro to initialize and preload 16 Q_Array entries
// Output      : Nil
// Input       : Nil
// Constant    : Nil
// Size        : 17
///////////////////////////////////////////////////////////////////////////////
#macro _qm_q_array_init[]

	.local q_num, queue_ptr, qa_cam_num, size, reg, qarray_entry, $qdarray

	// set the initial queue number and Q Array entry

	immed32[q_num, 0x80000000]
	immed[qa_cam_num, QM_QARRAY_BASE]

	// finaly Q Array entry to be initialized

	alu[size, qa_cam_num, +, QM_QARRAY_SIZE]

	move[reg,0]

qa_loop#:

	// set the local memory index 0 

	_qm_lm_init[0, reg]
	alu[reg, reg, +, 64]

	// set the channel number

	alu[qarray_entry, gl_channel_num, OR, qa_cam_num, <<SRAM_Q_ARRAY_NUMBER_FIELD]

	// Read the new queue into Q_Array

	_qm_read_q_array[ q_num, qarray_entry, $qdarray, sig_q_array_enq_r_done ] ; 3, 0

	// wait for read to complete

	ctx_arb[sig_q_array_enq_r_done]
		
	// update CAM with new tag entry

	cam_write[ qa_cam_num, q_num, STATUS_VALID]

	// increment queue number

	alu[q_num, q_num, +,1]

	// update local  memory

	alu[*l$index0, --, b, $qdarray]

	// increment the QArray entry to be used in next iteration

	alu[qa_cam_num, qa_cam_num, +,1]

	alu[--, qa_cam_num, -, size]

	bne[qa_loop#]
	

go_ahead#:

	.endlocal

#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_thread0_init
// Description : Macro to initialize registers, rings and memory used by
//				 by Queue Manager
// Output      : Nil
// Input       : Nil
// Constant	   : Nil 
// Size        : 20
///////////////////////////////////////////////////////////////////////////////
#macro _qm_thread0_init[]

 	.local count, temp

	// clear the CAM		 

	cam_clear;

	// Initialize absoulte registers that are common to all threads
	// used to store few immediates in global registers for ALU operation

	move[@enq_transition_bit_mask, QM_ENQ_TRANSITION_BIT_MASK]
	move[@invalid_dequeue_bit_mask, QM_INVALID_DEQUEUE_BIT_MASK]	
	move[@enq_ind_ref_mask_reg,ENQ_IND_REF_MASK]
	move[@qm_deq_transition_bit_mask_reg, QM_DEQ_TRANSITION_BIT_MASK ]

	
	// Initialize the NN ring

	_qm_nn_init[]


	// Drop Queue Initialization 
	// Initialize local memory for drop Q

	.local reg, qa_cam_num, qarray_entry, $qdarray

	immed[qa_cam_num,QM_DROP_QUEUE_ENTRY]
	move[reg, QM_DROP_QUEUE]
	// set the channel number

	alu[qarray_entry, gl_channel_num, OR, qa_cam_num, <<SRAM_Q_ARRAY_NUMBER_FIELD]

	// Read the new queue into Q_Array Entry reserved for Drop Queue in 

	_qm_read_q_array[ reg, qarray_entry, $qdarray, sig_q_array_enq_r_done ] ; 3, 0

	// wait for read to complete

	ctx_arb[sig_q_array_enq_r_done]

	// update local  memory

	alu[*l$index1, --, b,0]


	.endlocal 
		
	.endlocal 

	
	/////////////////////////////////////////////////////////////////
	// Setting bit 15 (of Q_CNTL_MODE) in SRAM Control CSR to workaround 
	// the QArray problem.
	//
	// This is undocumented feature which will be released in the next
	// release.
	// 
	/////////////////////////////////////////////////////////////////

	.local $set_csr_reg, base, offset, temp

	// This is the sram base address for a given channel

	move[base, SRAM_CHANNEL0_BASE_ADDRESS] 

	// This is the offset that indicates what CSR we are looking for.
	// In out case we want to write to SRAM_CONTROL CSR

	move[offset, OFFSET_SRAMCONTROL_CSR]

	sram[csr_rd, $set_csr_reg, base, offset], ctx_swap[sram_done]
	move[temp, $set_csr_reg]

	// The value in this transfer register will be written to 
	// the SRAM_CONTROL CSR. We are setting bit 15 to workaround 
	// QArray problem.

 	alu[$set_csr_reg, temp, OR, 1, <<15] 
	
	sram[csr_wr, $set_csr_reg, base, offset], ctx_swap[sram_done]

	.endlocal


#ifdef EGRESS

	// Set the SRAM Channel CSR to ignore cellcount and eop bit in the 
	// buffer handle. This implies that even though we could have chained
	// buffers h/w will enq/deq only one buffer. Therefore we enqueue and
	// dequeue a packet everytime.

	.local $set_csr_reg, base, offset, temp

	// This is the sram base address for a give channel

	move[base, SRAM_CHANNEL0_BASE_ADDRESS] 

	// this is the offset that indicates what CSR we are looking for.
	// In out case we want to write to SRAM_CONTROL CSR

	move[offset, OFFSET_SRAMCONTROL_CSR]

	sram[csr_rd, $set_csr_reg, base, offset], ctx_swap[sram_done]
	move[temp, $set_csr_reg]

	// The value in this transfer register will be written to 
	// the SRAM_CONTROL CSR. We are setting two bits that will
	// indicate to ignore cellcount but not the eop bit. Therefore all handles
	// that are being enqueue should have the eop bit set.

 	alu[$set_csr_reg,temp,OR,1,<<13] ;
	
	sram[csr_wr, $set_csr_reg, base, offset], ctx_swap[sram_done]

	.endlocal

#endif	

#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : qm_init
// Description : Macro to initialize registers, rings and memory used by
//				 by Queue Manager
// Output      : Nil
// Input       : Nil 
// Size        : 
///////////////////////////////////////////////////////////////////////////////
#macro qm_init[]

	.local dummy

	// set the next context signal register

	_qm_set_signal_next_ctx_reg[]

	// Setting a global base register. Need to shift by 2, 
	// because address used in reading and writing QD 
	// instruction uses LW alighned addresses.

	immed32[dummy, QD_SRAM_BASE]
	alu[dummy, dummy, AND~, 3, <<30] ;; masking out channel number
	alu[gl_qd_sram_base_reg, --,b, dummy,>>2]

	.endlocal

	// set the override bit used to override defaults in enqueue operation

	move[gl_override_bit_egress, 0x180000] ; for egress the eop bit is always set
									; for SOP handle	
	move[gl_override_bit_ingress, 0x100000] 

	// set the channel number for Q_Array

	immed32[gl_channel_num, QD_SRAM_BASE] 
	alu[gl_channel_num, --,b, gl_channel_num, >>30]
	alu_shf[gl_channel_num, --, B, gl_channel_num, <<SRAM_CHANNEL_NUMBER_FIELD]

	// set the drop queue register

	.local msb_set_reg

	move[msb_set_reg, MSB_SET]
	immed32[gl_qm_drop_queue_reg, QD_TOTAL]
	alu[gl_qm_drop_queue_reg, gl_qm_drop_queue_reg, OR, msb_set_reg]

	.endlocal


	// Initialize few more context specific global registers

	move[zero, 0]
	move[gl_addr_ptr_mask_reg, ADDR_PTR_MASK]
	move[gl_enq_queue_num_mask, ENQ_QUEUE_NUM_MASK]

	// Initialize local memory for drop Q

	.local reg

	move[reg, QM_LM_DROP_Q_BASE]
	_qm_lm_init[1, reg]

	.endlocal

	.if( ctx() == 0 )

		// Thread 0 does the initialization

		_qm_thread0_init[]

		//  Initialize Q_Array 

		_qm_q_array_init[]

		// this is the signal that all blocks are to 
		// wait on to indicate that system initialization 
		// is done
		
		ctx_arb[system_init_done]
			
    .else

		// wait for previous thread/context signal to wake you up

		ctx_arb[sig_prev_thread]
	
	.endif

	
	
#endm 

////////////////////////////////////////////////////////////////////////
/////////// SCRATCH/NN RING READ/WRITE RELATED MACROS //////////////////
/////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_read_scratch_ring
// Description : Macro to read from scratch ring given the ring number and 
//				 number of words.
// Output      : out_message
// Input       : in_num_of_words, in_ring_number
// Size        : 1
// Branches    : 0
///////////////////////////////////////////////////////////////////////////////
#macro _qm_read_scratch_ring[in_num_of_words, out_message, in_ring_number]

	// read "numOfWords" from the scratch ring 

	scratch[get, out_message, 0, in_ring_number, in_num_of_words], sig_done[ sig_scratch_r_done]
	

#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_write_scratch_ring
// Description : Macro to write to scratch ring given the ring number,
//				 message and number of words.
// Output      : 
// Input       : in_num_of_words, in_message, in_ring_number, IN_RING
// Size        : 2
// Branches    : 1
///////////////////////////////////////////////////////////////////////////////
#macro _qm_write_scratch_ring[in_num_of_words, in_message, in_ring_number, IN_RING]

// These define_eval are required. Otherwise the caller cannot have spaces
// in between parameters like init[a, b, c].

#define_eval RING IN_RING

scratch_ring_full#:

	// check if transmit ring is full
	
	br_inp_state[SCR_RING/**/RING/**/_FULL, scratch_ring_full#]

	// write "numOfWords" to the scratch ring

	scratch[put, in_message, zero, in_ring_number, in_num_of_words], sig_done[sig_scratch_w_done]

#undef RING

#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_read_nn_ring
// Description : Macro to read from next neighbour registers of the ME.
// Output      : out_dequeueMessage
// Input       : Nil 
// Size        : 1
// Branches    : 0
///////////////////////////////////////////////////////////////////////////////
#macro _qm_read_nn_ring[out_dequeue_message]

	// read 1 from the NN ring 
	
	alu[out_dequeue_message, 0, b, *n$index++]


#endm

///////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_write_nn_ring
// Description : Macro to read from next neighbour registers of the ME.
// Output      : Nil
// Input       : in_message_0, in_pkt_length
// Size        : 3
// Branches    : 1
///////////////////////////////////////////////////////////////////////////////
#macro _qm_write_nn_ring[ in_message_0, in_message_1 ]

#ifdef EGRESS

	// the message sent to scheduler is 2 LW. The first LW is for transition 
	// message and the second LW is the packet length.

sched_nn_full#:
	br_inp_state[NN_FULL, sched_nn_full#]
	alu[*n$index++, --, b, in_message_0]
	alu[*n$index++, --, b, in_message_1]

#else

	// the message sent to scheduler is 1 LW. The LW is for transition 
	// message.

sched_nn_full#:
	br_inp_state[NN_FULL, sched_nn_full#]
	alu[*n$index++, --, b, in_message_0]
	alu[*n$index++, --, b, in_message_1]

#endif	
#endm

////////////////////////////////////////////////////////////////////////
//////////////////// Q_ARRAY RELATED MACROS ////////////////////////////
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_write_q_array
// Description : Macro to write the cached QDescriptor in Q_Array  back
//				 back to SRAM. .
// Output      : Nil
// Input       : in_queue_ptr, in_qarray_entry 
// Size        : 3
// Constant	   : nil
// Branches    : 0
////////////////////////////////////////////////////////////////////////
#macro _qm_write_q_array[ in_queue_ptr, in_qarray_entry ]

	.local  qarray_sram_addr, dummy

	// This calculation helps in saving an instruction. We can use
	// different operator based on the Base address for queue descriptors.

	#if (!defined(IXP_SIMULATION) )
		// need to mask of the MSB set of the queue number

		alu[dummy, gl_addr_ptr_mask_reg,AND, in_queue_ptr, <<2]

		// get the sram QD address based on the queue number
		// the address has to be LW alighned( ie byte address >> 2)

		alu[qarray_sram_addr,dummy , +, gl_qd_sram_base_reg]

	#else

		alu[qarray_sram_addr, gl_qd_sram_base_reg, OR, in_queue_ptr, <<2]
	
	#endif 

	sram[wr_qdesc,--, in_qarray_entry, qarray_sram_addr] 

	.endlocal

#endm

////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_read_q_array
// Description : Macro to read and cache a Queue Descriptor entry from 
//				 SRAM to Q_Array. $QDArray is actually packet count.
// Output      : out_qd_array
// Input       : in_queue_ptr, in_qarray_entry, in_qa_signal
// Constant    : nil
// Size        : 4
// Branches    : 0
////////////////////////////////////////////////////////////////////////
#macro _qm_read_q_array[ in_queue_ptr, in_qarray_entry, out_qd_array, in_qa_signal ]

	.local  qarray_sram_addr, dummy	
	
	// This calculation helps in saving an instruction. We can use
	// different operator based on the Base address for queue descriptors.

	#if (!defined(IXP_SIMULATION) )
		// need to mask of the MSB set of the queue number

		alu[dummy, gl_addr_ptr_mask_reg,AND, in_queue_ptr, <<2]

		// get the sram QD address based on the queue number
		// the address has to be LW alighned( ie byte address >> 2)

		alu[qarray_sram_addr,dummy , +, gl_qd_sram_base_reg]

	#else

		alu[qarray_sram_addr, gl_qd_sram_base_reg, OR, in_queue_ptr, <<2]
	
	#endif 
	
	// read the complete queue descriptor from the sram.

	sram[rd_qdesc_head, out_qd_array, in_qarray_entry,qarray_sram_addr,2], sig_done[in_qa_signal]
	sram[rd_qdesc_other, --, in_qarray_entry, qarray_sram_addr]

	.endlocal

#endm

////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_dequeue
// Description : Macro to issue dequeue requests to the SRAM Controller 
//				 to dequeue a cell from a queue. The queue should be 
//				 cached in the QArray. 
// Output      : out_qarray_message
// Input       : in_qarray_entry 
// Constant    : none
// Size        : 1
// Branches    : 0
////////////////////////////////////////////////////////////////////////
#macro _qm_dequeue[ in_qarray_entry, out_qarray_message]
	  
	sram[dequeue, out_qarray_message, in_qarray_entry, 0], sig_done[sig_deq_done]

#endm

////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_enqueue_egress
// Description : Macro to issue enqueue requests to the SRAM Controller 
//				 to enqueue a packet to a queue. The queue should be 
//				 cached in the QArray. There are more instructions here
//				 which are primarily used to set the override bit using
//				 indirect reference.
// Output      : Nil
// Input       : in_enqueueMessage_0,  in_enqueueMessage_1,   in_qarray_entry 
// Size        : 8
// Branches    : 1
////////////////////////////////////////////////////////////////////////
#macro _qm_enqueue_egress[in_enqueue_message_0, in_enqueue_message_1,  in_qarray_entry]

	.local temp, dummy
	  	
	// setting up the indirect reference by setting the override bit

	alu[dummy, gl_override_bit_egress, OR, in_enqueue_message_0, >>12]

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_enqueue_message_0, AND, gl_addr_ptr_mask_reg]

	// add the meta offset to the packet_next pointer

	alu[temp, temp, +, META_PACKET_NEXT_LW_PTR]

	// set the non required bits to zero for indirect reference

	alu[--, dummy, AND, @enq_ind_ref_mask_reg]

	// enqueue. we use enqueue tail along with it else will have to use
	// branch. It adds to memory transaction.

 	sram[enqueue, --, in_qarray_entry, temp], indirect_ref


	.endlocal

#endm

////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_enqueue_ingress
// Description : Macro to issue enqueue requests to the SRAM Controller 
//				 to enqueue a packet to a queue. The queue should be 
//				 cached in the QArray. There are more instructions here
//				 which are primarily used to set the override bit using
//				 indirect reference.
// Output      : Nil
// Input       : in_enqueueMessage_0,  in_enqueueMessage_1,   in_qarray_entry 
// Size        : 8
// Branches    : 1
////////////////////////////////////////////////////////////////////////
#macro _qm_enqueue_ingress[in_enqueue_message_0, in_enqueue_message_1,  in_qarray_entry]

	.local temp, dummy
	  	
	// setting up the indirect reference by setting the override bit

	alu[dummy, gl_override_bit_ingress, OR, in_enqueue_message_0, >>12]

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_enqueue_message_0, AND, gl_addr_ptr_mask_reg]

	// set the non required bits to zero for indirect reference

	alu[--, dummy, AND, @enq_ind_ref_mask_reg]

	// enqueue. we use enqueue tail along with it else will have to use
	// branch. It adds to memory transaction.

 	sram[enqueue, --, in_qarray_entry, temp], indirect_ref

	alu[--,IX_NULL,-,in_enqueue_message_1]
	beq[one_buffer_only#]

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_enqueue_message_1, AND, gl_addr_ptr_mask_reg]

	sram[enqueue_tail, --, in_qarray_entry, temp]

one_buffer_only#:

	.endlocal

#endm
 

////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_cam_check
// Description : This Macro checks if the requested queue's QDescriptor 
//				 is cached in the Q_Array. If it is then returns just the
//				 cam_entry. If not then a request is sent to evict an entry
//				 from Q_Array if required and read in the required queue's
//				 QD into the Q_Array and update the CAM accordingly. This macro
//				 also sets the signalmap based on hit or miss which later defines
//				 which signals to wait on.
// Output      : out_qd_array
// Input       : in_queue_id ,  in_hit_label, inout_qarray_entry, in_qa_signal, in_lmnum
// Size        : 13
// Branches    : 1
// Worst CAse  : 13
////////////////////////////////////////////////////////////////////////
#macro _qm_cam_check[ in_queue_id, in_hit_label, inout_qarray_entry, out_qd_array, in_qa_signal, in_lmnum]

	.local cam_result, cam_tag, cam_entry

	// do a cam lookup to see if entry is present

	cam_lookup[ cam_result, in_queue_id ], lm_addr/**/in_lmnum[0]

	// get the cam entry
	GET_CAM_ENTRY

	// setting the channelnum and q array entry. This is done before the branch
	// since it might be required for enqueue and dequeue operations in hit case.

	alu[inout_qarray_entry, gl_channel_num, OR, cam_entry, <<SRAM_Q_ARRAY_NUMBER_FIELD]

	// Get CAM tag. The reason this instruction has been moved out of branch since it 
	// cannot be the next instruction after br_bset. This instruction is not required
	// in a hit case though. 

	cam_read_tag[cam_tag, cam_entry] ;
	
	// check if result shows hit or miss

	
	//.if( cam_hit == 0 )
	br_bset[cam_result, 7, in_hit_label] 

	// its a miss
	
	// write back the queue information 

	_qm_write_q_array[ cam_tag, inout_qarray_entry ] ; 3, 0

	// Read the new queue into Q_Array

	_qm_read_q_array[ in_queue_id, inout_qarray_entry, out_qd_array, in_qa_signal ] ; 4, 0
		
	// update CAM with new tag entry

	cam_write[ cam_entry, in_queue_id, STATUS_VALID ]

	//.endif end of branch

	.endlocal  

#endm





#endif //QMMACRO_UC