/*************************************************************************************
 *
 *
 *                  I N T E L   P R O P R I E T A R Y
 *
 *     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
 *     THE PRIOR WRITTEN PERMISSION OF :
 *
 *                        INTEL  CORPORATION
 *
 *                     2200 MISSION COLLEGE BLVD
 *
 *               SANTA  CLARA,  CALIFORNIA  95052-8119
 *
 ************************************************************************************
 *
 *
 *      File Name: qm.h 
 *
 *      Purpose: header file for queue manager block
 *
 ************************************************************************************
 *
 * 		History:
 *
 * 		Date			Comment										By
 *		---------------------------------------------------------------------------
 *
 *		10/17/02		Created										AC, URN
 *
 *		
 ************************************************************************************/


#ifndef __QM_INCLUDE_H__
#define __QM_INCLUDE_H__

/* MOVE TO DL_SYSTEM.h FIX ME FIX ME FIX ME */

#define TX_1_RING_FULL_CSR	inp_state_scr_ring7_full
#define TX_0_RING_FULL_CSR	inp_state_scr_ring6_full

/*************************************************************************************/

#define MICROC

#include <ixp.h>
#include <dl_system.h>
#include <dl_buf.h>
#include <dl_buf.c>

/*************************************************************************************/
/*
 *	ISO C99: 7.18 Integer types <stdint.h> : For now define them here
 */

#ifndef _STDINT_H
#define _STDINT_H   1

/* Exact integral types.  */
/* Signed.  */

typedef signed char     int8_t;
typedef short int       int16_t;
typedef int             int32_t;
typedef long long int   int64_t;

/* Unsigned.  */

typedef unsigned char           uint8_t;
typedef unsigned short int      uint16_t;
typedef unsigned int            uint32_t;
typedef unsigned long long int  uint64_t;

#endif /* _STDINT_H */.

#ifndef INLINE
#define INLINE __forceinline
#endif


/*************************************************************************************/

/* format of the enqueue message */

typedef struct 
{

	dl_buf_handle_t		sopHandle;
	dl_buf_handle_t		eopHandle;

	union 
	{
		struct
		{
			uint32_t	valid				:1;		/* valid					*/
			uint32_t	drop				:1;		/* transition 				*/
			uint32_t	qNumber				:30;	/* queue number				*/
		};

		uint32_t camValue;							/* The aggregate is used to do 
													   a cam check
													 */
	};

} qm_enq_msg_t;

/*************************************************************************************/

/* format of the enqueue response from qm to scheduler */

typedef __declspec(packed)	struct __enqueue_response
{
	union 
	{
		struct
		{
			uint32_t	reserved			:1;		/* reserve 					*/
			uint32_t	transition			:1;		/* transition 				*/
			uint32_t	reserved_2			:14;	/* reserved 				*/
			uint32_t	queueNumber			:16;	/* queue number				*/
		};

		uint32_t value;
	};

} qm_enq_response_t;

/*************************************************************************************/

/* format of the dequeue response from qm to scheduler */

typedef __declspec(packed)	struct __dequeue_response
{
	union 
	{
		struct
		{
			uint32_t	valid				:1;		/* valid message bit		*/
			uint32_t	transition			:1;		/* transition 				*/
			uint32_t	invalidDequeue		:1;		/* invalid dequeue 			*/
			uint32_t	reserved			:1;		/* reserved 				*/
			uint32_t	packetLength		:8;		/* packet length			*/
			uint32_t	reserved_2			:4;		/* reserved 				*/
			uint32_t	queueNumber			:16;	/* queue number				*/
		};

		uint32_t value;
	};

} qm_deq_response_t;

/**************************************************************************************/

#ifdef PACKET_MODE

/* format of transmit request to the Packet Tx block */

typedef __declspec(packed)	struct __tx_request 
{
	union 
	{
		struct
		{
			uint32_t	valid				:1;			/* valid bit */
			uint32_t	reserved			:3;			/* reserved  */
			uint32_t	portNumber			:4;			/* port number */
			uint32_t	sopBufferOffset		:24;		/* SOP buffer offset in lw */
		};

		uint32_t value;
	};
	

} tx_request_t;

#else

/* format of transmit request to the CSIX Tx block */

typedef __declspec(packed)	struct __tx_request 
{
	union 
	{
		struct
		{
			uint32_t	valid			:1;			/* valid bit */
			uint32_t	reserved		:21;		/* reserved  */
			uint32_t	queueNumber		:10;		/* class id */
		};

		uint32_t value;
	};
			
	dl_buf_handle_t	bufHandle;						/* buffer handle */
	

} tx_request_t;

#endif


/*************************************************************************************/

/* format of structure to read in queue descriptor and other calls  */

typedef __declspec(packed)	struct _q_desc 
{
	union 
	{
		struct
		{
			uint32_t	channel				:2;		/* channel 					*/
			uint32_t	qArrayEntryNumber	:6;		/* q-array entry number	    */
			uint32_t 	address				:24;	/* q descriptor address	    */
		};

		uint32_t value;
	};

} qm_q_desc_t;


/************************************************************************************/

/*
	Global packet count kept in local memory for each queue that is cached in cam
	and one more for the drop queue.
*/

__declspec(local_mem shared aligned(64)) uint32_t qCount[16];
uint32_t __declspec(shared) dropQueueCount;


/*************************************************************************************

 Global Signal Declaration 

 */

/*
	 This signal is used to signal between threads
	 Basically every thread waits on the previous thread
	 to signal
*/

SIGNAL 	volatile sig_prevThread;

/*  these signals are used to wait on scratch read to complete */

SIGNAL	sig_deqReadDone, sig_enqReadDone;

/* this signal is used when writing to a scratch ring */

SIGNAL	sig_txWriteDone;

/* when a deq request is issued this signal is used to 
   wait for the request to complete
 */

SIGNAL	sig_deqDone ;

/* these signals are used to wait on q array read issued for enq and
   deq
 */

SIGNAL	sig_readQueueDescriptor;

/* Macro to send a signal to the next thread */

#define QmSignalNextThread()	signal_same_ME_next_ctx(__signal_number(&sig_prevThread))

/**************************************************************************************

 Ring Definitions

 */

#define ENQ_RING_NUMBER		(QM_RING_IN_0  << 2) 
#define DEQ_RING_NUMBER		(QM_RING_IN_1  << 2)
#define TX_RING_NUMBER_0	(QM_RING_OUT_0 << 2)
#define TX_RING_NUMBER_1	(QM_RING_OUT_1 << 2)

/***************************************************************************************

 Some constants are defined here

 */


#define PACKET_SIZE_START_BIT		24			/* CSIX RX gives packet length starting at			*/
												/* this position									*/

#define PACKET_SIZE_MASK			0x3f		/* packet size in put in seven bits.				*/

#define QM_DROP_QUEUE_BIT			30			/* Bit number for QM drop bit 						*/

#define CHANNEL_NUMBER				0x0			/* SRAM Channel. Specifies whichQ_Array to be used  */

#define SRAM_CHANNEL_BASE_ADDRESS	0x0			/* used to set the SRAM CONTROL CSR					*/

#define OFFSET_SRAMCONTROL_CSR		0x0			/* used to set the SRAM CONTROL CSR					*/

#define META_PACKET_NEXT_LW_PTR 	0x7			/* during enq/deq the handle ptr is incremented by the define.
												 * this is used for packet based dequeue and
												 * not cell based dequeue.
 												 */

#define NUMBER_OF_BITS_FOR_CLASS	4			/* Number of bits in queue number 
												 *used for class id 
												 */

/* for CAM status */

#define STATUS_VALID						0x1

/* EOP Bit in buffer handle */

#define EOP_BIT								31

/* Bit for ingnoring SOP and Cell Count in SRAM Controller CSR for QArray */
				
#define IGNORE_SOP_CELLCOUNT_BIT			13

/* nizhner 8/17/04: added support for load-time constants */
#ifdef USE_IMPORT_VAR

/*
#define QM_DROP_QUEUE_ENTRY 	(LoadTimeConstant("QM_DROP_QUEUE_ENTRY"))
#define QD_SRAM_BASE			(LoadTimeConstant("QD_SRAM_BASE"))
#define QD_TOTAL				(LoadTimeConstant("QD_TOTAL"))
*/
#define QM_DROP_QUEUE_ENTRY 	0x00000020
#define QD_SRAM_BASE			0x000c8560
#define QD_TOTAL				

#else

/* defined in dl_system.h */

#endif /* USE_IMPORT_VAR */


/***************************************************************************************/

#endif /* __QM_INCLUDE_H__ */

/**************************************************************************************/
