////////////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119 
//
///////////////////////////////////////////////////////////////////////////////////
// 		
//		Change History
// 		--------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 12/11/01    	Ingress/Egress Queue Manager for IXP2***  		Aneet Chopra                 
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////////

#ifndef QMCODE_UC
#define QMCODE_UC

.reg 		enqueuemessage_0 enqueuemessage_1 enqueuemessage_2  // using GPRs for enqueue msg

#ifdef EGRESS
	#include "qm_packet_macro.uc"
	#include "qm_packet_message.uc"
#else
	#include "qm_cell_macro.uc"
	#include "qm_cell_message.uc"
#endif

#ifdef POTS
#include "aisr.uc"
#endif

//////////////////////////////////////////////////////////////////////////
// Macro Name  : queue_manager
// Description : This is the main macro where the queue manager algorithm
//				 is implemented. The QM is designed to issue an enqueue 
//	 			 dequeue request per beat. Based on this the QM then needs
//				 to send messages to Schedular and Transmit blocks.
// Output      : Nil
// Input       : Nil
// Constant	   : Nil 
// Size        : 82
// Branches    : 19
//////////////////////////////////////////////////////////////////////////
#macro queue_manager[]
	
.begin

// This register is used to determine the qarray entry 
// we are going to act on for enq/deq purposes.

.reg qarray_entry

// This register is used to send transition messages to schedular

.reg sched_message_enq, sched_message_deq

// allocate transfer register for enqueue message 3 LW

.reg  		$enqueuemessage_0, $enqueuemessage_1, $enqueuemessage_2, $enqueuemessage_3
.xfer_order $enqueuemessage_0, $enqueuemessage_1, $enqueuemessage_2, $enqueuemessage_3

// for dequeue message read from scratch ring and message received
// from dequeue
.reg   $dequeuemessage_0  
.reg   $qarray_message

// registers required to read in QDescriptor for dequeue

.reg 		$qd_array_deq_0, $qd_array_deq_1
.xfer_order	$qd_array_deq_0, $qd_array_deq_1

// register required to read in QDescriptor for enqueue

.reg 	 	$qd_array_enq_0, $qd_array_enq_1
.xfer_order	$qd_array_enq_0, $qd_array_enq_1

// this register is required to save the sop handle for enqueue messages

.reg		sop_handle enq_queue_num

	// initialize the message register
	alu[sched_message_enq, --, b, 0]
	alu[sched_message_deq, --, b, 0]

	
	alu[gl_transition_valid_reg, --,b, 0]

	// The following 6 instr are executed only  
	// once and are to jump start the loop

	// signal the next ctx

	_qm_signal_next_ctx[gl_next_context_sig] ;1,0

	// Read enqueue message 

	scratch[get, $enqueuemessage_0, zero, ENQ_RING_NUMBER, NUM_WORDS_ENQ_MESSAGE], sig_done[ sig_scratch_enq_r_done]

	//  swap out waiting on scratch reads to complete. 

	ctx_arb[sig_scratch_enq_r_done, sig_prev_thread]

	// signal the next ctx. this is added because the first time there may not be an 
	// enqueue message and before swapping out should signal the next thread.  

	_qm_signal_next_ctx[gl_next_context_sig] ;1,0

	//bypass the hit conditions following this branch.
	
	br[next_iteration#]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;Loop Begins Here ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;Enq/Deq CAM miss cases handled here ;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	// This is where the loop begins. Deq CAM miss and Enq CAM miss in a cycle
	// is the worst case for Queue Manager. Therefore, care has been taken
	// that we take minimum branch penalty. Hence as we read on, the code 
	// executes the worst case without taking any branch.

next_iteration#:

	// Read dequeue message

	scratch[get, $dequeuemessage_0, zero, DEQ_RING_NUMBER, NUM_WORDS_DEQ_MESSAGE], sig_done[ sig_scratch_deq_r_done]


	// the .set is used to workaround assembler warnings. The code jumps to this path 
	// after it issued read from enqueue scratch ring. The assembler does not know feels
	// that the read may not have completed and is generating warnings.

	.set $enqueuemessage_0, $enqueuemessage_1, $enqueuemessage_2

	// check if enqueue ring is empty. the read from enqueue scratch ring
	// was issued in the previous phase.

#ifdef POTS

	// perform Pool of Threads processing
	aisr_sort_packet($enqueuemessage_0, $enqueuemessage_1, $enqueuemessage_2, $enqueuemessage_3, no_enqueue_request#)

#else
	alu[enqueuemessage_0, --, b, $enqueuemessage_0]
	alu[enqueuemessage_1, --, b, $enqueuemessage_1]
	alu[enqueuemessage_2, --, b, $enqueuemessage_2]

	//.if( $enqueueMessage_0 != 0)
	alu[--, 0, - , enqueuemessage_0]
	beq[no_enqueue_request#] 			; if there is no request for enq
									; branch to no_enqueue_request# label
#endif

	.local enq_queue_num
	// remove the cell count from the queue number for enqueuing.

	alu[enq_queue_num, gl_enq_queue_num_mask, AND, enqueuemessage_2]

	// this check is for verifying if the enqueue request is for a buffer chain
	// to be dropped. If it matches the drop queue ring number then the special
	// drop queue processsing will be done.

	alu[--, enq_queue_num, -, gl_qm_drop_queue_reg]
	beq[process_drop_queue_enqueue#]

	#ifdef DEBUG_COUNTERS
	alu[@qm_cell_rcvd_cells, @qm_cell_rcvd_cells, +, 1]		;
	#endif // DEBUG_COUNTERS

	// check if entry is in CAM. if there is a CAM hit then
	// jump to label enq_hit#. if there is a CAM miss then
	// write back the current CAM entry and read in the
	// new entry based on the queue number. 
		
	_qm_cam_check[enq_queue_num, enq_hit#, qarray_entry, $qd_array_enq_0, sig_q_array_enq_r_done,0] ; 13
	
	.endlocal // no longer use of reg "enq_queue_num"

	// If we are here it implies that there is a CAM miss.
	#ifdef EGRESS

		// send an enqueue message

		_qm_enqueue_egress[enqueuemessage_0, enqueuemessage_1, qarray_entry] ; 5, 1

	#else


		// send an enqueue message

		_qm_enqueue_ingress[enqueuemessage_0, enqueuemessage_1, qarray_entry] ; 8, 1
		
	#endif

	//.endif	

	//then wait for an additional signal. This is the miss path so we
	// wait on Q_Array enq read to complete in addition.
	
	ctx_arb[sig_q_array_enq_r_done, sig_scratch_deq_r_done, sig_prev_thread], defer[2] ;2
	
		//save the sop_handle for future use.
		
		alu[sop_handle, --,b, enqueuemessage_0]


		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_enq,--,b,0]
	
	// Set the enqueue transtion message. Since this is a miss we depend on
	// $qd_array_enq_0 that contains the queue count, got from return value 
	// when a read Q_Array request was issued in the previous phase. 

	_qm_set_enqmiss_message[enqueuemessage_2, $qd_array_enq_0, sched_message_enq];5

check_dequeue#:


	// signal the next ctx well before 

	_qm_signal_next_ctx[gl_next_context_sig] ;1,0	

#ifdef POTS
	// check if aisr array full
	aisr_check_full[sig_scratch_enq_r_done, enqueue_read_issued#]
#endif

	// Read enqueue message 

	scratch[get, $enqueuemessage_0, zero, ENQ_RING_NUMBER, NUM_WORDS_ENQ_MESSAGE], sig_done[ sig_scratch_enq_r_done]


	//.if( $dequeueMessage_0 != 0) checking for valid dequeue message. The
	// read for dequeueMessage was issued in the previous phase

	enqueue_read_issued#:

	alu[--, 0, - , $dequeuemessage_0]
	beq[no_dequeue_request#]

	// check if entry is in CAM. if there is a CAM hit then
	// jump to label deq_hit#. if there is a CAM miss then
	// write back the current CAM entry and read in the
	// new entry based on the queue number. 

	_qm_cam_check[ $dequeuemessage_0, deq_hit#, qarray_entry, $qd_array_deq_0, sig_q_array_deq_r_done,0] ; 15, 1, 15
	
	// If we are here it implies that there is a CAM miss.
	// send a dequeue message

	_qm_dequeue[ qarray_entry, $qarray_message] ;1, 0

	// wait on signals and jump to deqmiss_message when thread comes back

	ctx_arb[sig_scratch_enq_r_done, sig_q_array_deq_r_done, sig_deq_done, sig_prev_thread ], defer[2]

		//doing nothing

		nop
		
		// doing nothing

		nop
	
	// To let the assembler know that scratch write 
	// is completed and these transfer registers can be reused

	.io_completed  $qd_array_deq_0, $deq_q

	// check if dequeue was invalid
	//.if( $qd_array_deq_0 == 0  )

	alu[*l$index0,--,b,$qd_array_deq_0]

	beq[send_invalid_dequeue_to_sched#]

	// Set the dequeue transtion message 

	_qm_set_deq_message[$dequeuemessage_0,  $qarray_message, sched_message_deq]; 11

	// Send Message to the schedular if required

	_qm_send_sched_message[sched_message_enq, sched_message_deq, $qarray_message];4

#ifdef POTS
	aisr_block_read()
#endif

	// loop back and read the next enqueue/dequeue request

	br[next_iteration#], defer[2]

		// signal the next ctx

		_qm_signal_next_ctx[gl_next_context_sig] ;1,0

		
		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_deq,--,b,0]


	//.endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;No Enqueue/Dequeue Request on Scratch case handled here
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

no_enqueue_request#:
	
	//  swap out waiting on scratch reads to complete. 

	ctx_arb[ sig_scratch_deq_r_done, sig_prev_thread], defer[2]

		// zero sop handle

		alu[sop_handle, --, b, 0]
	
		// initialize message register

		alu[sched_message_enq,--,b,0]	

	
	br[check_dequeue#]

no_dequeue_request#:


	// Check if there is anything to dequeue from the drop queue
	// well we can always get rid of setting the local memory and always issue
	// a dequeue. We can do this optimization for better performance.

#ifdef POTS
	alu[--, --, b, @drop_queue_count]
#else
	alu[--,--,b,*l$index1]
#endif
	bne[process_drop_queue_dequeue#]

	ctx_arb[sig_scratch_enq_r_done, sig_prev_thread]

	// Send Message to the schedular if required
	// basically we check if we got a valid enqueue message
	// in the previous phase

	alu[--, --, b, sop_handle]
	beq[do_not_send_message#]

	_qm_send_sched_message[sched_message_enq, sched_message_deq, 0]

#ifdef POTS
	aisr_block_read()
#endif

	br[next_iteration#], defer[2]

		// signal the next ctx

		_qm_signal_next_ctx[gl_next_context_sig] ;1,0

		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_deq,--,b,0]


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;Enqueue/Dequeue CAM hit cases handled here;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	// this is the code path when there is a valid enqueue
	// and there is a CAM hit.

enq_hit#:


	#ifdef EGRESS

		// send an enqueue message

		_qm_enqueue_egress[enqueuemessage_0, enqueuemessage_1, qarray_entry] 

	#else

		// send an enqueue message

		_qm_enqueue_ingress[enqueuemessage_0, enqueuemessage_1, qarray_entry] 
		
	#endif	

	//  swap out waiting on scratch read for DEQ to complete and the signal
	//  from previous thread. 

	ctx_arb[ sig_scratch_deq_r_done, sig_prev_thread], defer[2] 

		//save the sop_handle for future use.
		
		alu[sop_handle, --,b, enqueuemessage_0]

		// initialize message register. this is the register
		// that is used to send messages to schedular.

		
		alu[sched_message_enq,--,b,0]

	// Set the enqueue transtion message 

	_qm_set_enqhit_message[enqueuemessage_2, sched_message_enq]

	// enqueue is done. so now check for dequeue

	br[check_dequeue#]

deq_hit#:

	// send a dequeue message

	_qm_dequeue[qarray_entry, $qarray_message] ;1, 0

	//  swap out waiting on scratch read for ENQ to complete, DEQ to complete
	//  and the signal from previous thread. On returning branch directly to
	// 	to determine dequeue transition message for the CAM hit case.

	ctx_arb[sig_scratch_enq_r_done, sig_deq_done, sig_prev_thread]

	// To let the assembler know that scratch write 
	// is completed and these transfer registers can be reused

	.io_completed  $qd_array_deq_0, $deq_q

	// check if dequeue was invalid
	//.if( *l$index0 == 0  )

	alu[--,--,b, *l$index0]

	beq[send_invalid_dequeue_to_sched#]

	// Set the dequeue transtion message 

	_qm_set_deq_message[$dequeuemessage_0, $qarray_message, sched_message_deq]

	// Send Message to the schedular if required

	_qm_send_sched_message[sched_message_enq, sched_message_deq, $qarray_message]

#ifdef POTS
	aisr_block_read()
#endif

	// loop back and read the next enqueue/dequeue request

	br[next_iteration#], defer[2]


		// signal the next ctx

		_qm_signal_next_ctx[gl_next_context_sig] ;1,0

		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_deq,--,b,0]

#ifdef EGRESS
no_deq_issued#:

	//  swap out waiting on scratch read for ENQ to complete
	//  and the signal from previous thread. On returning branch directly to
	//  code path for invalid dequeue since we have not issued a dequeue.

	ctx_arb[sig_scratch_enq_r_done, sig_prev_thread], br[send_invalid_dequeue_to_sched#]

#endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;Enqueue and Dequeue Request for drop queue i.e. dropping a 
;;;;;;;;;;multiple buffer packet is processed here.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


// Handling enqueing to the drop queue

process_drop_queue_enqueue#:

	.local entry, cell_count_masked, cell_count_mask_reg

	// initialize the local memory  pointer to point
	// to the queue count for drop queue

	move[entry, QM_LM_DROP_Q_BASE]
	_qm_lm_init[0, entry]

	// mask the cell count from the head handle
	// this is an optimization that will require
	// only  one dequeue to free that buffer.

	move[cell_count_mask_reg, CELL_COUNT_MASK]
	alu[cell_count_masked, cell_count_mask_reg, AND, enqueuemessage_0]

	// set the Qarry Entry where the drop queue descriptor
	// is stored and where the packet will be enqueued

	alu[qarray_entry,--,b, QM_DROP_QUEUE_ENTRY, <<SRAM_Q_ARRAY_NUMBER_FIELD]
	alu[qarray_entry, qarray_entry, OR, gl_channel_num]
	
	// enqueue the packet

	_qm_enqueue_ingress[cell_count_masked, enqueuemessage_1, qarray_entry]
#ifdef POTS
	alu[@drop_queue_count, @drop_queue_count, +, 1]
#else
	alu[*l$index0, *l$index0, +, 1] 
#endif

	.endlocal	

	//  swap out waiting on scratch read for DEQ to complete. 

	ctx_arb[ sig_scratch_deq_r_done, sig_prev_thread], defer[2] ,br[check_dequeue#]

		// zero sop handle

		alu[sop_handle, --, b, 0]

		
		// initialize message register. this is the register
		// that is used to send messages to schedular.

		
		alu[sched_message_enq,--,b,0]


process_drop_queue_dequeue#:

	// set the Qarry Entry where the drop queue descriptor
	// is stored and where the packet will be enqueued
	// we can store this information in a global register and
	// avoid these two instruction every time.

	alu[qarray_entry,--,b, QM_DROP_QUEUE_ENTRY, <<SRAM_Q_ARRAY_NUMBER_FIELD]
	alu[qarray_entry, qarray_entry, OR, gl_channel_num]

	// This implies there is need to dequeue so issue a dequeue request

	_qm_dequeue[ qarray_entry, $qarray_message] ;1, 0

	ctx_arb[sig_scratch_enq_r_done, sig_deq_done, sig_prev_thread]

	// Update local memory regarding drop Q queuecount
	// and also enqueue the dequeued buffer to the free list
	// if all cells have been dequeued

	_qm_dropq_deq_handler[deqQueueNum, $qarray_message]

	// Send Message to the schedular if required

	alu[--, --, b, sop_handle]
	beq[do_not_send_message#]

	_qm_send_sched_message[sched_message_enq, sched_message_deq, 0]

#ifdef POTS
	aisr_block_read()
#endif

	br[next_iteration#], defer[2]

		// signal the next ctx

		_qm_signal_next_ctx[gl_next_context_sig] ;1,0

		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_deq,--,b,0]



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;; Invalid dequeue message and null messages for scheduler
;;;;;;;;;; handled here.  ;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

do_not_send_message#:

	
	alu[gl_transition_valid_reg, --,b, 0]

	br[next_iteration#], defer[2]

		// signal the next ctx

		_qm_signal_next_ctx[gl_next_context_sig] ;1,0

		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_deq,--,b,0]

send_invalid_dequeue_to_sched#:

	//It is an invalid dequeue

	alu[sched_message_deq, $dequeuemessage_0, OR, @invalid_dequeue_bit_mask ]

	alu[gl_transition_valid_reg, --,b, 1]

	// Send Message to the schedular if required

	_qm_send_sched_message[sched_message_enq, sched_message_deq, 0]

	// loop back and read the next enqueue/dequeue request

	br[next_iteration#], defer[2]

		// signal the next ctx

		_qm_signal_next_ctx[gl_next_context_sig] ;1,0

		// initialize message register. this is the register
		// that is used to send messages to schedular.

		alu[sched_message_deq,--,b,0]

.END
#endm // queue_manager[]


///////////////////////////////////////////////////
// This is where the code begins..................
///////////////////////////////////////////////////
begin#:

	#ifdef DEBUG_COUNTERS
	.reg @qm_cell_rcvd_cells
	immed[@qm_cell_rcvd_cells, 0]
	#endif // DEBUG_COUNTERS

	// Initialization of global and absolute registers, Q_array and local memory

#ifdef POTS
	aisr_init[]
#endif

	qm_init[]

	// Here is where the Queue Manager loop begins

	queue_manager[] 

error#:
	nop ; place holder will only come here if there is an error

;END#:

#endif // QMCODE_UC