/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_qm_frmwrk.h
 *
 * = DESCRIPTION: defines for functions invoked by the framework. 
 *
 * = AUTHOR
 *      Herman Zaks
 *      Herman.Zaks@intel.com
 *
 * = CHANGE HISTORY
 *      7/16/2002 - Created
 *  $Id: ix_cc_qm_frmwrk.h,v 1.8 2003/12/12 20:31:08 ttschlue Exp $
 **/

#if !defined(__IX_CC_QM_FRMWRK_H__)
#define __IX_CC_QM_FRMWRK_H__

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

typedef struct ix_cc_s_instance_map_qm
{
    ix_uint32 msgIn;
    ix_uint32 pktIn;  
    ix_uint32 pktEgressIn;
    ix_uint32 pktEgressOut;
    ix_uint32 pktUblockOut;
} ix_cc_instance_map_qm;

#define IX_CC_QM_INSTANCE_TABLE_DEFINE() \
const ix_cc_instance_map_qm aQmInstanceTable[] = { 

#define IX_CC_QM_INSTANCE_ENTRY_DEFINE(msgIn,pktIn,pktEgressIn,pktEgressOut,pktUblockOut) \
        { msgIn, pktIn, pktEgressIn, pktEgressOut, pktUblockOut },

#define IX_CC_QM_INSTANCE_TABLE_END {0} };

#define IX_CC_QM_INSTANCE_TABLE_GET(instance,paramName) \
        aQmInstanceTable[instance]. /* */ paramName


#define IX_CC_QM_INSTANCE_TABLE_DECLARE() \
extern ix_cc_instance_map_qm aQmInstanceTable[];

/*
 *
 * Prototypes for functions invoked by CCI.
 */

/*
 *
 * Prototype for initialization function invoked by CCI.
*/
ix_error ix_cc_qm_init(ix_cc_handle arg_hCcHandle, void** arg_ppContext);

/*
 *
 * Prototype for shut down function invoked by CCI.
*/
ix_error ix_cc_qm_fini(ix_cc_handle arg_hCcHandle, void* arg_pContext);

/*
 *
 * Prototype for message handler function invoked by CCI.
*/
ix_error ix_cc_qm_msg_handler(ix_buffer_handle arg_Msg, 
                              ix_uint32 arg_UserData,
                                void* arg_pContext);

/*
 *
 * Prototype for packet handler function invoked by CCI.
*/
ix_error ix_cc_qm_pkt_handler(ix_buffer_handle arg_hDataToken, 
                            ix_uint32 arg_ExceptionCode, 
                            void* arg_pContext);


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_QM_FRMWRK_H__) */
/*******************************  FILE HISTORY  *******************************
 * \main\sdk_3_0\lp_merge\1 Thu Aug 28 18:55:52 2003 adziecia
 * IGK0100025366: LP MERGE: Core Corponents merge checkin 
 *  
 *****************************************************************************/
