/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_qm.h
 *
 * = DESCRIPTION: 
 *
 * = AUTHOR
 *      Herman Zaks
 *      Herman.Zaks@intel.com
 *
 * = CHANGE HISTORY
 *      7/16/2002 - Created
 *  $Id: ix_cc_qm.h,v 1.40 2003/11/14 21:35:16 rranjeet Exp $
 **/


#if !defined(__IX_CC_QM_H__)
#define __IX_CC_QM_H__

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */
/* defines */

#define IX_QM_TEST  0 /* define test flag - if this is defined QM stores free list handle as a global argument */

/* number and name of QM symbols to patch */
#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
#if defined( IX_PLATFORM_2801 )
/*
 * Temporary solution for release 3.5 - remove when 2800 scheduler will be integrated in the 2801 uCode
 */

#define IX_CC_QM_PATCH_SYMBOLS              3 /* offset+chan number, qd_total, drop_queue_entry */

#else /* IX_PLATFORM_2801 */

#define IX_CC_QM_PATCH_SYMBOLS_INGRESS      1
#define IX_CC_QM_PATCH_SYMBOLS_EGRESS       1
#define IX_CC_QM_PATCH_SYMBOLS              2

#endif /* IX_PLATFORM_2801 */

#else

#define IX_CC_QM_PATCH_SYMBOLS              3 /* offset+chan number, qd_total, drop_queue_entry */

#endif /* (_IX_HARDWARE_TYPE_ == _IX_HW_2800_) */

#define IX_QM_SYMBOL_QD_SRAM_BASE          "QD_SRAM_BASE"
#define IX_QM_SYMBOL_QD_TOTAL              "QD_TOTAL"
#define IX_QM_SYMBOL_QM_DROP_QUEUE_ENTRY   "QM_DROP_QUEUE_ENTRY"
#define IX_QM_SYMBOL_QM_COUNTER_BASE       "QM_COUNTER_SRAM_BASE"  /* counter base for ingress 64*4 32-bit counters SRAM*/
                                                            /* egress 16*4 counters */ 
/*number of drop queues in q-array */
#define IX_CC_QM_DROP_QUEUE_NUMBER      1

/* size in bytes of queue descriptor */
#if !defined( IX_INCLUDE_WRED )
#define IX_QD_SIZE                      16
#else /* !IX_INCLUDE_WRED */
#define IX_QD_SIZE                      (1 << QD_LOG_SRAM_SIZE)
#endif /* IX_INCLUDE_WRED */

/* configuration items for QM core component */

#if !defined (IX_INCLUDE_REGISTRY)
    #define QUEUE_DESC_TOTAL                1024

    #define QM_INGRESS_UENG_NUM             3
    #define QM_EGRESS_UENG_NUM              1    

    #define IX_SWITCH_FABRIC_LOOPBACK_FLAG  1 /* 1 supports loopback, 0 no loopback */

#if defined( IX_INCLUDE_WRED )
    #define WRED_UENG_MASK                  0xA2
#endif /* IX_INCLUDE_WRED */

#if defined( IX_INCLUDE_QM_MASK )
#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
    #define QM_UENG_MASK_INGRESS            0x80 /* only ME7 needs imported symbol */
    #define QM_UENG_MASK_EGRESS             0x40 /* only ME6 needs imported symbol */
#else
    #define QM_UENG_MASK                    0x0
#endif /* (_IX_HARDWARE_TYPE_ == _IX_HW_2800_) */
#endif /* IX_INCLUDE_WRED */

#endif /* IX_INCLUDE_REGISTRY */

#if defined (IX_DEBUG)
    #define IX_QM_DEBUG    1
#endif

#define IX_PCI_COMM		1
/**
 * DESCRIPTION: This is the predefined scratch ring ID for the QM core/ublock  packet 
 *  communication ring.
 *
 */
#define IX_QM_PACKET_UBLOCK_RING_ID    8UL


/* define strings for repository access */

#define REPOSITORY_PATH_SWITCH_FABRIC_LOOPBACK  "System_Properties/SWITCH_FABRIC_LOOPBACK_FLAG"
#define REPOSITORY_PATH_SRAM_CHANNEL_NUM        "System_Properties/SRAM_CHANNEL_NUM"
#define REPOSITORY_PATH_LOCAL_BLADE_ID          "System_Properties/BLADE_ID"
#define REPOSITORY_PATH_QM_UENG_NUM             "QM_UENG_NUM"
#define REPOSITORY_PATH_QM_QUEUE_DESC_TOTAL     "QUEUE_DESC_TOTAL"
#define REPOSITORY_PATH_INGRESS_EGRESS          "INGRESS_EGRESS"

#if defined( IX_INCLUDE_WRED )
#define REPOSITORY_PATH_WRED_UENG_MASK          "MEV2_NUM_MASK"
#endif /* IX_INCLUDE_WRED */

#if defined( IX_INCLUDE_QM_MASK )
#define REPOSITORY_PATH_QM_UENG_MASK          "QM_UENG_MASK"
#endif /* IX_INCLUDE_QM_MASK */

/**
 * TYPENAME: ix_s_cc_qm_ublock_config
 * 
 * DESCRIPTION: configuration structure used to configure QM
 *              microblock
 */
typedef struct ix_s_cc_qm_ublock_config
{
    ix_uint32 	qd_channel_num;
    ix_uint32   qd_sram_virtual_base; /* keep this for deletion later */ 
    ix_uint32	qd_sram_base; 
    ix_uint32	total_queue_desc;  	/* total number  of queue descriptors */
    ix_uint32	drop_queue_entry;   /* id for the drop queue QARRAY */
    ix_uint32	ueng_number;	    /* microengine number the microblock is running on */

#if defined( IX_INCLUDE_WRED )
    ix_uint32 wred_ueng_mask;
#endif /* IX_INCLUDE_WRED */

#if !defined( IX_PLATFORM_2801 )
    /* Platform specific. Do not use QM having two MEs for an IXDP2801 platform
     * in the release 3.5.
     */
#if defined( IX_INCLUDE_QM_MASK )
    ix_uint32 qm_ueng_mask;
#endif /* IX_INCLUDE_QM_MASK */
#endif /* IX_PLATFORM_2801 */    
    
}ix_cc_qm_ublock_config;

/**
 * TYPENAME: ix_cc_qm_context
 * 
 * DESCRIPTION: QM context data structure
 *
 */

typedef struct ix_s_cc_qm_context
{
    ix_uint32			    localBladeId ; 	    /* id of the blade that the QM is running on */	
    ix_uint8                ingressEgress;      /* indicates ingress (0) or egress (1) side we are running on */
    ix_uint8                switchFabricLoopback;/* flag indicates if switch fabric support loopback(1) or 
                                                    doesn't (0)*/
    ix_cc_handle			hQMHandle;	        /* handle of QM produced by the execution engine */	
    ix_cc_qm_ublock_config*	pUblockConfig;      /* pointer to the microblock configuration structure */
} ix_cc_qm_context;



/* Queue Manager specific error codes */
/**
 * TYPENAME: ix_cc_qm_error
 * 
 * DESCRIPTION: This enummeration defines error specific to 
 *               core component.
 *
 */

enum ix_cc_qm_error {
    IX_CC_QM_ERROR_FIRST = IX_ERROR_MAKE_GROUP(CC_QM),
    IX_CC_QM_ERROR_REPOSITORY_OPEN,
    IX_CC_QM_ERROR_REPOSITORY_READ,
    IX_CC_QM_ERROR_VIRTUAL_TO_PHYSICAL,
    IX_CC_QM_ERROR_SET_UCODE_FILE,
    IX_CC_QM_ERROR_PATCH_SYMBOLS,
    IX_CC_QM_ERROR_FREE_MEM,
    IX_CC_QM_ERROR_FREE_HW_QUEUE,
    IX_CC_QM_ERROR_FREE_HW_RING,
    IX_CC_QM_INVALID_CC_HANDLE,
    IX_CC_QM_INVALID_HANDLE,
    IX_CC_QM_ERROR_RM_GETBUFFERDATA,  
    IX_CC_QM_ERROR_MSUP,
    IX_CC_QM_ERROR_STOP_UENGINE,
    IX_CC_QM_ERROR_GET_META_DATA,
    IX_CC_QM_ERROR_GET_BUFFER_DATA,
    IX_CC_QM_ERROR_USER_CB,
    IX_CC_QM_ERROR_BUF_QUEUES_ALLOC_FAILED,
    IX_CC_QM_ERROR_HANDLER_REGISTRATION,
    IX_CC_QM_ERROR_SEND_FAIL,
    IX_CC_QM_ERROR_UBLOCK_COMM_INIT,
    IX_CC_QM_ERROR_SRAM_RING_CREATE,
    IX_CC_QM_ERROR_NO_EOP_FLAG,
    IX_CC_QM_ERROR_LAST
};



/**
 * TYPENAME: ix_cc_qm_cb_pkt_count
 * 
 * DESCRIPTION: prototype for user Callback of async messaging function
 *
 */
typedef ix_error (*ix_cc_qm_cb_pkt_count)(ix_error  arg_Result,
                                        void*   arg_pContext,
                                        ix_uint64   arg_PktCount
                                        );
/*
 *
 * prototypes for async messaging function
 */
ix_error ix_cc_qm_async_get_packet_count (ix_cc_qm_cb_pkt_count arg_Callback, 
                                          ix_generic_context* arg_pContext);



/*
 *  prototype of library API for getting the packet counter                                          
 *  do not use this function in Level 1 
 */
ix_error ix_cc_qm_get_packet_count(ix_uint64* arg_pPktCount);

#if IX_QM_TEST
    ix_error qm_get_free_list(ix_buffer_free_list_handle* arg_phFreeList);
#endif

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_QM_H__) */
