#ifndef QM_ATM_INCLUDE_H
#define QM_ATM_INCLUDE_H

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.  
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*
 *		Change History
 * 		--------------
 *
 * Date			Description											Whom
 * ------------------------------------------------------------------------------------
 *
 * 03/24/03    	Queue Manager include file.  				        Jacek Wysoczynski
 *
 */                                                                      

#ifdef USE_IMPORT_VAR

    #include <dl_system.h>
    #include <qm_atm_defs.h>

#else

    #include <dl_system.h>
    #include <definitions.h>

#endif

#include <stdmac.uc>
#include <dispatch_loop.uc>



#ifdef USE_IMPORT_VAR

  .import_var QM_DROP_QUEUE_ENTRY
  .import_var QD_SRAM_BASE  
  .import_var QD_TOTAL

#else

/* defined in dl_system.h */

#endif /* USE_IMPORT_VAR */

/////////////////////////////////////////////////////
// Ring Definitions
/////////////////////////////////////////////////////

#if ( defined(TX_PHY_MODE) && ((TX_PHY_MODE == SPHY_4_8) | (TX_PHY_MODE == MPHY_4) ))
	#define_eval ENQ_RING_NUMBER	(QM_RING_IN_0  << 2) 
	#define_eval DEQ_RING_NUMBER	(QM_RING_IN_1  << 2)
	#define_eval TX_RING_NUMBER_0	(QM_RING_OUT_0 << 2)
	#define_eval TX_RING_NUMBER_1	(QM_RING_OUT_1 << 2)
	#define_eval TX_RING_NUMBER_2	(QM_RING_OUT_2 << 2)
	#define_eval TX_RING_NUMBER_3	(QM_RING_OUT_3 << 2)

#else

// ring numbers

	#define_eval ENQ_RING_NUMBER	(QM_RING_IN    << 2) 
	#define_eval DEQ_RING_NUMBER	(SCHEDULER_TO_QM_SCR_RING << 2)

#ifdef AAL5_TX_EVEN_ODD_PORTS
    #define_eval TX_RING_1			QM_RING_OUT_1
    #define_eval TX_RING_NUMBER_1	(QM_RING_OUT_1   << 2)
    #define_eval TX_RING_2			QM_RING_OUT_2
    #define_eval TX_RING_NUMBER_2	(QM_RING_OUT_2   << 2)
#else
	#define_eval TX_RING			QM_RING_OUT
    #define_eval TX_RING_NUMBER		(QM_RING_OUT   << 2)
#endif

#endif

// message length for each ring
#define NUM_WORDS_ENQ_MESSAGE 	3
#define NUM_WORDS_DEQ_MESSAGE 	1
#define NUM_WORDS_TX_MESSAGE 	2
#define NUM_WORDS_SCHED_MESSAGE 1

/////////////////////////////////////////////////////
// Bunch of #defines
/////////////////////////////////////////////////////


// CAM MACRO
#define GET_CAM_HIT 		alu_shf[cam_hit, 0x1, AND, cam_result, >>7]     // ( (x >> 7 ) & 0x1 )
#define GET_CAM_STATUS		alu_shf[cam_status, 0xf, AND, cam_result, >>8]  // ( (x >> 8 ) & 0xf )
#define GET_CAM_ENTRY		alu_shf[cam_entry, 0xf, AND, cam_result, >>3]   // ( (x >> 3 ) & 0xf )

// SRAM QD Defines
// 
// Following diagram shows complete description of the Queue Descriptor located in SRAM
//
//    3 3 3 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
//   +---------------+---------------+---------------+---------------+
//   |E|S| seg_cnt(6)|             head_ptr(24)                      |
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |  RESERVED(8)  |             tail_ptr(24)                      |
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |  user data(8) |             q_count(24)                       |
//   +---------------+---------------+---------------+---------------+
// than starts optional info part of the QD
//   +---------------+---------------+---------------+---------------+
//   |                     timestamp_low(32)                         |
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |                    timestamp_high(32)                         |
//   +---------------+---------------+---------------+---------------+
//    E: EOP
//    S: SOP

#define SRAM_CHANNEL_NUMBER_FIELD	30			; used to define the qarray entry for q array operations.
#define SRAM_Q_ARRAY_NUMBER_FIELD	24			; used to define the qarray entry for q array operations.

// for CAM status
#define STATUS_VALID				0x1

// All these masks
#define ADDR_PTR_MASK				0x00ffffff	; to mask of eop,sop and cellcount
#define ENQ_IND_REF_MASK			0x001ff000	; enqueue indirect reference mask
#define SOPRESET_MASK				0xbf		; cell count mask
#define EOPCELLCOUNT_MASK			0x80		; to check eop bit set and last cell
#define MSB_SET						0x80000000	; 
#define DEQ_TRANS_CHECK				0x1			; used to check if there is deq transtion 
#define DEQ_MSG_PORT_CLP_MASK       0xBFFC0000  ; used to mask port number CLP bit and VCQ# value
#define QM_QAMSG_CELLCNT_MASK       0x3f000000  ; Mask used to retrieve cell count from the qarray message
#define QM_QAMSG_EOP_MASK           0x80000000  ; Used to check wheather EOP is set in qarray message
                                                
// Drop Queue defines
#define QM_LM_DROP_Q_BASE			0x400		; LM address for maintaining drop queue
												; packet count.
// All these bit numbers for shifts
#define EOPCELLCOUNT_BITS			24			; shift to get start of cellcount

// Used to define timestamp offset in Queue Descriptor (LW6 of the QD, counted in bytes)
#define QM_TIMESTAMP_OFFSET			12

/* this should be defined in dl_system.h */	
#ifndef NUM_CLASS_BITS	
#warning "NUM_CLASS_BITS is not defined. It should be defined in dl_system.h!"
#define NUM_CLASS_BITS				4
#endif

/* this should be defined in dl_system.h */
#ifndef NUM_PORT_BITS
#warning "NUM_PORT_BITS is not defined. It should be defined in dl_system.h!"

/* Defines number of bits used to address interface (scratch rings to Tx) in SPHY 4_8 mode */
/* Note that NUM_PORT_BITS applies to MSB not LSB bits */
#define NUM_PORT_BITS				11
#endif

// Prepare mask for VALID bit and VCQ# in Enqueue Message LW2 (from LLCSNAP)
//    1     1        11          1      3           16
// ----------------------------------------------------------------
// | VAL | RES | Cell count   | CLP |  RES  |        VCQ#         |
// ----------------------------------------------------------------
//    1     0    0 0 0 ... 0 0   0    0 0 0   1 1 1 1 ....1 1 1 1

// NOTE that the same mask can be used to mask dequeue message from Scheduler
//    1     1         11         1     2           17 (used only 16)
// ----------------------------------------------------------------
// | VAL | RES |  Cell count  | CLP | RES |        VCQ#           |
// ----------------------------------------------------------------
//    1     0    0 0 0 ... 0 0   0    0 0   0 1 1 1 1 ....1 1 1 1
#define 		ENQ_DEQ_QUEUE_NUM_MASK			0x8000ffff

////////////////////////////////////////////////////////////////////
//    Local Memory definitions
////////////////////////////////////////////////////////////////////

//  Format of the data stored in Local Memory
//
//    3 3 3 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
//   +---------------+---------------+---------------+---------------+
//   |                       cell_count(32)                          |   LW stored in *l$index0[0]
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |                       Reserved                                |   LW stored in *l$index0[1]
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |       reference counter used to flush q_count to SRAM(32)     |   LW stored in *l$index0[2]
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |               |               |               |         |T|C|S|   LW stored in *l$index0[3]
//   +---------------+---------------+---------------+---------------+
//	 S - Flag descriptor set bit (request for dummy tx pending)
//   C - Status of S bit changed since data loaded into SRAM
//   T - Transmit flag descriptor (set to indicate dummy Tx in this beat)

// SCR6029 
// ATM OAM related #defines
// Bit and position indicating a pending flag descr schedule request
#define FLAG_DESCR_SET_BIT			0x01
#define FLAG_DESCR_SET_BIT_POS 		0x00

// Bit and position indicating flag descriptor changed
#define	FLAG_DESCR_CHANGED_BIT		0x02
#define FLAG_DESCR_CHANGED_BIT_POS	0x01

// Bit and position indicating flag descriptor to be sent in this beat
#define FLAG_DESCR_TX_BIT			0x04
#define FLAG_DESCR_TX_BIT_POS		0x02

// Bit indicating any activity on the flag descriptor
#define FLAG_DESCR_SET_CHANGED_MASK (FLAG_DESCR_SET_BIT | FLAG_DESCR_CHANGED_BIT)

// Define a invalid buffer handle for AAL5 to request
// scheduling of an empty slot to send buffered cell
#ifndef	ATM_OAM_FLAG_DESCR
#define ATM_OAM_FLAG_DESCR			0xC1FFFFFF
#endif // ATM_OAM_FLAG_DESCR

// Bit number for detecting enqueue transition messages (empty queue getting data)
// Because of GFR support we have to set also SOP indication for each transition
// during the enqueue operation. This means that we also mark an SOP bit here
//    3 3 3 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
//   +---------------+---------------+---------------+---------------+
//   |V|T|C|   cell_count(11)    |S|   Enqueue queue number (17)     | LW0 (QM2Sched-enqueue)
//   +---------------+---------------+---------------+---------------+
//    1 1 x x x x x x x x x x x x 1 x x x x x x x x x x x x x x x x x
//   V - Bit VALID - it should be 1
//   T - Enqueue Transition
//   C - CLP bit value
//   S - SOP bit value 
#define QM_ENQ_TRANSITION_BIT_MASK           0xc0020000

// Bit number for detecting dequeue transition messages (queue going to empty)
// Because of GFR support we have to clear also SOP bit for each transition
// during the dequeue operation.
//    3 3 3 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
//   +---------------+---------------+---------------+---------------+
//   |V|T|C|   cell_count(11)    |S|   Enqueue queue number (17)     | LW1 (QM2Sched-dequeue)
//   +---------------+---------------+---------------+---------------+
//    1 1 x x x x x x x x x x x x 0 x x x x x x x x x x x x x x x x x
//   V - Bit VALID - it should be 1
//   T - Enqueue Transition
//   C - CLP bit value
//   S - SOP bit value 
#define QM_DEQ_TRANSITION_BIT_MASK           0xc0000000

// Bit mask for removing reserved bits from messages send to QM from processing blocks
//    3 3 3 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
//   +---------------+---------------+---------------+---------------+
//   |E|S| seg_cnt(6)|             SOP buffer handle(24)             | LW0
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |E|S| seg_cnt(6)|             EOP buffer handle(24)             | LW1
//   +---------------+---------------+---------------+---------------+
//   +---------------+---------------+---------------+---------------+
//   |V|R|C|   cell_count(11)    |R R|   Enqueue queue number (16)   | LW2 
//   +---------------+---------------+---------------+---------------+
//    1 1 x x x x x x x x x x x x 0 x x x x x x x x x x x x x x x x x
//   V - Bit VALID - it should be 1
//   R - Reserved bits
//   C - CLP bit value
#define QM_ENQ_MSG2_RESV_BIT_MASK           0xBFFCFFFF

// If we need to mask only SOP bit value we can use this constant
// (common for enaueue and dequeue)
#define QM_ENQ_DEQ_SOP_BIT_MASK           	 0x00020000

// If we want to mask only ENQ Q Number shifted to get SRAM base from message 
#define QM_ENQ_DEQ_VCQNO_MASK				 0x0003FFFF

// If we want to mask only ENQ Q Number in message
#define QM_ENQ_DEQ_VCQ_MASK                  0x0001FFFF

// Bit number for invalid dequeues
#define QM_INVALID_DEQUEUE_BIT_MASK			 0xa0000000

// Format of the message sent from Scheduler to Queue Manager
//    3 3 3 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//    1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 <- bits
//   +---------------+---------------+---------------+---------------+
//   |V|R|   port number(11)   |C|R| Enqueue queue number - VCQ(17)  |
//   +---------------+---------------+---------------+---------------+
//    0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
//   V - Bit VALID - it should be 1
//   R - reserved
//   C - CLP bit value

// Because of performanc we will define a mask changing according to number of ports defined for the
// port (so we take only a NUM_PORT_BITS bits from the whole 11 bits of the port)
// This shift will be used to set bits on positions required by the JUMP operation
#define QM_JUMP_SHIFT                   2

// This is a starting point of the port number in Scheduler dequeue message
#define QM_ATM_PORT_BITS_SHIFT          19

// Mask needed to extract port number and place it on the JUMP-required position
#define_eval QM_SCHED_DEQ_PORT_MASK     (((1<<NUM_PORT_BITS) - 1)<<QM_JUMP_SHIFT)

// Number of cycles to be consumed when no request from SCRATCH was read (do not flood the controler
// with request if scratch rings are empty)
#define QM_NO_REQ_DELAY 					 15

// Initial value of reference counter used in Queue Manager to calculate if SRAM update is needed
// After this number of enqueues/dequeues QM will sent an update to the SRAM. This is a support
// for WRED, which needs to have current queue count in QDs located in SRAM.
#define QM_REF_CNT							 8

// For INGRESS case EOP is not set
#define QM_OVERRIDE_BIT						 0x100000

#endif // QM_ATM_INCLUDE_H
