#ifndef	QM_ATM_DEFS_H
#define	QM_ATM_DEFS_H

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.  
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/


/* If vcq <= HBR_THRESHOLD, then the vcq is a high bit rate or UBR VC*/
#define 		HBR_THRESHOLD 					192
#define         HBR_QUEUE_THRESHOLD				64


#ifdef MICROCODE

/* Queue threshold defines the max number of packets that can be enqueued on a given */
/* low bit rate queue after which packets on that queue will be dropped by the QM. */
/* This enforces a policing mechanism to insure that low bit rate queues do not */
/* occupy all buffers in the system */
#ifdef  ENHANCED_QUEUE_THRESHOLD
    #define			QUEUE_THRESHOLD					ENHANCED_QUEUE_THRESHOLD
#else
    #define			QUEUE_THRESHOLD					16
#endif


#else


#endif

#endif	/* QM_ATM_DEFS_H */
