/////////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119 
//
//		
//		Change History
// 		--------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 12/11/01    	Queue Manager for IXP2400  						Aneet Chopra                 
// 11/11/02     Modified for IXP2800 - Cell Mode				Uday Naik
// 12/10/02		Modified for IXP2800 - Packet Mode				Dennis Tran
//                                                              
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef __QMMACRO_UC__
#define __QMMACRO_UC__

/////////////////////////////////////////////////////////////////////////////////////////

#include "qm.h" 	

/////////////////////////////////////////////////////////////////////////////////////////
//
// _qm_signal_next_ctx
//
//	 	Description: Signal next context (thread) in the same ME. 
//
//	 	Outputs:
//			None
//
//		Inputs:
//			in_signal_and_context			Signal number and Context (0-0xF).
//		
////////////////////////////////////////////////////////////////////////////////////////	

#macro _qm_signal_next_ctx[in_signal_and_context]

	local_csr_wr[SAME_ME_SIGNAL, in_signal_and_context]		; Signal the next thread

#endm

////////////////////////////////////////////////////////////////////////////////////////
//
// _qm_set_signal_next_ctx_reg
//
//	 	Description: This Macro sets the next_context_reg which is to be used
//		to signal the next context. Called at init time.
//
//	 	Outputs:
//			None
//
//		Inputs:
//			None
//		
//		Size:   			6 instructions
//
////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_set_signal_next_ctx_reg()
.begin

	.reg temp 
	
	br=ctx[7, ctx_7#]
				
		// for all other context signal next context

		alu[temp, --, B, &sig_prev_thread]
		alu[gl_next_context_sig, 0x80, OR, temp, <<3]
		br[sig_reg_setting_done#]

ctx_7#:
	
		// if it is ctx 7 then need to signal context 0

		move[temp, 0]
		alu[gl_next_context_sig, temp, OR, &sig_prev_thread, <<3]

sig_reg_setting_done#:

.end
#endm

////////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  :  _qm_nn_init
// Description : Macro to initialize next neighbour index register.
// Output      : Nil
// Input       : Nil
// Constant    : Nil
// Size		   : 5
//
////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_nn_init[]
.begin

	.reg ctx_enable

	// initialization
	// bit 20 in CTX_ENABLE - NN_MODE = 0 : next neighbor register are written
	//                                      by previous ME 
	// bits [19:18] in CTX_ENABLE - NN_RING_EMPTY = 10 : NN_EMPTY asserts when
	//                                                  NN_PUT <= NN_GET + 2
	// bits [15:8] CTX enables for contexts 0 to 7
	// initialize local csr CTX_ENABLES to 0xFF00, local csr NN_PUT and NN_GET
	// to 0

	// Set the NN ring empty threshold to 2 words
	local_csr_rd[ctx_enables]
	immed[ctx_enable, 0]
	alu_shf[ctx_enable, ctx_enable, AND~, 3, <<18]
	alu_shf[ctx_enable, ctx_enable, OR, 2, <<18]
	local_csr_wr[ctx_enables, ctx_enable]
	local_csr_wr[nn_put, 0]
	local_csr_wr[nn_get, 0]	
	alu[--, --, b, 0]
	alu[--, --, b, 0]
	alu[--, --, b, 0]

.end
#endm


////////////////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_q_array_init
// Description : Macro to initialize and preload 16 Q_Array entries and the drop queue
//               Q_Array entry.
// Output      : Nil
// Input       : Nil
// Constant    : Nil
// Size        : 17
////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_q_array_init[]
.begin

	.reg q_num, qa_cam_num, qa_cam_max, qarray_entry, $qdarray

	// set the initial queue number to 1 and Q Array entry to QM_QARRAY_BASE
	// queue number of 0 is invalid
	immed[q_num, 0x1]
	immed[qa_cam_num, QM_QARRAY_BASE]

	// final Q Array entry to be initialized

	alu[qa_cam_max, qa_cam_num, +, QM_QARRAY_SIZE]


qa_loop#:

	// set the channel number

	alu[qarray_entry, gl_channel_num, OR, qa_cam_num, <<SRAM_Q_ARRAY_NUMBER_FIELD]

	// Read the new queue into Q_Array

	_qm_read_q_array[ q_num, qarray_entry, $qdarray, sig_q_array_enq_r_done, INIT ] ; 3, 0

	// wait for read to complete

	ctx_arb[sig_q_array_enq_r_done]
		
	// update CAM with new tag entry

	cam_write[ qa_cam_num, q_num, STATUS_VALID]

	// increment queue number

	alu[q_num, q_num, +,1]

	// increment the QArray entry to be used in next iteration

	alu[qa_cam_num, qa_cam_num, +,1]

	alu[--, qa_cam_num, -, qa_cam_max]

	bne[qa_loop#]
	

go_ahead#:

	// Drop Queue Initialization 

	move[qa_cam_num, QM_DROP_QUEUE_ENTRY] 
	move[q_num, QM_DROP_QUEUE]

	// set the channel number

	alu[qarray_entry, gl_channel_num, OR, qa_cam_num, <<SRAM_Q_ARRAY_NUMBER_FIELD]

	// Read the new queue into Q_Array

	_qm_read_q_array[ q_num, qarray_entry, $qdarray, sig_q_array_enq_r_done, INIT ] ; 3, 0

	// wait for read to complete

	ctx_arb[sig_q_array_enq_r_done]

.end
#endm

////////////////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_thread0_init
// Description : Macro to initialize registers, rings and memory used by
//				 by Queue Manager
// Output      : Nil
// Input       : Nil
// Constant	   : Nil 
// Size        : 20
////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_thread0_init[]
.begin

 	.reg count, temp
	.reg reg, qa_cam_num, qarray_entry, $qdarray
	.reg $set_csr_reg, base, offset

	// clear the CAM		 

	cam_clear;
	
	// Initialize the NN ring

	_qm_nn_init[]


#ifdef PACKET_MODE

	// Set the SRAM Channel CSR to ignore cellcount and eop bit in the 
	// buffer handle. This implies that even though we could have chained
	// buffers h/w will enq/deq only one buffer. Therefore we enqueue and
	// dequeue a packet everytime.

	// This is the sram base address for a give channel

	move[base, SRAM_CHANNEL0_BASE_ADDRESS] 

	// this is the offset that indicates what CSR we are looking for.
	// In out case we want to write to SRAM_CONTROL CSR

	move[offset, OFFSET_SRAMCONTROL_CSR]

	sram[csr_rd, $set_csr_reg, base, offset], ctx_swap[sram_done]
	move[temp, $set_csr_reg]

	// The value in this transfer register will be written to 
	// the SRAM_CONTROL CSR. We are setting two bits that will
	// indicate to ignore cellcount but not the eop bit. Therefore all handles
	// that are being enqueue should have the eop bit set.

 	alu[$set_csr_reg,temp,OR,1,<<13] ;
	
	sram[csr_wr, $set_csr_reg, base, offset], ctx_swap[sram_done]

#endif

	//  Initialize Q_Array 

	_qm_q_array_init()

	// Initialize debug counters

	#ifdef _DEBUG_COUNTERS_
	immed[@qm_num_enq_requests, 0]
	immed[@qm_num_deq_requests, 0]
	immed[@qm_out_nn_ring_full, 0]
	#endif

.end
#endm

////////////////////////////////////////////////////////////////////////////////////////
// Macro Name  : qm_init
// Description : Macro to initialize registers, rings and memory used by
//				 by Queue Manager
// Output      : Nil
// Input       : Nil 
// Size        : 
////////////////////////////////////////////////////////////////////////////////////////

#macro qm_init[]
.begin

	.reg temp
	

	// set the next context signal register

	_qm_set_signal_next_ctx_reg()
	
	// set up a constant in a register to indirect reference during enqueues 

	move[gl_enq_ind_ref_mask_reg, ENQ_IND_REF_MASK]

	// Setting a global base register. Need to shift by 2, 
	// because address used in reading and writing QD 
	// instruction uses LW alighned addresses.

	immed32[temp, QD_SRAM_BASE] 
	alu[gl_qd_sram_base_reg, --,b, temp,>>2]

	// set the override bit used to override defaults in enqueue operation

#ifdef PACKET_MODE

	move(gl_override_bit, 0x180000) ; for egress the eop bit is always set
									; for SOP handle	
#else

	move(gl_override_bit, 0x100000) 

#endif

	// set the channel number for Q_Array

	move[gl_channel_num, CHANNEL_NUMBER]
	alu_shf[gl_channel_num, --, B, gl_channel_num, <<SRAM_CHANNEL_NUMBER_FIELD]

	// Initialize register used to get the address from a buffer handle

	move(gl_addr_ptr_mask_reg, ADDR_PTR_MASK)

	// Do init common to all threads in one single thread 

	.if( ctx() == 0 )

		// Thread 0 does the initialization

		_qm_thread0_init()

		// this is the signal that all blocks are to 
		// wait on to indicate that system initialization 
		// is done
		
		ctx_arb[sig_system_init_done]
			
    .else

		// wait for previous thread/context signal to wake you up

		ctx_arb[sig_prev_thread]
	
	.endif

.end
#endm 

/////////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_write_q_array
// Description : Macro to write the cached QDescriptor in Q_Array  back
//				 back to SRAM. .
// Output      : Nil
// Input       : in_queue_ptr, in_qarray_entry 
// Size        : 3
// Constant	   : nil
// Branches    : 0
//
/////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_write_q_array[ in_queue_ptr, in_qarray_entry ]
.begin

	.reg  qarray_sram_addr, dummy

	// This calculation helps in saving an instruction. We can use
	// different operator based on the Base address for queue descriptors.

	#ifdef IXP_SIMULATION

		#if (QD_SRAM_BASE > QD_TOTAL * QD_SIZE)

			alu[qarray_sram_addr, gl_qd_sram_base_reg, OR, in_queue_ptr, <<2]

		#else

			// need to mask of the MSB set of the queue number

			alu[dummy, gl_addr_ptr_mask_reg, AND, in_queue_ptr, <<2]

			// get the sram QD address based on the queue number
			// the address has to be LW alighned( ie byte address >> 2)

			alu[qarray_sram_addr,dummy , +, gl_qd_sram_base_reg]

		#endif

	#else

		// need to mask of the MSB set of the queue number

		alu[dummy, gl_addr_ptr_mask_reg, AND, in_queue_ptr, <<2]

		// get the sram QD address based on the queue number
		// the address has to be LW alighned( ie byte address >> 2)

		alu[qarray_sram_addr,dummy , +, gl_qd_sram_base_reg]

	
	#endif 

	sram[wr_qdesc,--, in_qarray_entry, qarray_sram_addr] 


.end
#endm

//////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_read_q_array
// Description : Macro to read and cache a Queue Descriptor entry from 
//				 SRAM to Q_Array. $QDArray is actually packet count.
// Output      : out_qd_array
// Input       : in_queue_ptr, in_qarray_entry, in_qa_signal
// Constant    : nil
// Size        : 4
// Branches    : 0
//
/////////////////////////////////////////////////////////////////////////////////////

#macro _qm_read_q_array[ in_queue_ptr, in_qarray_entry, out_qd_array, in_qa_signal, ACTION_TYPE ]
.begin

	.reg  qarray_sram_addr, dummy	
	
	// This calculation helps in saving an instruction. We can use
	// different operator based on the Base address for queue descriptors.

	#ifdef IXP_SIMULATION

		#if (QD_SRAM_BASE > (QD_TOTAL * QD_SIZE))

			alu[qarray_sram_addr, gl_qd_sram_base_reg, OR, in_queue_ptr, <<2]

		#else

			// need to mask of the MSB set of the queue number

			alu[dummy, gl_addr_ptr_mask_reg,AND, in_queue_ptr, <<2]

			// get the sram QD address based on the queue number
			// the address has to be LW alighned( ie byte address >> 2)

			alu[qarray_sram_addr,dummy , +, gl_qd_sram_base_reg]

		#endif

	#else

		// need to mask of the MSB set of the queue number

		alu[dummy, gl_addr_ptr_mask_reg,AND, in_queue_ptr, <<2]

		// get the sram QD address based on the queue number
		// the address has to be LW alighned( ie byte address >> 2)

		alu[qarray_sram_addr,dummy , +, gl_qd_sram_base_reg]
	
	#endif 

	// read the complete queue descriptor from the sram.

	#if ( streq('ACTION_TYPE', 'INIT') || streq('ACTION_TYPE', 'DEQ_MISS') )
	sram[rd_qdesc_head, out_qd_array, in_qarray_entry,qarray_sram_addr,2], sig_done[in_qa_signal]
	#endif

	#if ( streq('ACTION_TYPE', 'ENQ_MISS') )
	sram[rd_qdesc_tail, out_qd_array, in_qarray_entry,qarray_sram_addr,2], sig_done[in_qa_signal]
	#endif

	#if ( streq('ACTION_TYPE', 'INIT') )
	sram[rd_qdesc_other, --, in_qarray_entry, qarray_sram_addr]
	// Indicate the loading of the other descr by making the addr non zero
	alu[*l$index0[0], --, B, 1]
	#endif

	#if ( streq ('ACTION_TYPE', 'ENQ_HIT') || streq('ACTION_TYPE', 'DEQ_HIT') )
	// Load other only for the first hit
	alu[--, --, B, *l$index0[0]]
	bne[no_load_needed#]

	sram[rd_qdesc_other, --, in_qarray_entry, qarray_sram_addr]
	// Indicate the loading of the other descr by making the addr non zero
	alu[*l$index0[0], --, B, 1]

	no_load_needed#:
	// We need not perform a load of the other descr in this case

	#endif


.end
#endm

////////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_dequeue
// Description : Macro to issue dequeue requests to the SRAM Controller 
//				 to dequeue a cell from a queue. The queue should be 
//				 cached in the QArray. 
// Output      : out_qarray_message
// Input       : in_qarray_entry 
// Constant    : none
// Size        : 1
// Branches    : 0
//
////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_dequeue[ in_qarray_entry, out_qarray_message]
	  
	sram[dequeue, out_qarray_message, in_qarray_entry, 0], sig_done[sig_deq_done]

#endm

////////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_enqueue_packet_mode
//
// Description : Macro to issue enqueue requests to the SRAM Controller 
//				 to enqueue a packet to a queue. The queue should be 
//				 cached in the QArray. There are more instructions here
//				 which are primarily used to set the override bit using
//				 indirect reference.
//
// Output      : Nil
//
// Input       : in_sop_handle, in_qarray_entry 
//
// Size        : 5
//
///////////////////////////////////////////////////////////////////////////////////////

#macro _qm_enqueue_packet_mode[in_sop_handle, in_qarray_entry]
.begin

	.reg temp, temp2
	  	
	// setting up the indirect reference by setting the override bit

	alu[temp2, gl_override_bit, OR, in_sop_handle, >>12]

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_sop_handle, AND, gl_addr_ptr_mask_reg]

	// add the meta offset to the packet_next pointer since enqueue happens
	// using the packet_next field

	alu[temp, temp, +, META_PACKET_NEXT_LW_PTR]


	// set the non required bits to zero for indirect reference

	alu[--, temp2, AND, gl_enq_ind_ref_mask_reg]

	// enqueue 

 	sram[enqueue, --, in_qarray_entry, temp], indirect_ref

.end
#endm

///////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_enqueue_cell_mode
//
// Description : Macro to issue enqueue requests to the SRAM Controller 
//				 to enqueue a packet to a queue. The queue should be 
//				 cached in the QArray. There are more instructions here
//				 which are primarily used to set the override bit using
//				 indirect reference.
//
// Output      : Nil
//
// Input       : in_sop_handle,  in_eop_handle,   in_qarray_entry 
//
// Size        : 6 for min packet and 11 otherwise
//
// Branches    : 1
//
///////////////////////////////////////////////////////////////////////////////////////
#macro _qm_enqueue_cell_mode[in_sop_handle, in_eop_handle, in_qarray_entry]
.begin

	.reg temp, temp2

	// check if it is a min packet by check if sop, eop bit is set and
	// cell count is 0

	br!=byte[in_sop_handle, 3, 0xC0, non_min_packet#] 

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_sop_handle, AND, gl_addr_ptr_mask_reg]

	// enqueue.the buffer - by default sop/eop will be 1 and cell count will be 0

 	sram[enqueue, --, in_qarray_entry, temp]

	// enqueue and exit 

	br[exit#]
	  	
non_min_packet#:

	// setting up the indirect reference by setting the override bit

	alu[temp2, gl_override_bit, OR, in_sop_handle, >>12]

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_sop_handle, AND, gl_addr_ptr_mask_reg]

	// set the non required bits to zero for indirect reference

	alu[--, temp2, AND, gl_enq_ind_ref_mask_reg]

	// enqueue

 	sram[enqueue, --, in_qarray_entry, temp], indirect_ref

	// if single buffer but not min pkt, don't need to enqueue tail

	br_bset[in_sop_handle, EOP_BIT, exit#]

	// have to mask of the cell count, eop and sop bit for h/w use

	alu[temp, in_eop_handle, AND, gl_addr_ptr_mask_reg]

	sram[enqueue_tail, --, in_qarray_entry, temp]

exit#:

.end
#endm
 

/////////////////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_cam_check
//
//
// Description : This Macro checks if the requested queue's QDescriptor 
//				 is cached in the Q_Array. If it is then returns just the
//				 cam_entry. If not then a request is sent to evict an entry
//				 from Q_Array if required and read in the required queue's
//				 QD into the Q_Array and update the CAM accordingly. This macro
//				 also sets the signalmap based on hit or miss which later defines
//				 which signals to wait on.
//
// Output      : out_qd_array
//
// Input       : in_queue_id , sigmask, inout_qarray_entry, in_qa_signal, in_lmnum
//
// Size        : 14
// Branches    : 1
// Worst CAse  : 14
//
/////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_cam_check[ in_queue_id, inout_qarray_entry, out_qd_array, sigmask, \
					  in_qa_signal, in_lmnum, ACTION_TYPE]
.begin

	.reg 	cam_result
	.reg	cam_tag
	.reg	cam_entry

	// do a cam lookup to see if entry is present

	cam_lookup[ cam_result, in_queue_id ], lm_addr/**/in_lmnum[0]

	// get the cam entry

	alu_shf[cam_entry, 0xf, AND, cam_result, >>3]

	// setting the channelnum and q array entry. This is done before the branch
	// since it might be required for enqueue and dequeue operations in hit case.

	alu[inout_qarray_entry, gl_channel_num, OR, cam_entry, <<SRAM_Q_ARRAY_NUMBER_FIELD]

	// Get CAM tag. The reason this instruction has been moved out of branch since it 
	// cannot be the next instruction after br_bset. This instruction is not required
	// in a hit case though. 

	cam_read_tag[cam_tag, cam_entry] ;
	
	// check if result shows hit or miss
	
	br_bset[cam_result, 7, cam_hit#]

	// its a miss
	
	// write back the queue information 

	_qm_write_q_array[ cam_tag, inout_qarray_entry ] ; 3, 0

	// Read the new queue into Q_Array

	#if ( streq('ACTION_TYPE', 'ENQ') )

	_qm_read_q_array[ in_queue_id, inout_qarray_entry, out_qd_array, in_qa_signal, ENQ_MISS ] ; 4, 0

	#else

	_qm_read_q_array[ in_queue_id, inout_qarray_entry, out_qd_array, in_qa_signal, DEQ_MISS ] ; 4, 0

	#endif
		
	// add a signal to the signal mask 

	alu_shf[sigmask, sigmask, OR, 1, <<(&in_qa_signal)]

	// update CAM with new tag entry

	cam_write[ cam_entry, in_queue_id, STATUS_VALID ]

	br[end#], defer[1]

		// Clear the local memory area to indicate that other is not loaded
		alu[*l$index0[0], --, B, 0]

cam_hit#:

	// Read the new queue into Q_Array

	#if ( streq('ACTION_TYPE', 'ENQ') )

	_qm_read_q_array[ in_queue_id, inout_qarray_entry, out_qd_array, in_qa_signal, ENQ_HIT ] ; 4, 0

	#else

	_qm_read_q_array[ in_queue_id, inout_qarray_entry, out_qd_array, in_qa_signal, DEQ_HIT ] ; 4, 0

	#endif

end#:

.end  
#endm

////////////////////////////////////////////////////////////////////////////
//
// Macro Name  : _qm_send_transmit_message
//
// Description : This macro writes to the transmit NN ring
//
// Output      : NIL
//
// Input       : in_queue_number, in_buffer_handle 
//
// Size        : 5
//
// Branches	   : 1
//
////////////////////////////////////////////////////////////////////////////////////////

#macro _qm_send_transmit_message[in_buffer_handle, in_queue_number, OUT_LABEL]	
.begin

check_ring_full#:

	#ifdef _DEBUG_COUNTERS_
	br_inp_state[NN_FULL, ring_full#]
	#else
	br_inp_state[NN_FULL, check_ring_full#]
	#endif

	#ifdef _DEBUG_COUNTERS_
	alu[@qm_num_deq_requests, @qm_num_deq_requests, +, 1]
	#endif
	
	#ifdef PACKET_MODE
	
	#ifdef USE_TX_HELPER

		//  send port number to Tx

		#ifndef PORT_RR_SCHEDULER
			
			// For DRR scheduler, port number is in the bits 12..15 

			alu_shf[*n$index++, --, B, in_queue_number, >>12]	

		#else

			// For simple round robin scheduler port number is queue number - 1 

			alu[*n$index++, in_queue_number, -, 1]

		#endif

	#endif // USE_TX_HELPER

	// adjust the buf handle pointer that is pointing to the 7th LW of the meta data
	// back to its original value and write to Tx NN ring
	alu[*n$index++, in_buffer_handle, -, META_PACKET_NEXT_LW_PTR]

	br[OUT_LABEL]

	#else

	// write to Tx NN ring 
	alu[*n$index++, --, B, in_queue_number]
	alu[*n$index++, --, B, in_buffer_handle]

	br[OUT_LABEL]

	#endif // PACKET_MODE

#ifdef _DEBUG_COUNTERS_

ring_full#:

	alu[@qm_out_nn_ring_full, @qm_out_nn_ring_full, +, 1]

ring_full_loop#:
	br_inp_state[NN_FULL, ring_full_loop#]

	br[check_ring_full#]

#endif

.end
#endm

////////////////////////////////////////////////////////////////////////////////////////

#endif // __QMMACRO_UC__

////////////////////////////////////////////////////////////////////////////////////////