/****************************************************************************************
 *                                                                     
 *                 I N T E L   P R O P R I E T A R Y                   
 *                                                                     
 *    COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *    RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *    BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *    RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *    LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *    MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *    THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                     
 *                       INTEL  CORPORATION                            
 *                                                                    
 *                    2200 MISSION COLLEGE BLVD                        
 *                                                                     
 *              SANTA  CLARA,  CALIFORNIA  95052-8119 
 *
 *		
 *		Change History
 *		--------------
 *
 * Date			Description											Whom
 * ------------------------------------------------------------------------------------
 *
 * 12/11/01    	Queue Manager include file						Aneet Chopra                 
 * 11/11/02		Modified for IXP2800							Uday Naik
 *                                                                   
 ***************************************************************************************/

#ifndef __QM_INCLUDE_H__
#define __QM_INCLUDE_H__

/***************************************************************************************/

/* standard macros from IXPBlocks */

#include "stdmac.uc"
#include "localmem.uc"

/* dispatch loop header file  */

#include "dl_system.h"

/***************************************************************************************/

/* 
   Define values to be patched in by the XScale code. On simulation these are compile 
   time defined

 */

#ifdef USE_IMPORT_VAR

/* Base offset in SRAM where the Queue Descriptors are kept */

.import_var QD_SRAM_BASE

#else

/* defined in dl_system.h */

#endif /* USE_IMPORT_VAR */

/***************************************************************************************/


/*
   This signal is used to signal between threads
   basically every thread waits on the previous thread
   to signal
 */

.sig 	volatile sig_prev_thread
.addr	sig_prev_thread  				1

/* 
   When a deq request is issued this signal is used to 
   wait for the request to complete.
 */

.sig 	sig_deq_done
.addr	sig_deq_done 					2

/* 
   These signals are used to wait on q array read issued for enq and
   deq.
 */

.sig	sig_q_array_deq_r_done, sig_q_array_enq_r_done

.addr	sig_q_array_deq_r_done			3
.addr	sig_q_array_enq_r_done			4

/* this signal is used for any reads and writes to SRAM */

.sig	sram_done

/* 
   This is a global signal that indicates that 
   system initialization is done
 */

.sig	volatile sig_system_init_done
.addr 	sig_system_init_done			me_init_signal

/* define the default signal mask - sig_deq_done OR sig_prev_thread */

#define SIGMASK_DEFAULT					0x6


/***************************************************************************************

   Global register used to store constants 
  
*/

.reg	gl_next_context_sig
.reg	gl_override_bit
.reg	gl_channel_num
.reg	gl_addr_ptr_mask_reg
.reg	gl_qd_sram_base_reg
.reg	gl_enq_queue_num_mask
.reg	gl_enq_ind_ref_mask_reg

/***************************************************************************************

   Global registers used to debug
  
*/

#ifdef _DEBUG_COUNTERS_
// number of cells/packets enqueued
.reg	@qm_num_enq_requests
// number of dequeue requests sent to next block
.reg	@qm_num_deq_requests
// times the outgoing nn-ring is full
.reg	@qm_out_nn_ring_full
#endif
/***************************************************************************************

 Miscellaneous defines 

 */ 

/* SRAM QD Defines */

#define CHANNEL_NUMBER				0x0			/* SRAM Channel. Specifies which Q_Array to be used.			*/
#define SRAM_CHANNEL_NUMBER_FIELD	30			/* used to define the qarray entry for q array operations.		*/
#define SRAM_Q_ARRAY_NUMBER_FIELD	24			/* used to define the qarray entry for q array operations.		*/
#define SRAM_CHANNEL0_BASE_ADDRESS	0x0			/* used to set the SRAM CONTROL CSR								*/
#define OFFSET_SRAMCONTROL_CSR		0x0			/* used to set the SRAM CONTROL CSR								*/
#define META_PACKET_NEXT_LW_PTR 	0x7			/* during enq/deq the handle ptr is incremented by the define.	*/
												/* this is used for packet based dequeue and					*/
												/* not cell based dequeue.										*/


/* for CAM status */

#define STATUS_VALID				0x1

/* All these masks */
					
#define ADDR_PTR_MASK				0x00ffffff	/* to mask of eop,sop and cellcount				*/
#define ENQ_IND_REF_MASK			0x001ff000	/* enqueue indirect reference mask				*/							
#define TX_MESSAGE_QNUM_POSITION	24			/* for egress qnum is put in the MSByte of		*/
												/* the transmit message.						*/
// define the EOP bit in a handle 

#define EOP_BIT						31

/***************************************************************************************/

#endif /* __QM_INCLUDE_H__ */

/***************************************************************************************/