/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2400 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      Core Component Infrastructure - message handler and message callbacks
 *
 * = FILENAME
 *      ix_cc_ipv4_msg_handler.h
 *
 * = DESCRIPTION
 *      This file defines all data types and function prototypes required internaly by the 
 *      IPv4 CCI module.
 *
 * = AUTHOR
 *       Govindan Nair
 *       govindan.nair@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      07/03/2002 5:30 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: ix_cc_ipv4_msg_handler.h,v 1.2 2002/09/18 17:32:21 lbmiller Exp $
 */

#if !defined(__IX_CC_IPV4_MSG_HANDLER_H__)
#define __IX_CC_IPV4_MSG_HANDLER_H__


#if defined(__cplusplus)
extern "C" {
#endif /* end defined(__cplusplus) */


/**
 * TYPENAME: ix_cc_ipv4_add_route_data
 * 
 * DESCRIPTION: This structure defines format for add route message helper.
 *
 */
typedef struct ix_s_cc_ipv4_add_route_data
{
    ix_uint32 ipAddr;
    ix_uint32 netMask;
    ix_cc_rtmv4_nhid  nextHopId;
} ix_cc_ipv4_add_route_data;

/**
 * TYPENAME: ix_cc_ipv4_delete_route_data
 * 
 * DESCRIPTION: This structure defines format for delete route message helper.
 *
 */
typedef struct ix_s_cc_ipv4_delete_route_data
{
    ix_uint32 ipAddr;
    ix_uint32 netMask;
} ix_cc_ipv4_delete_route_data;

/**
 * TYPENAME: ix_cc_ipv4_add_next_hop_data
 * 
 * DESCRIPTION: This structure defines format for add next hop message helper.
 *
 */
typedef struct ix_s_cc_ipv4_add_next_hop_data
{
    ix_cc_rtmv4_nhid  nextHopId;
    ix_cc_rtmv4_next_hop_info nextHopInfo;
} ix_cc_ipv4_add_next_hop_data;


/**
 * TYPENAME: ix_cc_ipv4_set_mtu_data
 * 
 * DESCRIPTION: This structure defines format for set mtu message helper.
 *
 */
typedef struct ix_s_cc_ipv4_set_mtu_data
{
    ix_cc_rtmv4_nhid nextHopId;
    ix_uint32 mtu;
} ix_cc_ipv4_set_mtu_data;


/**
 * TYPENAME: ix_cc_ipv4_set_flags_data
 *
 * DESCRIPTION: This structure defines format for set flags message helper.
 *
 */
typedef struct ix_s_cc_ipv4_set_flags_data
{
    ix_cc_rtmv4_nhid nextHopId;
    ix_uint32 flags;
} ix_cc_ipv4_set_flags_data;

/**
 * TYPENAME: ix_cc_ipv4_general_callback_data
 * 
 * DESCRIPTION: This structure defines format for general callback data.
 *
 */
typedef struct ix_s_cc_ipv4_general_callback_data
{
    ix_cc_ipv4_cb_route_op pUserCallback;
    void* pUserContext;
} ix_cc_ipv4_general_callback_data;



/**
 * TYPENAME: ix_cc_ipv4_lookup_callback_data
 * 
 * DESCRIPTION: This structure defines format for lookup callback data.
 *
 */
typedef struct ix_s_cc_ipv4_lookup_callback_data
{
    ix_cc_ipv4_cb_lookup_route pUserCallback;
    void* pUserContext;
} ix_cc_ipv4_lookup_callback_data;


/**
 * TYPENAME: ix_cc_ipv4_dump_callback_data
 * 
 * DESCRIPTION: This structure defines format for dump callback data.
 *
 */
typedef struct ix_s_cc_ipv4_dump_callback_data
{
    ix_cc_ipv4_cb_dump_data pUserCallback;
    void* pUserContext;
} ix_cc_ipv4_dump_callback_data;





/**
 * TYPENAME: ix_cc_ipv4_sleep_time_callback_data
 * 
 * DESCRIPTION: This structure defines format for sleep time callback data.
 *
 */
typedef struct ix_s_cc_ipv4_icmp_callback_data
{
    ix_cc_ipv4_cb_get_sleep_time pUserCallback;
    void* pUserContext;
} ix_cc_ipv4_icmp_callback_data;





/**
 * TYPENAME: ix_cc_ipv4_statistics_callback_data
 * 
 * DESCRIPTION: This structure defines format for statistics callback data.
 *
 */
typedef struct ix_s_cc_ipv4_statistics_callback_data
{
    ix_cc_ipv4_cb_get_statistics pUserCallback;
    void* pUserContext;
} ix_cc_ipv4_statistics_callback_data;






/**
 * NAME: _ix_cc_ipv4_cb_genaral
 *
 * DESCRIPTION: This is a general callback function.Message support library 
 * calls this function to return the status of the requested asynchrouns operation 
 * @Param:  - IN  arg_Result: result of the asynchronous operation
 * @Param:  - IN  arg_pContext: context provided by caller
 * @Param:  - IN  arg_pMsg: return message
 * @Param:  - IN  arg_MsgLength: length of the message
 *
 * @Param:  - OUT - none
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CALLBACK - user callback returns error message
 * 
 */

ix_error _ix_cc_ipv4_cb_general(ix_error arg_Result,
                               void* arg_pContext,
                               void* arg_pMsg,
                               ix_uint32 arg_MsgLength);
/**
 * NAME: _ix_cc_ipv4_cb_lookup_rtm
 *
 * DESCRIPTION: This is a callback function for lookup rtm and get next hop message helpers. Message support library 
 * calls this function to return the status of the requested asynchrouns operation 
 * @Param:  - IN  arg_Result: result of the asynchronous operation
 * @Param:  - IN  arg_pContext: context provided by caller
 * @Param:  - IN  arg_pMsg: return message
 * @Param:  - IN  arg_MsgLength: length of the message
 *
 * @Param:  - OUT - none
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CALLBACK - user callback returns error message
 * 
 */
ix_error _ix_cc_ipv4_cb_lookup_rtm(ix_error arg_Result,
                                  void* arg_pContext,
                                  void* arg_pMsg,
                                  ix_uint32 arg_MsgLength);

/**
 * NAME: _ix_cc_ipv4_cb_dump_rtm
 *
 * DESCRIPTION: This is a callback function for dump(routes/next hops) message helpers. Message support library 
 * calls this function to return the status of the requested asynchrouns operation 
 * @Param:  - IN  arg_Result: result of the asynchronous operation
 * @Param:  - IN  arg_pContext: context provided by caller
 * @Param:  - IN  arg_pMsg: return message
 * @Param:  - IN  arg_MsgLength: length of the message
 *
 * @Param:  - OUT - none
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CALLBACK - user callback returns error message
 * 
 */
ix_error _ix_cc_ipv4_cb_dump_rtm(ix_error arg_Result,
                                 void* arg_pContext,
                                 void* arg_pMsg,
                                 ix_uint32 arg_MsgLength);



/**
 * NAME: _ix_cc_ipv4_cb_icmp
 *
 * DESCRIPTION: This is a callback function for ICMP message helpers. Message support library 
 * calls this function to return the status of the requested asynchrouns operation 
 * @Param:  - IN  arg_Result: result of the asynchronous operation
 * @Param:  - IN  arg_pContext: context provided by caller
 * @Param:  - IN  arg_pMsg: return message
 * @Param:  - IN  arg_MsgLength: length of the message
 *
 * @Param:  - OUT - none
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CALLBACK - user callback returns error message
 * 
 */
ix_error _ix_cc_ipv4_cb_icmp(ix_error arg_Result,
                                     void* arg_pContext,
                                     void* arg_pMsg,
                                     ix_uint32 arg_MsgLength);



/**
 * NAME: _ix_cc_ipv4_cb_statistics
 *
 * DESCRIPTION: This is a callback function for statistics message helper. Message support library 
 * calls this function to return the status of the requested asynchrouns operation 
 * @Param:  - IN  arg_Result: result of the asynchronous operation
 * @Param:  - IN  arg_pContext: context provided by caller
 * @Param:  - IN  arg_pMsg: return message
 * @Param:  - IN  arg_MsgLength: length of the message
 *
 * @Param:  - OUT - none
 * 
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CALLBACK - user callback returns error message
 * 
 */
ix_error _ix_cc_ipv4_cb_statistics(ix_error arg_Result,
                                      void* arg_pContext,
                                      void* arg_pMsg,
                                      ix_uint32 arg_MsgLength);





#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_IPV4_MSG_HANDLER_H__) */
