/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2400 Network Processor, Release 5
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      IPv4 Forwarder Core Component
 *
 * = FILENAME
 *      ix_cc_ipv4_fini.h
 *
 * = DESCRIPTION
 *      This file defines all data types and function prototypes required internaly by the 
 *      IPv4 CCI module.
 *
 * = AUTHOR
 *       Govindan Nair
 *       govindan.nair@intel.com
 *
 * = AKNOWLEDGEMENTS
 *      
 *
 * = CREATION TIME
 *      06/24/2002 5:30 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: ix_cc_ipv4_fini.h,v 1.3 2003/04/22 01:12:09 ktseng Exp $
 */

#if !defined(__IX_CC_IPV4_FINI_H__)
#define __IX_CC_IPV4_FINI_H__


#if defined(__cplusplus)
extern "C" {
#endif /* end defined(__cplusplus) */



/**
 * NAME: _ix_cc_ipv4_free_symbols
 *
 * DESCRIPTION: This primitive will be used to free memory for symbols 
 * allocated for patching.         .
 * 
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_OOM - failed to free memory for symbols.
 * 
 */

ix_error _ix_cc_ipv4_free_symbols(void);

/**
 * NAME: _ix_cc_ipv4_delete_64bit_counters
 *
 * DESCRIPTION: This primitive will be used to delete 64 bit counters. 
 * 
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_OOM_64BIT_COUNTER - failed to delete 64 bit counter.
 * 
 */

ix_error _ix_cc_ipv4_delete_64bit_counters(void);

/**
 * NAME: _ix_cc_ipv4_terminate_rtm_services
 *
 * DESCRIPTION: This primitive will be used to terminate RTM services: 
 * 1. remove invalid addresses added by IPv4 Forwarder Core component.
 * 2. Remove added next hops by IPv4 Forwarder Core component
 * 3. Terminate RTM by calling fini function of RTM
 * 
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_RTM - error from RTM
 * 
 */

ix_error _ix_cc_ipv4_terminate_rtm_services(void);


/**
 * NAME: _ix_cc_ipv4_unregister_message_handler
 *
 * DESCRIPTION: This primitive will be used to unregister message handler. 
 * It calls CCI services in level 1 systema and resore manager services in
 * level 0 system.
 *
 * @Param:  - IN 
 *
 * @Param:  - OUT 
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CCI - error from CCI
 * 
 */

ix_error _ix_cc_ipv4_unregister_message_handler(void);


/**
 * NAME: _ix_cc_ipv4_unregister_cci_packet_handlers
 *
 * DESCRIPTION: This primitive will be used to unregister packet handler with CCI. 
 * 
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CCI - error from CCI
 * 
 */

ix_error _ix_cc_ipv4_unregister_cci_packet_handlers(void);


/**
 * NAME: _ix_cc_ipv4_unregister_rm_packet_handlers
 *
 * DESCRIPTION: This primitive will be used to unregister packet handler with 
 * resource manager
 * 
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CCI - error from RM
 * 
 */

ix_error _ix_cc_ipv4_unregister_rm_packet_handlers(void);


/**
 * NAME: _ix_cc_ipv4_unregister_packet_handlers
 *
 * DESCRIPTION: This primitive will be used to unregister packet handler 
 * with CCI/Resource manager
 *
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CCI - error from CCI/RM
 * 
 */

ix_error _ix_cc_ipv4_unregister_packet_handlers(void);


/**
 * NAME: _ix_cc_ipv4_delete_icmp_event_handler
 *
 * DESCRIPTION: This primitive will be used to delete event handler.
 * User needs to implement this function in level0 system.
 *
 * @Param:  - IN ix_ossl_thread_t arg_pEventId - id of ICMP event hanlder
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_ERROR_UNIMPL - not implemented.
 * 
 */
ix_error _ix_cc_ipv4_delete_icmp_event_handler(void);

/**
 * NAME: _ix_cc_ipv4_delete_event_handler
 *
 * DESCRIPTION: This primitive will be used to delete icmp event handler. 
 * It calls CCI delete event handler function to delete an event handler in level1
 * system and calls _ix_cc_ipv4_delete_event_handler in level 0 system
 * 
 *           .
 * 
 * @Param:  - IN none
 *
 * @Param:  - OUT none
 *
 * @Return: IX_SUCCESS if successful or a valid error token for failure.
 *
 * Error Codes:
 * 
 * IX_CC_IPV4_ERROR_CCI - error from delete event hanler
 * 
 */

ix_error _ix_cc_ipv4_delete_event_handler(ix_ossl_thread_t arg_pEventId);


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_IPV4_FINI_H__) */
