/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      IPv4 Forwarder Core Component - ICMP module
 *
 * = FILENAME
 *      icmp_queue.h
 *
 * = DESCRIPTION
 *	This file defines all the functions for 
 *      ICMP queue implementation and manipulation      
 *
 *       
 *
 * = CREATION TIME
 *     7/15/2002 6:53:42 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: icmp_queue.h,v 1.5 2003/04/22 01:12:09 ktseng Exp $
 */

#if !defined(__ICMP_QUEUE_H__)
#define __ICMP_QUEUE_H__

#include "utils.h"

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * Preprocessor symbol and macro definitions.
 */
#define IX_CC_IPV4_ICMPQ_MAXSIZE    8


/**
 * Type definitions.
 */
/* This macro returns the no. of items currently in queue */
#define IX_CC_IPV4_ICMP_GET_QUEUE_SIZE(IX_CC_IPV4_ICMPQHEAD, IX_CC_IPV4_ICMPQTAIL)\
((IX_CC_IPV4_ICMPQ_MAXSIZE - IX_CC_IPV4_ICMPQHEAD + IX_CC_IPV4_ICMPQTAIL )\
           % IX_CC_IPV4_ICMPQ_MAXSIZE )

/* This macro checks if queue is empty */
#define IX_CC_IPV4_ICMP_IS_QUEUE_EMPTY(IX_CC_IPV4_ICMPQHEAD, IX_CC_IPV4_ICMPQTAIL) \
 ((IX_CC_IPV4_ICMPQHEAD == IX_CC_IPV4_ICMPQTAIL) ? (1):(0))

/* This macro checks if queue is full */
#define IX_CC_IPV4_ICMP_IS_QUEUE_FULL(IX_CC_IPV4_ICMPQHEAD, IX_CC_IPV4_ICMPQTAIL) \
((IX_CC_IPV4_ICMPQHEAD == ((IX_CC_IPV4_ICMPQTAIL + 1)% IX_CC_IPV4_ICMPQ_MAXSIZE))\
       ? (1):(0))

/**
 * Prototypes for interface functions.
 */

/**
 * NAME: _ix_cc_ipv4_icmp_queue_init
 *
 * DESCRIPTION: This function initializes the queue parameters
 *                
 * 
 * @Param:  - IN  None
 *		
 *            
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None  
 *
 * @Return: None
 */
void _ix_cc_ipv4_icmp_queue_init(void);


/**
 * NAME: _ix_cc_ipv4_icmp_queue_enqueue
 *
 * DESCRIPTION: This function is used to add the value passed in to
 *              the end of the
 *              queue, if the queue is not already full   
 * 
 * @Param:  - IN arg_hBuffer - the value to add to the tail of the queue  
 *		
 *            
 * @Param:  - INOUT  - None
 * @Param:  - OUT - arg_pEnqueue - 0 if able to enqueue, 1 otherwise  
 *
 * @Return: IX_SUCCESS if successful, or a valid ix_error token on failure
 */

ix_error _ix_cc_ipv4_icmp_queue_enqueue(ix_buffer_handle arg_hBuffer,
                                       ix_uint32 *arg_pEnqueue);

/**
 * NAME: _ix_cc_ipv4_icmp_queue_dequeue
 *
 * DESCRIPTION: This function is used to remove the item at the front of
 *             the queue and return it   
 * 
 * @Param:  - IN  None
 *		
 *            
 * @Param:  - INOUT  - None
 * @Param:  - OUT - arg_phBuffer - the value that gets dequeued from
 *                   the queue
 *             arg_pDequeue - 0 if call was successful, 1 if queue was empty  
 *
 * @Return: IX_SUCCESS if the call was successful, a valid ix_error token on
 *         failure
 */

ix_error _ix_cc_ipv4_icmp_queue_dequeue(ix_buffer_handle *arg_phBuffer,
                                        ix_uint32 *arg_pDequeue);

/**
 * NAME: _ix_cc_ipv4_icmp_print_queue
 *
 * DESCRIPTION: This function prints the head and tail pointers, the number
 *             of items
 *              in the queue and the contents of the queue   
 * 
 * @Param:  - IN  None
 *		
 *            
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *          on failure
 */
ix_error _ix_cc_ipv4_icmp_print_queue(void);

/**
 * NAME: _ix_cc_ipv4_icmp_dump_queue
 *
 * DESCRIPTION: This function prints the head and tail pointers, the 
 *              number of items
 *              in the queue and the contents of the queue   
 * 
 * @Param:  - IN arg_BufferSize  - size of buffer where the contents of
 *               queue needs to be dumped 
 *		
 *            
 * @Param:  - INOUT  - arg_phBuffer - the string buffer where the contents
 *                    of queue are printed
 * @Param:  - OUT - None  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *           on failure
 */
ix_error _ix_cc_ipv4_icmp_dump_queue(ix_uint32 arg_BufferSize,
                                    ix_buffer_handle *arg_phBuffer);




/**
 * Exported variables.
 */
extern ix_buffer_handle g_IcmpQueue[IX_CC_IPV4_ICMPQ_MAXSIZE];
extern ix_uint32 g_IcmpQhead;
extern ix_uint32 g_IcmpQtail;

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__ICMP_QUEUE_H__) */

