/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor
 *
 * 
 *      
 *
 * = MODULE
 *      IPv4 Forwarder
 *
 * = FILENAME
 *      header_validation.h
 *
 * = DESCRIPTION
 *     This file contains definition of functions used
 *     for IP header validation according to RFC1812 
 *      
 *
 * 
 *
 * = CREATION TIME
 *      8/09/2002
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: header_validation.h,v 1.5 2002/12/13 19:45:03 rjpetri Exp $
 */

#if !defined(__HEADER_VALIDATION_H__)
#define __HEADER_VALIDATION_H__

#if defined(__cplusplus)

extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * Preprocessor symbol and macro definitions.
 */
#include "ix_cc_error.h"
#include "header_defs.h"
#include "utils.h"
#include "ix_netmacros.h"


/**
 * Type definitions.
 */

/**
 * Prototypes for interface functions.
 */

/**
 * NAME: _ix_cc_ipv4_IPheader_validate
 *
 * DESCRIPTION: This function validates the IP header 
 *              according to RFC1812 Section 5.2.2 
 * 
 * @Param:  - IN  arg_pIpHdr - a pointer to IPv4 header
 *		  arg_hBuffer - a buffer containing the packet
 *                              with IP header
 * @Param:  - INOUT  None
 * @Param:  - OUT arg_pDropped - value to tell whether the packet
 *				should be dropped or forwarded  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *             for failure.
 * Error codes: IX_CC_IPV4_ERROR_INVALID_HEADER
 *              IX_CC_ERROR_INTERNAL
 */

ix_error _ix_cc_ipv4_IPheader_validate(
			ix_cc_ipv4_header *arg_pIpHdr,
			ix_buffer_handle arg_hBuffer,
                        ix_uint32 *arg_pDropped
			);


/**
 * NAME:_ix_cc_ipv4_validate_IP_addresses 
 *
 * DESCRIPTION: This function checks the Destination
 *           IP address and Source IP address in the
 *           given buffer to make sure
 *           that they do not contain any unrouteable
 *           addresses according to RFC1812 
 *           Section 4.2.2.11 
 * 
 * @Param:  - IN  arg_pIpHdr - a pointer to IPv4 header
 *		  arg_hBuffer - a buffer containing the packet
 *                              with IP header
 * @Param:  - INOUT  None
 * @Param:  - OUT arg_pDropped - value to tell whether the packet
 *				should be dropped or forwarded  
 *
 * @Return: IX_SUCCESS if successful or a valid ix_error token
 *             for failure.
 * Error codes: IX_CCI_ERR_SEND_FAIL
 *              IX_CC_ERROR_INTERNAL
 */


ix_error _ix_cc_ipv4_validate_IP_addresses( 
                                 ix_cc_ipv4_header *arg_pIpHdr, 
                                 ix_buffer_handle arg_hBuffer,
                                 ix_uint32 *arg_pDropped);




/**
 * Exported variables.
 */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__HEADER_VALIDATION_H__) */

