/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2001 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor, Release 4
 *
 * = LIBRARY
 *      
 *
 * = MODULE
 *      IPv4 Forwarder Core Component
 *
 * = FILENAME
 *      header_defs.h
 *
 * = DESCRIPTION
 *   This file contains definition of IPv4 header structure   
 *
 *
 * = CREATION TIME
 *      6/11/2002 1:53:42 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: header_defs.h,v 1.5 2002/12/13 19:45:03 rjpetri Exp $
 */

#if !defined(__HEADER_DEFS_H__)
#define __HEADER_DEFS_H__

/**
 * Preprocessor symbol and macro definitions.
 */
#include <stdio.h>
#include <ix_ossl.h>
#include <ix_rm.h>
#include <ix_cc.h>
#include <ix_netmacros.h>
#include "ix_cc_error.h"
#include "bindings.h"


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


/************ICMP *******************************/
/** Defines for Destination Unreachable error message **/
#define IX_ICMP_UNREACH    3
#define IX_ICMP_UNREACH_HOST    1
#define IX_ICMP_UNREACH_NETWORK    0
#define IX_ICMP_UNREACH_PORT       3
#define IX_ICMP_UNREACH_NEED_FRAG    4

/** Defines for Redirect ICMP error message **/
#define IX_ICMP_REDIRECT    5
#define IX_ICMP_REDIRECT_HOST    1

/** Defines for Time Exceeded ICMP error message **/
#define IX_ICMP_TIMEXCEED    11
#define IX_ICMP_TIMEXCEED_INTRANS    0

/** Defines for Source Quench ICMP error message **/
#define IX_ICMP_SOURCEQUENCH    4
#define IX_ICMP_SOURCEQUENCH_ROUTER    0
/** Defines for Parameter Problem ICMP error message **/
#define IX_ICMP_PARAMPROB            12
#define IX_ICMP_PARAM_VERS            0
#define IX_ICMP_PARAM_HEADERLENGTH    0
#define IX_ICMP_PARAM_TOS             1
#define IX_ICMP_PARAM_TOTALLENGTH     2
#define IX_ICMP_PARAM_ID              4
#define IX_ICMP_PARAM_FLAGS           6
#define IX_ICMP_PARAM_OFFSET          6
#define IX_ICMP_PARAM_TTL             8
#define IX_ICMP_PARAM_PROTO           9
#define IX_ICMP_PARAM_CHECKSUM       10
#define IX_ICMP_PARAM_SOURCEIP       12
#define IX_ICMP_PARAM_DESTIP         16
#define IX_ICMP_PARAM_OPTION         20

/** General defines for ICMP **/
#define IX_ICMP_MIN_DATA 8
#define IX_ICMP_HDR_LEN 8
#define MIN_IP_LEN 20
#define IX_IP_PROTOICMP 1
#define IX_IP_DEFAULTTTL 32

#define ETH_HDR_LEN 14
/**
 * Type definitions.
 */

#define IX_CC_IPV4_SUCCESS 1
#define IX_CC_IPV4_FAIL 0
/**
 * TYPENAME: ix_ipv4_header
 * 
 * DESCRIPTION: This struct defines the format of IP header 
 *
 */

typedef struct ix_s_ipv4_header{
#if IX_BYTE_ORDER == IX_LITTLE_ENDIAN
	ix_uint8    headerLength:4,
    version:4;
#elif IX_BYTE_ORDER == IX_BIG_ENDIAN
    ix_uint8    version:4,           /* IP version */
                headerLength:4;     /* Header length in words */
#endif
    ix_uint8    tos;                 /* Type of service */
    ix_uint16   totalLength;        /* Length of packet */
    ix_uint16   id;                  /* Unique ID */

#if IX_BYTE_ORDER == IX_LITTLE_ENDIAN

    ix_uint16   fragOffset;
                                /*Offset in buffer to first IP option*/
#elif IX_BYTE_ORDER == IX_BIG_ENDIAN
	ix_uint16   flags:3,
    offset:13;
#endif
    ix_uint8    ttl;                 /* Time to live (in hops) */
    ix_uint8    protocol;            /* Protocol carried in IP packet */
    ix_uint16    checksum;  	    /* One's complement checksum **/
    ix_uint32   sourceAddress;      /* IPv4 source address */
    ix_uint32   destAddress;        /* IPv4 destination address */
    ix_uint32   options[20];        /** options can be 0-40 bytes **/

} ix_cc_ipv4_header;

/**
 * TYPENAME: ix_icmp_header
 * 
 * DESCRIPTION: This struct defines the format of ICMP header 
 *
 */
typedef struct ix_s_cc_ipv4_icmp_header
{
    ix_uint8    type;
    ix_uint8    code;
    ix_uint16   checksum;
    ix_uint32   extra;
} ix_cc_ipv4_icmp_header;



/**
 * Prototypes for interface functions.
 */

/**
 * Exported variables.
 */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__HEADER_DEFS_H__) */
