/*/////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
/////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: ipv4_mcast_fwder_uc.h
//
//      Purpose: Defines constants used by the IPV4 Multicast Forwarder
//		microblock. 
//
/////////////////////////////////////////////////////////////////////////////
*/

#ifndef	_IPV4_MCAST_FWDER_UC_H_
#define	_IPV4_MCAST_FWDER_UC_H_

/*
 * MFIB entry indices
 */

#define		MFIB_NEXT_ENTRY		0
#define		MFIB_FLAGS			0
#define		MFIB_SRC_ADDR		1
#define		MFIB_GRP_ADDR		2
#define		MFIB_MTID			3
#define		MFIB_SRC_PORT		3

#define		MFIB_ENTRY_SHF_VAL		4		/* each entry is 32 bytes */
#define		MFIB_ENTRY_VALID_BIT	31		/* valid bit - position */
#define		IPV4_MFIB_ENTRY_SIZE_LW	4

/*
 * Flag definitions
 */

#define		IPV4_MCAST_LOCAL_BIT			0
#define		IPV4_MCAST_DROP_BIT				1


/*
 * Exception codes
 */

#define		IPV4_MCAST_EXCP_LOCAL			0x30
#define		IPV4_MCAST_EXCP_LOOKUP_FAILED	0x31
#define		IPV4_MCAST_EXCP_SPECIAL_ADDR	0x32
#define		IPV4_MCAST_EXCP_OPTIONS			0x33


/*
 * Import variables
 */

#ifdef	USE_IMPORT_VAR

	.import_var	IPV4_MFIB_TABLE_BASE

	.import_var	IPV4_MCAST_RESERVED_BLADE_ID

	.import_var	THIS_BLADE_ID

	.import_var	BID_IPV4_MCAST_FWDER_NEXT1

	.import_var	BID_IPV4_MCAST_EXCP_NEXT1

#else	/* USE_IMPORT_VAR */

	#ifndef	IPV4_MFIB_TABLE_BASE

	#error	"Define IPV4_MFIB_TABLE_BASE in system level header file"

	#endif	/* IPV4_MFIB_TABLE_BASE */

	#ifndef	MCAST_RESERVED_BLADE_ID

	#error	"Define MCAST_RESERVED_BLADE_ID in system level header file"

	#endif	/* MCAST_RESERVED_BLADE_ID */

	#ifndef	THIS_BLADE_ID

	#error	"Define	THIS_BLADE_ID in system level header file"

	#endif	/* THIS_BLADE_ID */

	#ifndef	BID_IPV4_MCAST_FWDER_NEXT1

	#error	"Define	BID_IPV4_MCAST_FWDER_NEXT1 in system level header file"

	#endif	/* BID_IPV4_MCAST_FWDER_NEXT1 */

	#ifndef	BID_IPV4_MCAST_EXCP_NEXT1

	#error	"Define	BID_IPV4_MCAST_EXCP_NEXT1 in system level header file"

	#endif	/* BID_IPV4_MCAST_EXCP_NEXT1 */

#endif	/* USE_IMPORT_VAR */



#endif	/* _IPV4_MCAST_FWDER_UC_H_ */
