////////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: sphy_mphy4_tx_init.uc
//
//      Purpose: Initialization macros for Packet (POS/Ethernet) TX
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __SPHY_MPHY4_TX_INIT_UC__
#define __SPHY_MPHY4_TX_INIT_UC__


///////////////////////////////////////////////////////////////////////////////
// _sphy_mphy4_tx_thread_specific_init()
//
// Description: initialize context relative GPRs for specific thread to save 
//              instruction cycles in POS TX processing
//
// Outputs: 
//      scratch_ring:		scratch ring number used to get tx requet
//      out_next_ctx_sig1:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 1
//      out_next_ctx_sig2:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 2
//      out_next_ctx_sig3:	value used to write to SAME_ME_SIGNAL local csr 
//                          to wakeup next thread in phase 3
//		out_tx_seq_adr:		address to read how may tbufs transmitted out of 
//							the port handled by this thread
//		out_turnaroud		when queue tail or head equal to this value, next
//							entry will be what in 
//							*l$index1[GLOBAL_QUEUE_INFO_BASE_INDEX]  for this 
//                          specfic port
//
// Inputs:  
//		in_sring_for_thread	scracth ring to get tx request for thread
//		in_next_thread:		next thread number of this thread 
//		in_port:			port handled by this thread	
//
// Constants:
//		none
//
///////////////////////////////////////////////////////////////////////////////
#macro _sphy_mphy4_tx_thread_specific_init[out_scratch_ring, out_next_ctx_sig1, \
				out_next_ctx_sig2, out_next_ctx_sig3, out_tx_seq, \
				out_turnaroud, in_sring_for_thread, in_next_thread, in_port]

 	// scratch ring which QM put tx requests for this thread
    // scratch instruction requires context relative GPR
	alu_shf[out_scratch_ring, --, b,  in_sring_for_thread, <<2]
  
.begin 
.reg next_context
	// value to write to SAME_ME_SIGNAL csr to wake up next thread
	// will differs for each thread
	move(next_context,in_next_thread)
	alu_shf[out_next_ctx_sig1, next_context, or, &sig1_next_context, <<3]
	alu_shf[out_next_ctx_sig2, next_context, or, &sig2_next_context, <<3]
	alu_shf[out_next_ctx_sig3, next_context, or, &sig3_next_context, <<3]
.end  // end for local variable next_context
	
.begin 
.reg  port_offset setting pport
	move(pport, in_port)
	alu_shf[port_offset, 0, OR, pport, <<TX_SEQUENCE_ADDR_SHF]
	move(setting, TX_SEQUENCE_0)
	alu[setting, setting, +, port_offset]
 	alu[out_tx_seq, --, B, setting]	; MSF Tx_Sequence_port address
.end // end of .reg  port_offset setting pport

.begin
	.reg tmpx pport
	alu[pport, --, B, in_port]
	alu[pport, pport, +, 1]
 	move(tmpx, TOTAOL_QUEUE_ENTRY_SIZE_PER_PORT)
 	multiply(out_turnaroud, pport, tmpx)
	alu[out_turnaroud, out_turnaroud, -, QUEUE_ENTRY_SIZE]
 	move(tmpx, QUEUE_ENTRY_BASE)
	alu[out_turnaroud, out_turnaroud, +, tmpx]

.end	// tmpx pport

#endm //end of macro _sphy_mphy4_tx_thread_specific_init()


///////////////////////////////////////////////////////////////////////////////////// 
// 	_sphy_mphy4_tx_msf_tx_control_init()
//
// Description:
// 	
//		Initialize the msf
//
// Outputs: 
//		none
//
// Inputs:  
//		none
//		
// Constants
//		nonee
//
//
/////////////////////////////////////////////////////////////////////////////////////

#macro 	_sphy_mphy4_tx_msf_tx_control_init()

#if ( (THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX) || (THIS_ME == PACKET_TX_FIRST_ME) )
.begin 
	.reg 	temp_reg address $data

	/* set the configuration before enabling tx */
	;move(temp_reg,0x4)	***TKH***
	move(temp_reg, (PACKET_TX_MPHY4_CTL_LW & 0x0FFFFFFF))
	alu[$data,	--, B, temp_reg]
	alu[address,	--, B, MSF_TX_CNTL]
	msf[write, $data, address, 0, 1], ctx_swap[sig_msf_access_1]

#if(TX_PHY_MODE == SPHY_1_32)
	move(temp_reg, PACKET_TX_SPHY_1X32_CTL_LW)
#endif //#if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
	move(temp_reg, PACKET_TX_SPHY_4X8_CTL_LW)
#endif //#if(TX_PHY_MODE == SPHY_4_8)

#if(TX_PHY_MODE == MPHY_4)
	move(temp_reg, PACKET_TX_MPHY4_CTL_LW)
#endif //#if(TX_PHY_MODE == MPHY_4)


	alu[$data,	--, B, temp_reg]
	alu[address,	--, B, MSF_TX_CNTL]

	msf[write, $data, address, 0, 1], ctx_swap[sig_msf_access_1]
.end //temp_reg, address, $data

	// Initialization of Tx_UP_Control_0, Tx_UP_Control_1, Tx_UP_Control_2,
	// Tx_UP_Control_3 to POS
	_sphy_mphy4_tx_set_16bit_msf_reg(TX_UP_CTRL_0, POS_TX_UP_CTL_WD)
#if( (TX_PHY_MODE == SPHY_4_8) || (TX_PHY_MODE == MPHY_4) )
	// Initialization of Tx_UP_Control_1, Tx_UP_Control_2, 
	// Tx_UP_Control_3 to POS
	_sphy_mphy4_tx_set_16bit_msf_reg(TX_UP_CTRL_1, POS_TX_UP_CTL_WD)
	_sphy_mphy4_tx_set_16bit_msf_reg(TX_UP_CTRL_2, POS_TX_UP_CTL_WD)
	_sphy_mphy4_tx_set_16bit_msf_reg[TX_UP_CTRL_3, POS_TX_UP_CTL_WD)
#endif //#if( (TX_PHY_MODE == SPHY_4_8) || (TX_PHY_MODE == MPHY_4) )
#endif // ( (THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX) || 
	   //								(THIS_ME == PACKET_TX_FIRST_ME) )

#endm	// end of macro _sphy_mphy4_tx_msf_tx_control_init()


///////////////////////////////////////////////////////////////////////////////
// _sphy_mphy4_tx_init_port_globals_in_local_mem()
//
// Description:
// 	
//		Initialize the the globals in local memoryfor specific port
//
// Outputs: 
//		none
//
// Inputs:  
// 		in_port:			port ID to initialize it's globals in local memory 
//
//		
// Constants
//		none
//
/////////////////////////////////////////////////////////////////////////////////////

#macro _sphy_mphy4_tx_init_port_globals_in_local_mem(in_port)

.begin

	.reg		i setting tmp_shft port_offset lm_base pport

	// initialize local memory index 0 to the base for global info for this port
	move(pport, in_port)
	alu_shf[port_offset, 0, OR, pport, <<PORT_GLOBAL_OFFSET_SHF]

	move(lm_base, PORT_GLOBAL_INFO_BASE)
	alu[lm_base, lm_base, +, port_offset]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_base, LM_HANDLE_0]

	nop
	nop
	nop
 
 	alu[*l$index0++, --, B, in_port]	; port ID

	alu_shf[port_offset, 0, OR, pport, <<TCW_VD_BASE_SHF]
	move(setting, TBUF_ELEMENT_CTRL_VALID)
	alu[setting, setting, +, port_offset]
 	alu[*l$index0++, --, B, setting]	; TBUF_ELEMENT_CTRL_V# address base

	move(tmp_shft, TBUF_BASE_SHF)
	multiply(port_offset, in_port, tmp_shft)
	move(setting, RBUF_TBUF_BASE)
	alu[setting, setting, +, port_offset]
 	alu[*l$index0++, --, B, setting]	; tbuf address base

	move(tmp_shft, TOTAOL_QUEUE_ENTRY_SIZE_PER_PORT)
	multiply(setting, in_port, tmp_shft)
	move[i, QUEUE_ENTRY_BASE]
	alu[setting, setting, +, i]
 	alu[*l$index0++, --, B, setting]	; queue entry base for the port

 	alu[*l$index0++, --, B, setting]	; queue head
	
	alu[*l$index0++, --, B, setting]	; queue tail

	move(setting, 1)
	alu[*l$index0++, --, B, setting]	; not_lock_sndb_rd_flag

	alu[*l$index0++, --, B, setting]	; not_lock_leftover_flag

	// initialize to 0 starting from the eighth longword to end  of this port
	move(i, 8)
	.while (i < 32)	
 		alu[*l$index0++, --, B, 0]

		alu[i, i, +, 1]

	.endw

.end	// i, tmp_shft, port_offset, setting, lm_base

#endm // end of macro _sphy_mphy4_tx_init_port_globals_in_local_mem()


/////////////////////////////////////////////////////////////////////////////////////
// 
// _sphy_mphy4_tx_init_local_memory()
//
// Description:
// 	
//		Initialize the local memory including queue info and globals for port
//
// Outputs: 
//		none
//
// Inputs:
//		IN_TX_PHY_MODE:	Operation mode of PHY, either SPHY_1_32, or 
//                      SPHY_4_8, or MPHY_4
//		
// Constants
// 		none  
//
// Size: 
//
//		14 instructions
// 
//
/////////////////////////////////////////////////////////////////////////////////////

#macro _sphy_mphy4_tx_init_local_memory(IN_TX_PHY_MODE)
.begin

	.reg 		i j lm_txc_base

	// initialize local memory index 0 to the base for transmit contexts

	immed32[lm_txc_base, PORT_QUEUE_INFO_BASE]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_txc_base, LM_HANDLE_0]

	nop
	nop
	nop

	move(i,0)

	// Initialize queue info in local memory
#if(IN_TX_PHY_MODE == SPHY_1_32)
	.while (i < 128)	
		alu[*l$index0++, --, B, 0]
		alu[i, i, +, 1]
	.endw
#else // (IN_TX_PHY_MODE == SPHY_4_8) or (IN_TX_PHY_MODE == MPHY_4)
	.while (i < 512)	
		alu[*l$index0++, --, B, 0]
		alu[i, i, +, 1]
	.endw
#endif 

	// initialize globals in local memory
	_sphy_mphy4_tx_init_port_globals_in_local_mem[PORT_0]
#if(IN_TX_PHY_MODE != SPHY_1_32)
	_sphy_mphy4_tx_init_port_globals_in_local_mem[PORT_1]
	_sphy_mphy4_tx_init_port_globals_in_local_mem[PORT_2]
	_sphy_mphy4_tx_init_port_globals_in_local_mem[PORT_3]
#endif 

.end

#endm // end of macro _sphy_mphy4_tx_init_local_memory()


/////////////////////////////////////////////////////////////////////////////////////
// 
// _sphy_mphy4_tx_set_local_memory_index_one()
//
// Description:
//		Initialize the local memory index one for globals for specfic port
//
// Outputs: 
//		none
//
// Inputs:  
// 		in_port:				port ID  
//
//		
// Constants
//		none
//
/////////////////////////////////////////////////////////////////////////////////////

#macro _sphy_mphy4_tx_set_local_memory_index_one(in_port)

.begin
	.reg        port_offset lm_base pport

	move(pport, in_port)
	// initialize local memory index 0 to the base for global info for this port
	alu_shf[port_offset, 0, OR, pport, <<PORT_GLOBAL_OFFSET_SHF]
	move(lm_base, PORT_GLOBAL_INFO_BASE)
	alu[lm_base, lm_base, +, port_offset]

	// 3 cycles for this to take effect

	localmem_set_address[0, lm_base, LM_HANDLE_1]
	nop
	nop
	nop
  
.end	// port_offset, lm_base

#endm // end of macro _sphy_mphy4_tx_set_local_memory_index_one[]


/////////////////////////////////////////////////////////////////////////////////////
// 
// sphy_mphy4_tx_init()
//
// Description:
// 	
//		Initialization of the microblock
//
// Outputs: 
//		out_entry_turnaround	the queue head/tail offset where next queue head/tail
//								should be reset to queue offset base of the specific
//								 port
// Inputs:  
//		IN_TX_PHY_MODE:	Operation mode of PHY, either SPHY_1_32, or 
//                      SPHY_4_8, or MPHY_4
//		
// Constants
//		none
//
/////////////////////////////////////////////////////////////////////////////////////

#macro sphy_mphy4_tx_init(out_entry_turnaround, IN_TX_PHY_MODE)

//--------------------------------------------------------------
	br=ctx[0, ctx0_init#]
    br=ctx[1, ctx1_init#]
    br=ctx[2, ctx2_init#]
    br=ctx[3, ctx3_init#]
    br=ctx[4, ctx4_init#]
    br=ctx[5, ctx5_init#]
    br=ctx[6, ctx6_init#]
    br=ctx[7, ctx7_init#]

// general ME and global GPRs initializtion and thread 0 context relative
// variables initialization
ctx0_init#:

#ifdef UNIT_TEST
	move(@buf_freed, 0)
#endif // UNIT_TEST

#ifdef CHECK_DISCARD
	move(@pkts_discarded, 0)
#endif	//CHECK_DISCARD

#ifdef COUNTERS
	immed32(@cntr_base, PACKET_TX_COUNTER_BASE)	; initialized to POS_TCX_COUNTER_BASE	
#endif // #ifdef COUNTERS

#ifdef	_DEBUG_COUNTERS_
	immed[@pkt_tx_num_tx_requests_rxed, 0]	;reset
	immed[@pkt_tx_num_pkts_notified, 0]		;reset
	immed[@pkt_tx_num_tbufs_txed,0]
#endif // _DEBUG_COUNTERS_

   // Initialize MSF_TX_CNTL register
	_sphy_mphy4_tx_msf_tx_control_init()

   	// initialize the local memory 
	_sphy_mphy4_tx_init_local_memory(IN_TX_PHY_MODE)

	// following inter-ME signal common_init_complete_sig_num is generated by 
	// the ME whcih initializes common resources, such as scratch ring, this
	// ME will wait for this signal to make sure all common resource are 
	// available


    // For kick start thread 0 will send itself 3 initial signals for 
	// phase 1, 2, and 3 

.begin //begin of local variable sig
.reg sig
    alu[sig, --, B,  &sig1_next_context]
    alu_shf[sig, 0x0, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

 	alu[sig, --, B,  &sig2_next_context]
    alu_shf[sig, 0x0, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0

	alu[sig, --, B,  &sig3_next_context]
    alu_shf[sig, 0x0, OR, sig, <<3]         ; value to signal thread 0
    local_csr_wr[SAME_ME_SIGNAL, sig]   	; signal thread 0
.end // end of .begin //begin of local variable sig

	
	// thread 0 context relative GPR variables initialization
	_sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_0, 1, \
			PORT_HANDLED_BY_THREAD_0)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_0)

#ifdef UNIT_TEST
	alu[@buf_freed, --, B, 0]	; initialize @buf_freed for debugging
#endif //UNIT_TEST


#ifdef WAIT_FOR_COMMON_RESOURCE_INITIALIZATION 
	ctx_arb[common_init_complete_sig_num]
#endif //#ifdef WAIT_FOR_COMMON_RESOURCE_INITIALIZATION
	br[tx_init_done#]

	
ctx1_init#:
	// thread 1 context relative GPR variables initialization
   _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_1, 2, \
			PORT_HANDLED_BY_THREAD_1)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_1)
	br[tx_init_done#]

ctx2_init#:
	// thread 2 context relative GPR variables initialization
   _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_2, 3, \
			PORT_HANDLED_BY_THREAD_2)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_2)
	br[tx_init_done#]

	// thread 3 context relative GPR variables initialization
ctx3_init#:
   _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_3, 4, \
			PORT_HANDLED_BY_THREAD_3)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_3)
	br[tx_init_done#]

	// thread 4 context relative GPR variables initialization
ctx4_init#:
   _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_4, 5, \
			PORT_HANDLED_BY_THREAD_4)
			_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_4)
	br[tx_init_done#]

	// thread 5 context relative GPR variables initialization
ctx5_init#:
    _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_5, 6, \
			PORT_HANDLED_BY_THREAD_5)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_5)
	br[tx_init_done#]


	// thread 6 context relative GPR variables initialization
ctx6_init#:
    _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_6, 7, \
			PORT_HANDLED_BY_THREAD_6)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_6)
	br[tx_init_done#]


	// thread 7 context relative GPR variables initialization
ctx7_init#:
    _sphy_mphy4_tx_thread_specific_init(sring_tr, sig1_next_context_gpr, \
			sig2_next_context_gpr, sig3_next_context_gpr, addr_tx_seq, \
			out_entry_turnaround, SCRATCH_RING_THREAD_7, 0, \
			PORT_HANDLED_BY_THREAD_7)
	_sphy_mphy4_tx_set_local_memory_index_one(PORT_HANDLED_BY_THREAD_7)


tx_init_done#:

#endm  // sphy_mphy4_tx_init()

/////////////////////////////////////////////////////////////////////////////////////
#endif 		//  __SPHY_MPHY4_TX_INIT_UC__
/////////////////////////////////////////////////////////////////////////////////////
