////////////////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: sphy_mphy4_tx.h
//
//      Purpose: Header file for Packet (POS/Ethernet) TX 
//
/////////////////////////////////////////////////////////////////////////////////////////


#ifndef	__SPHY_MPHY4_TX_H__
#define	__SPHY_MPHY4_TX_H__

#ifdef USE_IMPORT_VAR
 
  .import_var PACKET_TX_COUNTER_BASE

#else

  /* defined dl_system.h */
#endif

#define ONLY_ONE_ME_FOR_PACKET_TX	0
#define PACKET_TX_FIRST_ME			1
#define PACKET_TX_SECOND_ME			2

// following #ifndef is for backward compatability
#ifndef THIS_ME
#define_eval THIS_ME	ONLY_ONE_ME_FOR_PACKET_TX
#endif // #ifndef THIS_ME

#define TOTAL_TBUF_SIZE 		8192
#define TOTOL_THREADS_PER_ME		8

#define TBUF_ELE_SIZE		128 
#define TBUF_ADDR_SHF		7

#define_eval TBUF_ELE_SIZE_MINUS_8	(TBUF_ELE_SIZE - 8)

#define_eval TBUF_ELE_SIZE_MINUS_16	(TBUF_ELE_SIZE - 16)

#define_eval TWO_TBUF_ELE_SIZE_MINUS_16 ((TBUF_ELE_SIZE * 2) - 16)
// definition of the threshold to wait to avoid overwriting existing mpackets
// not transmitted out of tbuf yet
// theoretically, the max TBUF_WAIT_THRESHOLD = (tbuf elements for that tbuf
//     segment for the port) - (2 * number_of_threads_handling_that_port)

#if(TX_PHY_MODE == SPHY_1_32)
#define TBUF_WAIT_THRESHOLD        32
#define_eval TBUF_ELE_NUM_PER_SEGMENT	(TOTAL_TBUF_SIZE / TBUF_ELE_SIZE)
#endif // #if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
#define TBUF_WAIT_THRESHOLD        8
#define_eval TBUF_ELE_NUM_PER_SEGMENT	(TOTAL_TBUF_SIZE / (TBUF_ELE_SIZE * 4))
#endif //#if(TX_PHY_MODE == SPHY_4_8)

#if(TX_PHY_MODE == MPHY_4)
#define TBUF_WAIT_THRESHOLD        8
#define_eval TBUF_ELE_NUM_PER_SEGMENT	(TOTAL_TBUF_SIZE / (TBUF_ELE_SIZE * 4))
#endif //#if(TX_PHY_MODE == MPHY_4)

#if(TX_PHY_MODE == SPHY_1_32)
// definition of device bus width
#define BUS_WIDTH_IN_BYTES		4
#endif // #if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == MPHY_4)
// definition of device bus width
#define BUS_WIDTH_IN_BYTES		4
#endif // #if(TX_PHY_MODE == MPHY_4)


#ifndef ADD_L2_HEADER
// sop meta data to read in longword
#define META_DATA_LW_TO_READ		3
#endif // #ifndef ADD_L2_HEADER
 

// POS_TX_UP_CTL_WD
#ifndef ODD_PARITY
#define POS_TX_UP_CTL_WD		0x001D	; packet, single bit even parity, 2 clock cycle
#else // ODD_PARITY
#define POS_TX_UP_CTL_WD		0x0019	; packet, single bit odd parity, 2 clock cycle
#endif  // ODD_PARITY

// ports controlled by first POS TX ME (port 0 to 7)
#define			PORTS_CTRLED_BY_FIRST_POS_TX_ME		0x00FF

// ports controlled by second POS TX ME (port 8 to 15)
#define			PORTS_CTRLED_BY_SECOND_POS_TX_ME	0xFF00

// definition of the mask to get the next available tbuf element from what
// gotten from scratch memory by atomic operation
#if(TX_PHY_MODE == SPHY_1_32)
#define_eval TBUF_ELE_BITS_MASK ( (TOTAL_TBUF_SIZE / TBUF_ELE_SIZE) - 1)
#endif //#if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
#define_eval TBUF_ELE_BITS_MASK ( ((TOTAL_TBUF_SIZE / 4) / TBUF_ELE_SIZE) - 1)
#endif //#if(TX_PHY_MODE == SPHY_4_8)

#if(TX_PHY_MODE == MPHY_4)
#define_eval TBUF_ELE_BITS_MASK ( ((TOTAL_TBUF_SIZE / 4) / TBUF_ELE_SIZE) - 1)
#endif //#if(TX_PHY_MODE == MPHY_4)

//	Scratch for communicating between Queue Manager and POS Transmit Blocks
// bits definition in the gloabl execution status flag exe_stat_flag
// definition of the bit location for reading secondary buffer meta data in 
// phase 1, and need to be saved in phase 2 flag in exe_stat_flag GPR
#define READ_SND_BD_FLAG_BIT			0	

// definition of the bit location for some bytes leftover from previous buffer
// flag in exe_stat_flag GPR
#define LEFTOV_FROM_PB_FLAG_BIT			1	 

// definition of the bit location for some bytes leftover from previous buffer
// flag in exe_stat_flag GPR
#define SAVE_LEFTOV_TO_LM_FLAG_BIT		2	 

// definition of the bit location for reading enqueueing sop meta data in 
// phase 2, and need to be saved in phase 3 flag in exe_stat_flag GPR
#define READ_SOP_BD_FLAG_BIT			3


// definition of the bit location to identify taht the tbuf will not be
// transmitted  due to its paylo size less than 4 in exe_stat_flag GPR
#define SKIP_TRANSMIT_FLAG_BIT			4

// definition of the bit location to identify this is an EOB mpacket in 
// exe_stat_flag GPR, so this buffer needs to be freed in phase 3
#define EOB_MPKT_FLAG_BIT				5

// definition of the bit location to identify that there is no scratch queue
// read to get tx request due to queue full
#define GET_TX_REQUEST_FLAG_BIT			6

#ifdef ADD_L2_HEADER

// definition of the bit location to identify that L2 header need to be added
// in prepend
#define NEED_PREPEND_L2_HEADER_FLAG_BIT	7

#endif // #ifdef ADD_L2_HEADER

// constants definition for queue data structure at local memory
// queue status info starting at 0x800 in local memory
#define QUEUE_INFO_BASE		0x800
 
#define QUEUE_ENTRY_BASE	0

// each port occpies 8 longword
// #define QUEUE_INFO_ENRY_SHFT	5
// each port occpies 16 longword
#define QUEUE_INFO_ENRY_SHFT	6

#define PKTS_IN_QUEUE_SHFT		16

// queue entres for each port occupies 64 lonwords 
#define QUEUE_ENRY_SHFT		8	

#define TAIL_MASK	0xFF
#define TAIL_SHFT	8

#define HEAD_MASK 	0xFF

#define PORT_MASK_IN_TXR	0x0F

// each entry occupies 4 longwords
#define QUEUE_ENTRY_SIZE	0x20		

#define_eval QUEUE_DEPTH	(0x200 / QUEUE_ENTRY_SIZE)
  
#define_eval QUEUE_DEPTH_MINUS_ONE	(QUEUE_DEPTH - 1)

#define_eval HEAD_INCR (QUEUE_ENTRY_SIZE)
#define_eval MAX_PLUS_ONE_QUEUE_OFFSET	(QUEUE_ENTRY_SIZE * QUEUE_DEPTH)

#define_eval MAX_MINUS_ONE_QUEUE_OFFSET	(QUEUE_ENTRY_SIZE * QUEUE_DEPTH_MINUS_ONE)

#define CONST_FF		0xFF

#define CONST_F8		0xF8

#define CONST_0F		0x0F

#define CONST_07		0x07	

#define CONST_04		0x04	



// amount to add to increase pkts_in_queue by one in queue status info
#define INCR_PKTS_IN_QUEUE	0x10000

// amount to add to increase tail_offet to next entry in queue status info
#define_eval INCR_TAILOFFSET		(QUEUE_ENTRY_SIZE <<8)

// bit location for sop flag in queue entry longword 0
#define SOP_BIT_LOC			31

// bit location read next BD flag in queue entry longword 0
#define RD_NBD_BIT_LOC		30

// mask for pkt_in_queue in queue info
#define QPKT_MASK	0x0F
// the least significant bit location of pkt_in_queue in queue info
#define QPKT_SHFT	16



// mask for freelist field
#define FREE_LIST_MASK		0xF

// the least significant bit location of freelist in meta data
#define FLIST_META_LOC		12

// definition of EOP bit in Transmit control word for POS-PHY
#define TCW0_EOP_BIT_SHFT		8

// definition of SKIP bit in Transmit control word for POS-PHY
#define TCW0_SKIP_BIT_SHFT		11

// definition of mask to get freelist id from meta data
#define FREELIST_MASK		0x000F

// definition of the base bits pattern of indir_ref used in instruction which 
// moves packet data from dram to tbuf
#define DRAM_INDIREF_BASE_LW	0x02000010	; overrid bit of Ref_Cnt field (bit
											; 25) override bit of RBUF/TBUF 
											; Byte addr field (bit 4) and must 
											; always be set


// definition of mask to get dl_buf_handle 
#define MASK_FOR_DL_BH_LW	0x03FFFFFF	
#define TRUE_DL_HDL_SHIFT	2

// definition of mask to put freelist in bit 27 to bit 24 from TXC *l$index0[3]
#define MASK_FOR_FREELIST_LW	0x0F000000
	
// since CSIX TX microblock doesn't need to refer to next neighbor, following 
// definition is dummy, just to eliminate a warning from dispatch_loop.h
#define DL_NEXT_ME	0

// definition of the default PHY TXFIFO depth
// assume PHY has 2K bytes TXFIFO and we set the threshhold to 2 times 
// TBUF_ELE_SIZE
#define DEFAULT_PHY_DEPTH	((2048 / TBUF_ELE_SIZE) - 1)

// definition of the offset of different elements in the queue entry in local
// memory
// definition of the offset of the first element about active buffer  
#define ABD_0_OFFSET		0
// definition of the offset of the second element about active buffer  		
#define ABD_1_OFFSET		1
// definition of the offset of the first element about secondary buffer 
#define SBD_0_OFFSET		2		
// definition of the offset of the first element about secondary buffer
#define SBD_1_OFFSET		3
// definition of the offset of the nexthop_id of the packet
#define NEXTHOPID_OFFSET	4

// definition of the least significant bit of the remained payload in queue 
// entry
#define PAYLO_RMND_LOC		16

#if(TX_PHY_MODE == SPHY_1_32)
#define ME_THREAD_NUM_SHFT	3
#endif //#if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
#define ME_THREAD_NUM_SHFT	1
#endif  //#if(TX_PHY_MODE == SPHY_4_8) 

#if(TX_PHY_MODE == MPHY_4)
#define ME_THREAD_NUM_SHFT	1
#endif  //#if(TX_PHY_MODE == MPHY_4) 

#define PKTS_IN_Q_MASK	0xFF

/////////////////////////////////////////////////////////////////////////////
// Follow definitions are used for global counters
// There are total 16 ports.  Each port has a counter
// data.  The counter data structure contains 3 long words
//	PKT_TRANSMITTED_CNT
//	PKT_DROPPED_CNT
//	BYTE_TRANSMITTED_CNT
//	RESERVED_CNT
//  The index of the counter data is defiend by POS_TX_COUNTER_BASE+PORT_OFFSET
//	PORT_OFFSET	= port number << 4 
//	Following are the counter index definitions

#ifdef COUNTERS
#define		PKT_TRANSMITTED_CNT_IDX		0x00
#define		PKT_DROPPED_CNT_IDX			0x04
#define		BYTE_TRANSMITTED_CNT_IDX	0x08
#define 	BYTES_DROPPED_CNT_IDX		0x0C
#define     PORT_MASK_IN_TCW            0x0F
#endif

// definition of least significant bit location of fields of Transmit Control Word
// definition of least significant bit location of payload length field
#define	TCW0_PAYLOAD_LEN_LSB_LOC	24
// definition of least significant bit location of payload offset field
#define TCW0_PAYLOAD_OFFSET_LSB_LOC	13
// definition of least significant bit location of prepend length field 
#define TCWO_PREPEND_LEN_LSB_LOC		16
// definition of least significant bit location of prepend offest field  		
#define TCWO_PREPEND_OFFSET_LSB_LOC		21

// definition of the mask to get payload offset (3 bits)
#define TCW0_PAYLOAD_OFFSET_MASK		0x07

// debug
#ifdef DEBUG_TX_PENDING_LOCKED
#define SRAM_WRITE_1_SIG	11
#define FIRST_ME_TBUF_NO_SRAM_BASE		0x100000
#define SECOND_ME_TBUF_NO_SRAM_BASE		0x200000
#endif //#ifdef DEBUG_TX_PENDING_LOCKED


// base for global info for port 0, each port has 32 longwords
#define PORT_GLOBAL_INFO_BASE	2048

// each port has 32 longwords in local memory for globals
#define PORT_GLOBAL_OFFSET_SHF		7

// for 4 ports case with 128 tbuf element size, tbuf divided into 4 equal
// segements, each segment owns 16 tbuf elements, so each segment owns 
// 128 bytes (8x16) transmit control valid word address space
#define TCW_VD_BASE_SHF		7

// for 4 ports case with 128 tbuf element size, tbuf divided into 4 equal
// segements, each segment owns 16 tbuf elements, so each segment owns 
// 2048 bytes (128x16) tbuf address space
#define TBUF_BASE_SHF		2048

// MSF_Tx_Sequence_{0, 1,2,3} address is 060, 0x64, 0x68, 0x6c
#define TX_SEQUENCE_ADDR_SHF	2
// setting for MSF_Tx_Control for SPHY_1X32 mode
#ifdef IXP2800
#define PACKETP_TX_SPHY_1X32_CTL_LW	0x20000454	//??
#define ELE_2_TX_CNTRL_ADDR	4				//??
#else // #ifdef IXP2800
#define PACKET_TX_SPHY_1X32_CTL_LW	0x10000004	;0001 0000 0000 0000 Tx enable, UTOPIA/POS, SPHY_1x32, Simplex
										;0000 0000 0000 0100 128 bytes tbuf size
#endif // #ifdef IXP2800

// setting for MSF_Tx_Control for SPHY_4x8 mode
#ifdef IXP2800
#define PACKET_TX_SPHY_4X8_CTL_LW	0x20000454	//??
#define ELE_2_TX_CNTRL_ADDR	4				//??
#else // #ifdef IXP2800
#define PACKET_TX_SPHY_4X8_CTL_LW	0xFF200004	;0001 0000 0000 0000 Tx enable, UTOPIA/POS, SPHY_4x8, Simplex
											;0000 0000 0000 0100 128 bytes tbuf size
#endif // #ifdef IXP2800

// setting for MSF_Tx_Control for MPHY4 mode
#ifdef IXP2800
#define PACKET_TX_MPHY4_CTL_LW	0x20000454	//??
#define ELE_2_TX_CNTRL_ADDR	4				//??
#else // #ifdef IXP2800
//#define PACKET_TX_MPHY4_CTL_LW	0xFF080004	;0001 0000 0000 0000 Tx enable, UTOPIA/POS, MPHY4, Simplex
//												;0000 0000 0000 0100 128 bytes tbuf size
//	TKH fixed for b0 stepping
#define PACKET_TX_MPHY4_CTL_LW	0xFF080004
#endif // #ifdef IXP2800


/////////////////////////////////////////////////////////////////////////////////////
// 
// Globals stored in local memory 
//
/////////////////////////////////////////////////////////////////////////////////////

//	We will use local memory to store a few globals. These globals will be accessed 
//  *l$index1[], and local memory index 1 is initialized to right value during 
//  initialization based on the operation mode (SPHY(SPHY_1X32), SPHY4(SPHY_4X8), or 
//  MPHY4 (MPHY_4))
#define GLOBAL_PORT_ID_INDEX				0	; port number for the specific port
#define GLOBAL_CTW_VD_BASE_INDEX			1	; base to compute 
												; TBUF_ELEMENT_CTRL_V# address
												; for the specific port
#define GLOBAL_TBUF_BASE_INDEX				2	; base to compute tbuf address
												; for the specific port
#define GLOBAL_QUEUE_INFO_BASE_INDEX		3	; starting address of queue info 
												; for the specfic port
#define GLOBAL_HEAD_OFFSET_INDEX			4	; queue head for the specific port
												; (bytes offset within queue info)
#define GLOBAL_TAIL_OFFSET_INDEX			5	; queue tail for the specific port
												; (bytes offset within queue info)

#define	GLOBAL_NOT_LOCK_SNDB_RD_FLAG_INDEX	6	; if bit 0 set mans this specific port is 
 												; not prohibited to transmit due to
												; secondary buffer info not ready
#define	GLOBAL_NOT_LOCK_LEFTOVER_FLAG_INDEX	7	; if bit 0 set mans this specific port is 
 												; not prohibited to transmit due to
												; leftover bytes not ready in local memory#d


#define	GLOBAL_AVAIL_TBUF_ELEMENT_INDEX		8	; next available TBUF element for 
												; the specific port
#define GLOBAL_PKTS_IN_QUEUE_INDEX			9	; packets in queue for the specific
												; port
#define GLOBAL_PKTS_TXED_INDEX				10	; packets transmitted for this 
												; specific port
												; (bytes offset within queue info)
#define	GLOBAL_LEFTOVER_FLAG_INDEX			11	; if set to 1, means that there are
												; some leftover bytes from previous
												; buffer to be transmitted in the 
												; beginning of this mpkt for the 
												; specific port 	
#define	GLOBAL_LEFTOVER_LEN_INDEX			12	; leftover length in bytes for the 
												; specific port																							; not prohibited to transmit due to
#define	GLOBAL_LEFTOVER_DATA_INDEX			13	; leftover bytes (max. 4 bytes) to next  
												; mpkt for the specific port 												; not prohibited to transmit due to
#define	GLOBAL_SBD_NEXT_BD_INDEX			14	; next buffer descriptor for secondary 
												; buffer for the specific port
// base for queue info for port 0, each port has 64 longwords
#define PORT_QUEUE_INFO_BASE	0		; starting address in local memory for queue info

#define PORT_0 	0
#define PORT_1	1
#define PORT_2 	2
#define PORT_3	3

#if THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX

#if(TX_PHY_MODE == SPHY_1_32)
#define	SCRATCH_RING_THREAD_0		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_1		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_2		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_3		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_4		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_5		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_6		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_7		PACKET_TX_IN_0
#define PORT_HANDLED_BY_THREAD_0	PORT_0
#define PORT_HANDLED_BY_THREAD_1	PORT_0
#define PORT_HANDLED_BY_THREAD_2	PORT_0
#define PORT_HANDLED_BY_THREAD_3	PORT_0
#define PORT_HANDLED_BY_THREAD_4	PORT_0
#define PORT_HANDLED_BY_THREAD_5	PORT_0
#define PORT_HANDLED_BY_THREAD_6	PORT_0
#define PORT_HANDLED_BY_THREAD_7	PORT_0
#endif //#if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
#define	SCRATCH_RING_THREAD_0		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_1		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_2		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_3		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_4		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_5		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_6		PACKET_TX_IN_3
#define	SCRATCH_RING_THREAD_7		PACKET_TX_IN_3
#define PORT_HANDLED_BY_THREAD_0	PORT_0
#define PORT_HANDLED_BY_THREAD_1	PORT_0
#define PORT_HANDLED_BY_THREAD_2	PORT_1
#define PORT_HANDLED_BY_THREAD_3	PORT_1
#define PORT_HANDLED_BY_THREAD_4	PORT_2
#define PORT_HANDLED_BY_THREAD_5	PORT_2
#define PORT_HANDLED_BY_THREAD_6	PORT_3
#define PORT_HANDLED_BY_THREAD_7	PORT_3
#endif //#if(TX_PHY_MODE == SPHY_4_8)

#if(TX_PHY_MODE == MPHY_4)
#define	SCRATCH_RING_THREAD_0		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_1		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_2		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_3		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_4		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_5		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_6		PACKET_TX_IN_3
#define	SCRATCH_RING_THREAD_7		PACKET_TX_IN_3
#define PORT_HANDLED_BY_THREAD_0	PORT_0
#define PORT_HANDLED_BY_THREAD_1	PORT_0
#define PORT_HANDLED_BY_THREAD_2	PORT_1
#define PORT_HANDLED_BY_THREAD_3	PORT_1
#define PORT_HANDLED_BY_THREAD_4	PORT_2
#define PORT_HANDLED_BY_THREAD_5	PORT_2
#define PORT_HANDLED_BY_THREAD_6	PORT_3
#define PORT_HANDLED_BY_THREAD_7	PORT_3
#endif //#if(TX_PHY_MODE == MPHY_4)

#endif  //#if THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX


#if THIS_ME == PACKET_TX_FIRST_ME

#if(TX_PHY_MODE == SPHY_1_32)
#define	SCRATCH_RING_THREAD_0		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_1		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_2		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_3		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_4		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_5		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_6		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_7		PACKET_TX_IN_0
#define PORT_HANDLED_BY_THREAD_0	PORT_0
#define PORT_HANDLED_BY_THREAD_1	PORT_0
#define PORT_HANDLED_BY_THREAD_2	PORT_0
#define PORT_HANDLED_BY_THREAD_3	PORT_0
#define PORT_HANDLED_BY_THREAD_4	PORT_0
#define PORT_HANDLED_BY_THREAD_5	PORT_0
#define PORT_HANDLED_BY_THREAD_6	PORT_0
#define PORT_HANDLED_BY_THREAD_7	PORT_0

#else // #if(TX_PHY_MODE == SPHY_1_32)

#define	SCRATCH_RING_THREAD_0		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_1		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_2		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_3		PACKET_TX_IN_0
#define	SCRATCH_RING_THREAD_4		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_5		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_6		PACKET_TX_IN_1
#define	SCRATCH_RING_THREAD_7		PACKET_TX_IN_1
#define PORT_HANDLED_BY_THREAD_0	PORT_0
#define PORT_HANDLED_BY_THREAD_1	PORT_0
#define PORT_HANDLED_BY_THREAD_2	PORT_0
#define PORT_HANDLED_BY_THREAD_3	PORT_0
#define PORT_HANDLED_BY_THREAD_4	PORT_1
#define PORT_HANDLED_BY_THREAD_5	PORT_1
#define PORT_HANDLED_BY_THREAD_6	PORT_1
#define PORT_HANDLED_BY_THREAD_7	PORT_1

#endif // #if(TX_PHY_MODE == SPHY_1_32)
#endif //#if THIS_ME == PACKET_TX_FIRST_ME

#if THIS_ME == PACKET_TX_SECOND_ME
#define	SCRATCH_RING_THREAD_0		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_1		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_2		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_3		PACKET_TX_IN_2
#define	SCRATCH_RING_THREAD_4		PACKET_TX_IN_3
#define	SCRATCH_RING_THREAD_5		PACKET_TX_IN_3
#define	SCRATCH_RING_THREAD_6		PACKET_TX_IN_3
#define	SCRATCH_RING_THREAD_7		PACKET_TX_IN_3
#define PORT_HANDLED_BY_THREAD_0	PORT_2
#define PORT_HANDLED_BY_THREAD_1	PORT_2
#define PORT_HANDLED_BY_THREAD_2	PORT_2
#define PORT_HANDLED_BY_THREAD_3	PORT_2
#define PORT_HANDLED_BY_THREAD_4	PORT_3
#define PORT_HANDLED_BY_THREAD_5	PORT_3
#define PORT_HANDLED_BY_THREAD_6	PORT_3
#define PORT_HANDLED_BY_THREAD_7	PORT_3
#endif //#if THIS_ME == PACKET_TX_SECOND_ME


#define TCW0_SOP_EOP_BASE_W0 0x0300	

// payload, prepend infon will be filled out later
#define TCW0_SOP_EOP_BASE_W1 0x0000


#define_eval TOTAOL_QUEUE_ENTRY_SIZE_PER_PORT	(QUEUE_ENTRY_SIZE * QUEUE_DEPTH)

#if(TX_PHY_MODE == SPHY_1_32)
#define DEVICE_BUS_WIDTH_RESTRICTION_MASK	0xFC
#endif //#if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
#define DEVICE_BUS_WIDTH_RESTRICTION_MASK	0xFF
#endif //#if(TX_PHY_MODE == SPHY_4_8)

#if(TX_PHY_MODE == MPHY_4)
#define DEVICE_BUS_WIDTH_RESTRICTION_MASK	0xFC
#endif //#if(TX_PHY_MODE == MPHY_4)


// definition of BASE for TCW0 for sop_only mpacket
//#define_eval TCW0_SOP_ONLY_BASE_LW	(0x00000200 | (PPPH_LEN <<16))
// SOP bit location in TCW0
#define_eval TCW0_SOP_BIT_LOC	9

#define_eval TCW0_EOP_BIT_LOC	8

// no leftover from previous buffer due to device bus width restriction
#define NO_LEFTOVER_FLAG	0

// some bytes leftover from previous buffer due to device bus width restriction
#define PAYLO_LEFTOVER_FLAG		1

// definition of SKIP_GET_TXR_THRESHOLD: when pkts_in_queue reaches this 
// value, skip reading scratch ring to get tx request to prevent overriding
// queue info which is not processed yet
#if(TX_PHY_MODE == SPHY_1_32)
#define_eval SKIP_GET_TXR_THRESHOLD	(QUEUE_DEPTH - 8)
#endif //#if(TX_PHY_MODE == SPHY_1_32)

#if(TX_PHY_MODE == SPHY_4_8)
#if THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX	// 2 threads handling one port in one ME case 
#define_eval SKIP_GET_TXR_THRESHOLD	(QUEUE_DEPTH - 2)
#else /* 4 threads handling one port in two <ME case */
#define_eval SKIP_GET_TXR_THRESHOLD	(QUEUE_DEPTH - 4)
#endif // #if THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX


#endif //#if(TX_PHY_MODE == SPHY_4_8)

#if(TX_PHY_MODE == MPHY_4)
#if THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX	// 2 threads handling one port in one ME case 
#define_eval SKIP_GET_TXR_THRESHOLD	(QUEUE_DEPTH - 2)
#else /* 4 threads handling one port in two <ME case */
#define_eval SKIP_GET_TXR_THRESHOLD	(QUEUE_DEPTH - 4)
#endif // #if THIS_ME == ONLY_ONE_ME_FOR_PACKET_TX
#endif //#if(TX_PHY_MODE == MPHY_4)

#ifdef ADD_L2_HEADER

#define L2_HEADER_ALREADY_EXIST_ID	0xFFFF

#define	L2_HEADER_EXIST_BYTE_FLAG	0xFF
#define L2_HEADER_EXIST_BYTE_LOC	24 

// sop meta data to read in longword
#define META_DATA_LW_TO_READ		5

#ifdef POS_TX
#define PPP_IP_PROTOCOL		0x0021
#define PPP_MPLS_PROTOCOL	0x0281	
#define NEXT_HOP_ID_MPLS	0x2000

// bits to shift to get PPP header for IP
#define IP_PROTOCOL_SHFT	16

// prepend offset = 0, prepend length = 2
#define TCW0_SOP_PREPEND_BYTE	0x02

#define_eval TBUF_ELE_SIZE_MINUS_18 (TBUF_ELE_SIZE - 18)

//TCW0 high word shift
#define TCWO_W1_SHF	16

#define_eval TWO_TBUF_ELE_SIZE_MINUS_26 ((TBUF_ELE_SIZE * 2) - 26)

#define L2_HEADER_SIZE	2		/* actual L2 header size in bytes */

#define BYTES_RESERVED_FOR_L2_HEADER_IN_TBUF	8 	/* in the beginning of each
		 tbuf element, the space in bytes used to keep L2 header due to 
		 multiple of 8 bytes limitation */
#endif // POS_TX

#ifdef ETHERNET_TX

// prepend offset = 1, prepend length = 14
#define TCW0_SOP_PREPEND_BYTE	0x2E

#define_eval TBUF_ELE_SIZE_MINUS_26 (TBUF_ELE_SIZE - 26)

//TCW0 high word shift
#define TCWO_W1_SHF	16

#define_eval TWO_TBUF_ELE_SIZE_MINUS_34 ((TBUF_ELE_SIZE * 2) - 34)

#define L2_TABLE_ENTRY_SHFT			4

#define L2_TABLE_VALID_BIT			31

#define L2_TABLE_ENTRY_SIZE_IN_LW	4

#define L2_HEADER_SIZE	14		/* actual L2 header size in bytes */

#define BYTES_RESERVED_FOR_L2_HEADER_IN_TBUF	16	/* in the beginning of each
		 tbuf element, the space in bytes used to keep L2 header due to 
		 multiple of 8 bytes limitation */
#endif // ETHERNET_TX

#endif // ADD_L2_HEADER

#endif	//	__SPHY_MPHY4_TX_H__
