///////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: packet_rx_init.uc
//
//      Purpose: 
//
//      History:
//
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      06/05/2002      Created                         David Meng
//
//
/////////////////////////////////////////////////////////////////////////////


#include <system_init.uc>


///////////////////////////////////////////////////////////////////////////////
//
// _packet_rx_setup_next_thread_sig
//
//	 	Description: 
//
//			Setup a global register that will be used in next thread signalling.
//
//	 	Outputs:
//			nt_sig_reg		: a register containing
//							  [7]   - next ctx  bit
//							  [6:3] - signal number
//							  [2:0] - thread number
//		Inputs:
//
//			thread_num		: Current thread number
//
//		Size: 
//
//
//
///////////////////////////////////////////////////////////////////////////////

#macro	_packet_rx_setup_next_thread_sig(nt_sig_reg, thread_num)
.begin

#if ( (RX_PHY_MODE != SPHY_4_8) && (RX_PHY_MODE != MPHY_4) )

	//	Initialise next thread signal register.
	//	0->1->2->3->4->5->6->7->0

	move(nt_sig_reg, 0x80)	 					; next context bit [7] for signalling
	alu[nt_sig_reg, nt_sig_reg, OR, \
	             &sig_next_thread, <<3]			; [6:3] signal number

#else 

	//	In Shpy4x8  or Mphy4 Mode, there are 4 ports. So have two threads 
	//  serves each	port. Set up Next thread signalling accordingly.
	// 	i.e threads <0,1>, <2,3>, <4,5>, <6,7> signal each other 

	//	Odd Threads signal the next higher thread, even threads signal one thread 
	//	lower. (another way of looking is just flip the LSbit).

	alu[--, 1, AND, thread_num]					; Check LSbit
	bne[odd_thread#]							; Odd/Even Thread?

	alu[nt_sig_reg, thread_num, +, 1]			; Even: Next thread is one higher
	br[nt_sig_common#]

odd_thread#:
	alu[nt_sig_reg, thread_num, -, 1]			; Odd: Next thread is one lower
	
nt_sig_common#:
	alu[nt_sig_reg, nt_sig_reg, OR, \
	             &sig_next_thread, <<3]			; [6:3] signal number

#endif

.end
#endm



#ifdef FIX_SEQUENCING
///////////////////////////////////////////////////////////////////////////////
//
// _packet_rx_setup_seq_sig 	###tkh###
//
//	 	Description: 
//
//			Setup a global register that will be used in next thread signalling.
//
//	 	Outputs:
//			nt_sig_reg		: a register containing
//							  [7]   - next ctx  bit
//							  [6:3] - signal number
//							  [2:0] - thread number
//		Inputs:
//
//			thread_num		: Current thread number
//
//		Size: 
//
//
//
///////////////////////////////////////////////////////////////////////////////

#macro	_packet_rx_setup_seq_sig(seq_sig_reg, thread_num)
.begin

#if ( (RX_PHY_MODE != SPHY_4_8) && (RX_PHY_MODE != MPHY_4) )

	//	Initialise next thread signal register.
	//	0->1->2->3->4->5->6->7->0

	move(seq_sig_reg, 0x80)	 					; next context bit [7] for signalling
	alu[seq_sig_reg, seq_sig_reg, OR, \
	             &sig_seq, <<3]			; [6:3] signal number

#else 

	//	In Shpy4x8  or Mphy4 Mode, there are 4 ports. So have two threads 
	//  serves each	port. Set up Next thread signalling accordingly.
	// 	i.e threads <0,1>, <2,3>, <4,5>, <6,7> signal each other 

	//	Odd Threads signal the next higher thread, even threads signal one thread 
	//	lower. (another way of looking is just flip the LSbit).

	alu[--, 1, AND, thread_num]					; Check LSbit
	bne[odd_thread#]							; Odd/Even Thread?

	alu[seq_sig_reg, thread_num, +, 1]			; Even: Next thread is one higher
	br[nt_sig_common#]

odd_thread#:
	alu[seq_sig_reg, thread_num, -, 1]			; Odd: Next thread is one lower
	
nt_sig_common#:
	alu[seq_sig_reg, seq_sig_reg, OR, \
	             &sig_seq, <<3]			; [6:3] signal number

#endif

.end
#endm
#endif /*FIX_SEQUENCING*/

///////////////////////////////////////////////////////////////////////////////
//
// packet_rx_init
//
//	 	Description: 
//
//			One time initialisation code for Packet RX. 
//
//	 	Outputs:
//
//			Many global registers are set to predefined values.
//
//		Inputs:
//
//
//		Size: 
//
//			??
//
///////////////////////////////////////////////////////////////////////////////

#macro packet_rx_init()

.begin

	.reg me_num
	.reg temp_nt_sig_reg
	.sig sig_buf_alloc

	#ifdef		MAX_PAYLOAD
	#warning	MAX_PAYLOAD is already defined
	#endif
	#define		MAX_PAYLOAD		(BUFFER_SIZE - PPP_HEADER)

comn_rx_init_start#:

	move(@rand_buf_offset, MAX_BUFFER_OFFSET)	; Starting Random Buffer offset. See [Randomizing Buffer Offset]
	move(@rand_offset_mask, RAND_OFFSET_MASK)	; 0x1ff
	move(max_buf_size, BUFFER_SIZE)				; set max buffer size

	#ifdef _DEBUG_COUNTERS_
	alu[@pkt_rx_num_proper_mpkts_rxed, --, B, 0]	; initialization
	alu[@pkt_rx_num_err_mpkts_rxed, --, B, 0]		; initialization
	alu[@pkt_rx_buf_alloc_fail,--,B,0]
	alu[@pkt_rx_num_pkts,--,B,0]
	alu[@pkt_rx_drop,--,B,0]
	alu[@pkt_rx_drop_scr_ring_full, --, b, 0]			; Clear counter
	alu[@pkt_rx_enqueued, --, b, 0]	;tkh

	#endif // _DEBUG_COUNTERS_

	//	Setup Next thread signalling. 0->1->2->3->4->5->6->7->0. 
	//	This setting is used only for initialisation.
	//	Before init is complete it will change based on RX_PHY_MODE.
	//	See packet_rx_setup_next_thread_sig

	move(temp_nt_sig_reg, 0x80)	 				; next context bit [7] for signalling
	alu[temp_nt_sig_reg, temp_nt_sig_reg, OR, \
	             &sig_next_thread, <<3]			; [6:3] signal number

	move(rbuf_base, RBUF_TBUF_BASE)            	; set up RBUF base

	#ifdef	RFC_PPP_COUNTERS

	immed32(counter_base, PACKET_COUNTERS_SRAM_BASE); counters base addr.

	#endif

	move(dram_rbuf_ov,((1 << 25)|(1<<4)))	   	; [25] ref_cnt, [4] xfer regs overwrite
												
	immed32(protocol_mask,0xFFFF)          		; protocol mask for PPP hdr.

	//	To put a thread on to free list, we need the thread number,
	//	ME number, a signal and two xfer registers. Assemble all this
	//	info in a register.

	_packet_rx_get_current_me_thread_number(me_num, thread_num)
	_packet_rx_set_freelist_reg(freelist_reg, RX_EVENT_SIG, me_num, thread_num, &$rsw1)
	alu[freelist_reg,--, B, freelist_reg, <<16]	; for fast_wr, ms16bits is data

	//	Initialise Dispatch Loop vaiables to known state.

	alu[dl_next_block, --, B, BID_NULL]			; set dl_next_block NULL
	alu[dl_buf_handle, --, B, DL_BUF_NULL]     	; set dl_buffer_handle NULL
	alu[dl_eop_buf_handle, --, B, DL_BUF_NULL] 	; 

	//	This call is to eliminate the warnings
	//	What variable you pass here doesn't matter. Will get better next time

	dl_meta_init_cache(dl_next_block, dl_next_block, dl_next_block, dl_next_block, 0, 0, 0, 0)	; TBD: to avoid warning. Revisit


	//	Thread specific Initialisation.

.if(ctx()==0)

	//	Thread 0 does some onetime global initialisation.

	#ifdef POTS
	alu[@global_seq_num, --, b, 0]
	#endif

	#ifdef TWO_ME_PACKET_RX

	; Set the NN ring empty threshold to 0 LW's.
	; IN IXP2800 reference designs, the NN ring is used to
	; fetch buffers freed by CSIX TX microblock.
	; This saves us a trip to sram to fetch buffers.
	.reg ctx_enable
	local_csr_rd[ctx_enables]
	immed[ctx_enable, 0]
	alu_shf[ctx_enable, ctx_enable, AND~, 3, <<18]
	alu_shf[ctx_enable, ctx_enable, OR, 0, <<18]
	local_csr_wr[ctx_enables, ctx_enable]
	nop
	nop
	nop
	local_csr_wr[nn_get, 0]
	local_csr_wr[nn_put, 0]	

	#endif

#ifdef IXP2800

	.reg $tmp zero
	.sig msf_wr_sig

	//	There are some difference between IXP2800 and IXP2400 in initialisation.

	_packet_rx_set_rx_thread_freelist_timeout(0,RX_THREAD_FREELIST_TIMEOUT_0) 		; set the timeout 

	// Set RX_PORT_MAP MSF CSR.
	move($tmp, 0x000000ff)
	immed[zero, 0]
	msf[write, $tmp, zero, RX_PORT_MAP, 1], sig_done[msf_wr_sig]

	ctx_arb[msf_wr_sig]

#else

	//	IXP2400

	_packet_rx_set_rx_thread_freelist_timeout(0, RX_THREAD_FREELIST_TIMEOUT_0) 	; timeout is in bus clk cycles

	//	For SPHY 4x8 mode there are 4 thread freelists (one per port). 
	//	Set timeout for all freelists.

	#if ( (RX_PHY_MODE == SPHY_4_8) || (RX_PHY_MODE == MPHY_4) )

	_packet_rx_set_rx_thread_freelist_timeout(1, RX_THREAD_FREELIST_TIMEOUT_0)
	_packet_rx_set_rx_thread_freelist_timeout(2, RX_THREAD_FREELIST_TIMEOUT_0)
	_packet_rx_set_rx_thread_freelist_timeout(3, RX_THREAD_FREELIST_TIMEOUT_0)

	#else	//	RX_PHY_MODE != SPHY_4_8 and RX_PHY_MODE != MPHY_4 

	//	Time out of 0 means infinity. These freelist are not used at all.

	_packet_rx_set_rx_thread_freelist_timeout(1, 0x0) 	; No time out freelist_1
	_packet_rx_set_rx_thread_freelist_timeout(2, 0x0) 	; No time out freelist_2
	_packet_rx_set_rx_thread_freelist_timeout(3, 0x0) 	; No time out freelist_3

	#endif	// RX_PHY_MODE

	_packet_rx_free_all_rbuf_elements(RBUF_TOTAL_ELEMENTS)	; free all rbuf elements

	_packet_rx_set_rx_up_ctrl(0)							; set up some H/W stuff.
	_packet_rx_set_rx_up_ctrl(1)							; set up some H/W stuff.
	_packet_rx_set_rx_up_ctrl(2)							; set up some H/W stuff.
	_packet_rx_set_rx_up_ctrl(3)							; set up some H/W stuff.

#endif	// IXP2800/IXP2400

	_packet_rx_clear_all_context_desc()					; clear reassembly context data in local mem
	_packet_rx_set_all_port_header_type()				; set header type for each port
	system_init()										; dispatch loop system initialization

.else	//	ctx()!=0

	//	All other threads just wait for a kickstart signal
	//	This will come from system_init.

	ctx_arb[sig_next_thread]							; wait for signal fom prev thread.

.endif

	_dl_pos_sink_init()	   								; dispatch loop initialization. will be gone soon

	//	prefetch a buffer to store packets. From the handle get the location
	//	in DRAM where the packet will be stored.

	dl_buf_alloc($prefetch_buf_handle, BUF_FREE_LIST0, sig_buf_alloc, sig_buf_alloc)
	dl_buf_get_data(prefetch_data_handle, $prefetch_buf_handle) ; get prefetch data handle 

	//	In SPHY 4x8 mode there is one thread freelist per port. 
	//	We use two threads per port. i.e two threads per freelist.
	//	<0,1>, <2,3>, <4,5>, <6,7>

#if( (RX_PHY_MODE == SPHY_4_8) || (RX_PHY_MODE == MPHY_4) )

	.if((ctx()==0) || (ctx()==1))
		alu[rx_freelist,--,B, RX_THREAD_FREELIST_0]
	.elif ((ctx()==2) || (ctx()==3))
		alu[rx_freelist,--,B, RX_THREAD_FREELIST_1]
	.elif((ctx()==4) || (ctx()==5))
		alu[rx_freelist,--,B, RX_THREAD_FREELIST_2]
	.else
		alu[rx_freelist,--,B, RX_THREAD_FREELIST_3]
	.endif

#else

	alu[rx_freelist,--,B, RX_THREAD_FREELIST_0]

#endif

	msf[fast_wr, --, rx_freelist, freelist_reg]				; add this thread to freelist

	_packet_rx_signal_next_thread(temp_nt_sig_reg)			; Signal next thread

	//	Based on RX_PHY_MODE, setup thread order
	//	0->1->0, 2->3->2, 4->5->4, 6->7->6

	_packet_rx_setup_next_thread_sig(nt_sig_reg, thread_num)
#ifdef FIX_SEQUENCING
	_packet_rx_setup_seq_sig(seq_sig_reg, thread_num)
#endif

initial_end#:

	//	config_msf_rx_ctrl enables receive H/W. As soon as it done, we'll start
	//	receiving packets. Before that we want to make sure all other threads
	//	are on the freelist and ready to receive. Hence we do this init in 
	//	thread 7.

	br!=ctx[7, no_msf_config#]					; only thread 7 enables receive logic
	_packet_rx_config_msf_rx_ctrl()    					; start receiving

no_msf_config#:

	//	ctx() == 1 is not required because the previous call to
	//	signal_next_thread wokeup thread0.

#if( (RX_PHY_MODE == SPHY_4_8) || (RX_PHY_MODE == MPHY_4) )
	.if((ctx()==3) || (ctx()==5) || (ctx()==7))
		_packet_rx_signal_next_thread(nt_sig_reg)	; signal next thread
	.endif
	//tkh
	#ifdef FIX_SEQUENCING
	.if( (ctx()==1) || (ctx()==3) || (ctx()==5) || (ctx()==7) )
		_packet_rx_signal_next_thread(seq_sig_reg)	; signal next thread
	.endif
	#endif
	//tkh
#endif

    ctx_arb[rx_event]	 	    					; wait for a mpacket

#undef	MAX_PAYLOAD								
.end
#endm