///////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: packet_rx_context.h
//
//      Purpose:
// 
//			This header file defines the data structure used in the 
//			packet reaasembling.  
//
//      History:
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      06/05/2002      Created                         David Meng
//
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _PACKET_RX_CONTEXT_H
#define _PACKET_RX_CONTEXT_H


//	using C to define some data type
//	#define uint32 unsigned int
//	#define unit8	 char
//	Context descriptor is defined as following in local memory
//
//	context_desc{
//
// lword_0		uint32 state:1;				//if 1 PROC state, 0 START state	
// lword_0		uint32 reserved_0:31;
// lword_1		uint32 pkt_dst;		   		// pkt dst: Ipv4, Core, etc
// lword_2		uint32 sop_buf_size;   		// sop buffer size
// lword_3		uint32 prv_buf_size;   		// previous buffer size
// lword_4		uint32 current_data_ptr;	// DRAM addr of current buffer
// lword_5		uint32 buf_size; 		  	// bytes rcvd so far(in this buffer)
// lword_6		uint32 buffer_offset;	 	// offset withi buf where data begins
// lword_7		uint32 pkt_size;		  	// total bytes received so far
// lword_8		uint32 pkt_err_count;	  	// pkt drop counter
// lword_9		uint32 dl_sop_buf_handle; 	// SRAM address to the meta data structure
// lword_10		uint32 cell_count;	   		// no of cells in this buffer
// lword_11		uint32 byte_remaining  		// bytes remaining in last cell
// lword_12		uint32 prv_buf_handle; 		// Previous buffer handle
// lword_13		uint32 sop_buf_offset; 		// offset within SOP buf where data begins
// lword_14		uint32 dl_cur_buf_handle; 	// current buffer handle
// lword_15		uint32 header_type:8;		// Port header type (0-7 bit)
// lword_15		uint32 reserved:8;			// Port header type (8-15 bit)
// lword_15		uint32 max_buf_size:16;		// Port first buffer max data size (16-31 bit)	
//
//			} 	// Total is 4 x 16 = 64 bytes 


//	Define Reassembly Context in Local memory.
//	Local memory base should be at a multiple of context_size

#define CONTEXT_DESC_BASE		0	 		
#define	CONTEXT_SIZE			64			// in bytes. Must be power of 2.

///////////////////////////////////////////////////////////////////////////////
//
//	Index into Local memory reassembly context (see data structure above)
//
///////////////////////////////////////////////////////////////////////////////

#define	STATE_INDEX				0
#define PKT_DST_INDEX			1
#define SOP_BUF_SIZE_INDEX		2
#define PREV_BUF_SIZE_INDEX		3
#define CURRENT_DATA_PTR_INDEX	4
#define BUF_SIZE_INDEX			5
#define BUF_OFFSET_INDEX		6
#define PKT_SIZE_INDEX			7
#define PKT_ERR_INDEX			8
#define SOP_BUF_INDEX			9
#define CELL_COUNT_INDEX		10
#define BYTES_REMAINING_INDEX	11
#define PREV_BUF_HANDLE_INDEX	12
#define SOP_BUF_OFFSET_INDEX	13
#define CUR_BUF_INDEX			14
#define HEADER_TYPE_INDEX		15
#define MAX_BUF_SIZE_INDEX		15
#define TOTAL_PORTS				16

///////////////////////////////////////////////////////////////////////////////
//
//	Short cuts for Reassembly Context in local memory
//
///////////////////////////////////////////////////////////////////////////////

#define	lm_state			*l$index0[STATE_INDEX]
#define	lm_pkt_dst			*l$index0[PKT_DST_INDEX]
#define	lm_sop_buf_size		*l$index0[SOP_BUF_SIZE_INDEX]
#define	lm_prev_buf_size 	*l$index0[PREV_BUF_SIZE_INDEX]
#define	lm_cur_data			*l$index0[CURRENT_DATA_PTR_INDEX]
#define	lm_buf_size			*l$index0[BUF_SIZE_INDEX]
#define	lm_buf_offset		*l$index0[BUF_OFFSET_INDEX]
#define	lm_pkt_size			*l$index0[PKT_SIZE_INDEX]
#define	lm_pkt_err			*l$index0[PKT_ERR_INDEX]
#define	lm_sop_buf			*l$index0[SOP_BUF_INDEX]
#define	lm_cell_count		*l$index0[CELL_COUNT_INDEX]
#define	lm_bytes_remaining	*l$index0[BYTES_REMAINING_INDEX]
#define	lm_prev_buf			*l$index0[PREV_BUF_HANDLE_INDEX]
#define	lm_sop_buf_offset	*l$index0[SOP_BUF_OFFSET_INDEX]
#define	lm_cur_buf			*l$index0[CUR_BUF_INDEX]
#define	lm_header_type 		*l$index0[HEADER_TYPE_INDEX]
#define	lm_max_buf_size		*l$index0[MAX_BUF_SIZE_INDEX]

#endif //	_PACKET_RX_CONTEXT_H