///////////////////////////////////////////////////////////////////////////////
//
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT [c]  2002 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: packet_rx.uc
//
//      Purpose: A microblock that receives packets and feeds it to rest of
//               the pipeline. It receives mpackets, reassembles it, collects
//               context info like input port number, packet size etc and stores
//               it in the meta-data.
//
//      History:
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      06/05/2002      Created                         David Meng
//		11/11/2002		Added two ME solution			asv
//
/////////////////////////////////////////////////////////////////////////////

#ifndef	__PACKET_RX_UC__
#define	__PACKET_RX_UC__

// This microblock can run on either one ME or two ME's. When run on two ME's,
// it runs as a context pipeline with data being sent from the first ME to 
// the second ME via the next neighbor ring. So the two ME's have to be allocated
// side-by-side.
// By default the microblock runs on one ME.
// If a 'TWO_ME_PACKET_RX' switch is added, it runs on two ME's.
// The first ME of the context pipeline is identified using the
// 'FIRST_PACKET_RX_ME' switch.
// The second ME of the context pipeline is identified using the
// 'SECOND_PACKET_RX_ME' switch.

// Including needed files.
#include <dl_system.h>
#include <stdmac.uc>
#include <dispatch_loop.uc>
#include <hardware.h>
#include <packet_rx.h>
#include <packet_rx_context.h>
#include <packet_rx_common_util.uc>
#include <packet_rx_init.uc>

// Select util file based on whether packet rx runs on one ME or two ME's.
#ifdef TWO_ME_PACKET_RX
#include <packet_rx_two_me_util.uc>
#else
#include <packet_rx_one_me_util.uc>
#endif

#ifdef POTS
	// packet sequence number counter
	.reg @global_seq_num
#endif

//tkh
.reg volatile last_rsw



//------------------------------------------------
//	Main entry point - Code begins execution here.
//------------------------------------------------

main#:

#ifdef _DEBUG_COUNTERS_
.reg @pkt_rx_num_proper_mpkts_rxed		; number of non-error mpackets received
.reg @pkt_rx_num_err_mpkts_rxed			; number of error mpackets received
.reg @pkt_rx_drop_scr_ring_full			; number packet dropped because of scratch ring full
.reg @pkt_rx_num_pkts					; number of pkts send to next stage
.reg @pkt_rx_drop						; number of single buffer pkts dropped.
.reg @pkt_rx_buf_alloc_fail				; number of buffer alloc failures
.reg @pkt_rx_enqueued					; tkh
#endif // _DEBUG_COUNTERS_


//---------------------------------
//	Packet RX running on two ME's.
//---------------------------------
#ifdef TWO_ME_PACKET_RX

//---------------------------------
//	First Packet RX ME - Begin
//---------------------------------
#ifdef FIRST_PACKET_RX_ME
.begin

	; Initialization.
	; This macro also does system initialization.
	packet_rx_init()

	; Initialize gpr that holds prefetched buffer handle.
	move(prefetch_buf_handle_gpr, 0)

system_init_done#:		

.while(1)

	; Packet processing code.
	; If a valid m-packet was received, this macro writes to the
	; nn ring so that the second ME can continue processing the
	; m-packet. If the received m-packet was invalid, nothing
	; is written to the nn ring.
	packet_pkt_rx()

.endw

.end
#endif // FIRST_PACKET_RX_ME
//---------------------------------
//	First Packet RX ME - End
//---------------------------------

//---------------------------------
//	Second Packet RX ME - Begin
//---------------------------------
#ifdef SECOND_PACKET_RX_ME

	; Signal used to sink a packet.
	.sig sig_sink

	; Mask that holds signals to wait on at the end of each iteration.
	.reg sink_sig_mask

	; Initialization.
	packet_rx_2_init()

	; Signal next thread.
	_packet_rx_signal_next_thread(nt_sig_reg)

	; Reset sink_sig_mask.
	alu[sink_sig_mask, --, b, 1, <<&sig_next_thread]

	; By default set dl_next_block to BID_NULL.
	alu[dl_next_block, --, b, BID_NULL]

.while(1)

	; Packet processing code.
	packet_pkt_rx_2()

	; Allocate transfer registers to be used by dl_sink
	xbuf_alloc($x_dl_sink, 5, write)	// no code generated

	; Send the packet to the next block in the pipeline.
	; Even though dl_sink is called for every mpacket, actual
	; work will be done only on receiving EOP.
	dl_sink($x_dl_sink, sig_sink, sink_sig_mask)

	; To avoid warnings. The assembler can't find that we actually
	; waited on this sig_sink because of the use of signal masks.
	.io_completed sig_sink

	; Free the transfer registers.
	xbuf_free($x_dl_sink)

	; Signal next thread.
	_packet_rx_signal_next_thread(nt_sig_reg)

	; Reset sink_sig_mask.
	alu[sink_sig_mask, --, b, 1, <<&sig_next_thread]

	; By default set dl_next_block to BID_NULL.
	alu[dl_next_block, --, b, BID_NULL]

.endw

#endif // SECOND_PACKET_RX_ME
//---------------------------------
//	Second Packet RX ME - End
//---------------------------------


//---------------------------------
//	Packet RX running on one ME.
//---------------------------------
#else // ONE_ME_PACKET_RX

.begin

	; Initialization.
	; This macro also does system initialization.
	packet_rx_init()


system_init_done#:		

;TKH
	; Signal used to sink a packet.
	.sig	sig_sink
	; Mask that holds signals to wait on at the end of each iteration.
	.reg	sink_sig_mask
;TKH

.while(1)

;	; Signal used to sink a packet.
;	.sig	sig_sink
;	; Mask that holds signals to wait on at the end of each iteration.
;	.reg	sink_sig_mask

	; Allocate transfer registers to be used by dl_sink
#ifdef POTS
	xbuf_alloc($x_dl_sink, 6, write)	// no code generated
#else
	xbuf_alloc($x_dl_sink, 5, write)	// no code generated
#endif

	; Packet processing code. For every mpacket the output of this
	; macro is dl_next_block, dl_buf_handle and dl_eop_buf_handle. 
	packet_pkt_rx()
	
	alu[last_rsw, --, b, $rsw1]

	; Send the packet to the next block in the pipeline.
	; Even though dl_sink is called for every mpacket, actual
	; work will be done only on receiving EOP.
	dl_sink($x_dl_sink, sig_sink, sink_sig_mask)

	; To avoid warnings. The assembler can't find that we actually
	; waited on this sig_sink because of the use of signal masks.
	.io_completed sig_sink

	; Free the transfer registers
	xbuf_free($x_dl_sink)	// no code generated

.endw

.end

#endif // TWO_ME_PACKET_RX

#endif	//	__PACKET_RX_UC__