///////////////////////////////////////////////////////////////////////////////
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
///////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: packet_rx.h
//
//      Purpose: 
//
//      History:
//
//
//      Date            Comment                         By
//      ---------------------------------------------------------------------
//
//      06/05/2002      Created                         David Meng
//
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __PACKET_RX_H__
#define __PACKET_RX_H__

#include <definitions.h>
#include <dl_system.h>
#include <hardware.h>

#ifdef USE_IMPORT_VAR

.import_var PACKET_COUNTERS_SRAM_BASE
.import_var FREE_LIST_ID

#else

/* counters_base is being defined in dl_system.h */

#endif

//	Define decode response time 1 clock, no parity check and Packet mode
#define RX_UP_CTRL			((RX_DR_TIME_2_CLOCK << RX_DR_TIME_BITS) |\
							 (RX_PARITY_ODD << RX_PARITY_BITS)|\
							 (RX_CP_MODE_PACKET << RX_CP_MODE_BITS)|\
							 (1<<5))
							 // RX PPMODE = 1 for POS-PHY L3 TKH

#define RX_EVENT_SIG			6

#define	RBUF_TOTAL_BYTES		8192
#define RBUF_SIZE				128
#define RBUF_SIZE_IN_8B			16
//#define	RBUF_TOTAL_ELEMENTS		( RBUF_TOTAL_BYTES / RBUF_SIZE )
#define	RBUF_TOTAL_ELEMENTS		31			// TKH fix for undocumented errata

#define PREPEND_BYTES			8 				// Per cell header size
#define	PER_PKT_PREPEND_BYTES	8				// Per packet (TM) header size
#define CELL_SIZE				120  			// Cell size (without cell hdr)

//	XXX Should this be 0x2a??? a reserved bit is currently set

//#define ALL_ERROR_CODE			0x2E 			// Mask for all errors. TKH
#define ALL_ERROR_CODE			0x3F//TKH 			// Mask for all errors except rxerr 
#define NULL_ERROR_CODE			0x0200 			// Mask for NULL error

#define RX_THREAD_FREELIST_TIMEOUT_0 1024	 	// 1024 bus clock time out intervale


//	Define how many bytes of PPP header

#ifdef PPP_2_BYTE_HEADER
#define PPP_HEADER			2
#else	
#ifdef PPP_4_BYTE_HEADER
#define PPP_HEADER			4
#endif
#endif

#define	ETHER_HEADER		14					// define Ethernet header length

//	Only buffers with SOP need headroom (for encap/decap). Other buffers
//	can have data starting from offset 0 (within the buffer)

#define NON_SOP_OFFSET		0 

#ifdef 	ETHER_RECEIVE
#undef 	BID_NEXT_BLOCK		
#define BID_NEXT_BLOCK		BID_ETHER			//	Next bloock is ETHER receive
#else
#ifdef	PPP_RECEIVE
#undef 	BID_NEXT_BLOCK		
#define BID_NEXT_BLOCK		BID_POS				//	Next bloock is POS receive
#endif
#endif

#define	POSHDR_PROTOCOL_IP	0x21				//	IP number in PPP header

#define	RAND_OFFSET_MASK	0x1ff				//	Mask to wrap around (0x200)

//	States of Receive Machine

#define STATE_PROC			0x1
#define STATE_START			0x0

//	 PACKET counters. The offset (PACKET_COUNTERS_SRAM_BASE) is specified.

#define	PACKET_PKTS_RECEIVED	0
#define	PACKET_PKTS_DROPPED  	4
#define	PACKET_PKTS_EXCEPTION	8
#define	PACKET_BYTES_RECEIVED	12

/*	Following define classification header type	*/

#define PORT_0_IDX		0
#define PORT_1_IDX		1
#define PORT_2_IDX		2
#define PORT_3_IDX		3
#define PORT_4_IDX		4
#define PORT_5_IDX		5
#define PORT_6_IDX		6
#define PORT_7_IDX		7
#define PORT_8_IDX		8
#define PORT_9_IDX		9
#define PORT_10_IDX		10	
#define PORT_11_IDX		11
#define PORT_12_IDX		12
#define PORT_13_IDX		13
#define PORT_14_IDX		14
#define PORT_15_IDX		15


//	Followig are the definition for each input port type
#if (RX_PHY_MODE == SPHY_1_32)

#ifdef		ETHER_RECEIVE
#define 	PORT_0_TYPE		ETHER_TYPE
#else

#ifdef 		PPP_RECEIVE
#define 	PORT_0_TYPE		PPP_TYPE
#endif

#endif

#endif

#if	( (RX_PHY_MODE == SPHY_4_8) || (RX_PHY_MODE == MPHY_4) )
#ifdef 		ETHER_RECEIVE
#define 	PORT_0_TYPE		ETHER_TYPE
#define 	PORT_1_TYPE 	ETHER_TYPE
#define 	PORT_2_TYPE 	ETHER_TYPE
#define 	PORT_3_TYPE 	ETHER_TYPE
#else
#ifdef 		PPP_RECEIVE
#define 	PORT_0_TYPE		PPP_TYPE
#define 	PORT_1_TYPE 	PPP_TYPE
#define 	PORT_2_TYPE 	PPP_TYPE
#define 	PORT_3_TYPE 	PPP_TYPE
#endif
#endif
#endif

#if(RX_PHY_MODE == MPHY_16)					/* MPHY 16 mode. */
#ifdef 		ETHER_RECEIVE					/* Ethernet receiving. */
#define 	PORT_0_TYPE		ETHER_TYPE
#define 	PORT_1_TYPE 	ETHER_TYPE
#define 	PORT_2_TYPE 	ETHER_TYPE
#define 	PORT_3_TYPE 	ETHER_TYPE
#define 	PORT_4_TYPE 	ETHER_TYPE
#define 	PORT_5_TYPE 	ETHER_TYPE
#define 	PORT_6_TYPE 	ETHER_TYPE
#define 	PORT_7_TYPE 	ETHER_TYPE
#define 	PORT_8_TYPE 	ETHER_TYPE
#define 	PORT_9_TYPE 	ETHER_TYPE
#define 	PORT_10_TYPE 	ETHER_TYPE
#define 	PORT_11_TYPE 	ETHER_TYPE
#define 	PORT_12_TYPE 	ETHER_TYPE
#define 	PORT_13_TYPE 	ETHER_TYPE
#define 	PORT_14_TYPE 	ETHER_TYPE
#define 	PORT_15_TYPE 	ETHER_TYPE
#else										/* Not ethernet receiving.*/
#ifdef 		PPP_RECEIVE						/* PPP receiving. */
#define 	PORT_0_TYPE		PPP_TYPE
#define 	PORT_1_TYPE 	PPP_TYPE
#define 	PORT_2_TYPE 	PPP_TYPE
#define 	PORT_3_TYPE 	PPP_TYPE
#define 	PORT_4_TYPE 	PPP_TYPE
#define 	PORT_5_TYPE 	PPP_TYPE
#define 	PORT_6_TYPE 	PPP_TYPE
#define 	PORT_7_TYPE 	PPP_TYPE
#define 	PORT_8_TYPE 	PPP_TYPE
#define 	PORT_9_TYPE 	PPP_TYPE
#define 	PORT_10_TYPE 	PPP_TYPE
#define 	PORT_11_TYPE 	PPP_TYPE
#define 	PORT_12_TYPE 	PPP_TYPE
#define 	PORT_13_TYPE 	PPP_TYPE
#define 	PORT_14_TYPE 	PPP_TYPE
#define 	PORT_15_TYPE 	PPP_TYPE
#endif										/* PPP receiving done.*/
#endif										/* Receiving mode done.*/
#endif										/* MPHY 16 done. */

#define INGRESS_UCAST				0x00				
#define INGRESS_MCAST				0x01
#define INGRESS_PROMISC				0x03

#endif // __PACKET_RX_H__ 
