////////////////////////////////////////////////////////////////////////////////////////
//
//                  I N T E L   P R O P R I E T A R Y
//
//     COPYRIGHT (c)  2003 BY  INTEL  CORPORATION.  ALL RIGHTS
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT
//     THE PRIOR WRITTEN PERMISSION OF :
//
//                        INTEL  CORPORATION
//
//                     2200 MISSION COLLEGE BLVD
//
//               SANTA  CLARA,  CALIFORNIA  95052-8119
//
////////////////////////////////////////////////////////////////////////////////////////
//
//
//      File Name: ethernet_ipv4.uc
//
//      Purpose: This file contains dispatch loop for IPV4 Forwarding application over
//          Ethernet.
//
//      History:
//
//
//      Date            Comment                                     By
//      --------------------------------------------------------------------------------
//
//      06/10/2002      Created                                     Eswar Eduri
//
//
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef __ETHERNET_IPV4_UC__
#define __ETHERNET_IPV4_UC__

//  Include Files

// include system.h from dispatch loop
#include    "dl_system.h"

#include    "definitions.h"

// include system_init.h from dispatch loop for inter ME signal
#include    "system_init.uc"

// include dispatch_loop.uc from dispatch loop
#include    "dispatch_loop.uc"

// include ipv4_fwder_dl.uc from IPV4 forwarder
#include    "ipv4_fwder_init.uc"


// include ipv4_fwder.uc from IPV4 forwarder
#include    "ipv4_fwder.uc"

// include ether.uc from rx/l2
#include    "ether.uc"


//include ethernet_arp constants
#include    "ethernet_arp.h"

// constants
// None.


//-----------------------------------------------------------
// Initialize the blocks
//-----------------------------------------------------------

init#:
    // allocate cache to store the packet header
    dl_iphdr_cache_init[]
#ifndef __PKTHDR
#define __PKTHDR    $$iphdr ; for convenience. DL defines this.
#else
#warning    "__PKTHDR is already defined."
#endif

    ; init buffer meta data cache to Zero.
    init_meta_cache_to_zero[]

    ; Temporary : Initialize EOP handle default.
    _dl_eop_buf_handle_init[]

#ifdef USE_IMPORT_VAR
    ; The code below is only to patch all standard constants
    .begin
    .reg tmp0

#ifdef COUNTERS

    // PACKET_TX_COUNTER_BASE is patched here because we must patch
    // L2_TABLE_SRAM_BASE and the easiest way is to
    // expand the UE mask for ethernet TX core component which has also
    // PACKET_TX_COUNTER patched.
    .import_var PACKET_TX_COUNTER_BASE

        immed32[tmp0, PACKET_TX_COUNTER_BASE]
        .use tmp0

#endif //COUNTERS

        immed32[tmp0, BUF_FREE_LIST0]
        .use tmp0
        immed32[tmp0, DL_REL_BASE]
        .use tmp0
        immed32[tmp0, BUF_SRAM_BASE]
        .use tmp0
    .end
#endif

#ifndef DISABLE_IPV4 //for host-stack testing purposes

#ifdef ETHER_WITHOUT_L2
    ; init l2
#ifndef DISABLE_MAC_FILTERING
    _ether_init(SRAM_FLT_TABLE_BASE, SRAM_PORT_BIT_MAP_BASE)
#else
    ; in this case the L2 gprs are unused so set them to 0
    _ether_init(0, 0)
#endif
#endif
	//; initialize DL registers
	//immed[dl_exception_reg, 0]

    ; initialize l2 validation stage
    .reg l2_table_base
    .reg id_l2_header_exist

    _init_l2_validation(id_l2_header_exist, l2_table_base)

    ; ipv4fwder initialization
    _ipv4_fwder_init()

    ; now kick start the IPV4 Forwarder
    _ipv4_fwder_kick_start()

//-----------------------------------------------------------
// dispatch loop
//-----------------------------------------------------------
.begin
.reg sig_mask
    immed32[sig_mask, 0]

    // get packets in order.
    dl_source[DL_THREAD_ORDER, sig_mask]

.end
#endif  /* DISABLE_IPV4 */

// Thread 0 of the IPV4_START_ME  from here on
// will process only exception packets. There
// is enough headroom available and will not affect
// performance

#ifdef USE_IMPORT_VAR
#ifdef  IPV4_START_ME
    br=ctx[0,_handle_exception_pkt#]
#endif
#endif


#ifdef DISABLE_IPV4

    ctx_arb[kill]

#else /* DISABLE_IPV4 */

loop#:
	; initialize dl_exception to 0
	immed[dl_exception_reg, 0]

#ifdef ETHER_WITHOUT_L2
    _ether_decap_classify(__PKTHDR,ETHER_HEADER_OFFSET)
#endif

    ;process the IP header. The modified packet is in cache
    ;registers starting at IP_HDR_OFFSET.

    _ipv4_fwder(__PKTHDR,__PKTHDR,IP_HDR_OFFSET,IP_HDR_OFFSET)

    // The above macro copies only 20 bytes of IP header to the
    // destination register buffer. we need to copy the registers untouched
    // by the above macro. The registers modified is dependent on
    // where the IP Hdr starts in the buffer.

#if (IP_HDR_OFFSET == 14)
    // copy untouched registers
    alu[__PKTHDR/**/0,--,B,__PKTHDR/**/0]
    alu[__PKTHDR/**/1,--,B,__PKTHDR/**/1]
    alu[__PKTHDR/**/2,--,B,__PKTHDR/**/2]
    alu[__PKTHDR/**/9,--,B,__PKTHDR/**/9]
#endif


    //Check whether L2 address for the next_hop_id is valid
    //If not send the packet to the core for ARP resolution
    _l2_validate()

    // Now call DL macros to send the current packet
    // and received the next packet. Depending on the dl_next_block, these
    // macros can drop/send exception/send to next block. Also, we need to
    // maintain packet order when we send/receive packets.

.reg sig_mask
.sig sig_scr_put
.set_sig sig_scr_put

    // allocate xfer registers to be used by dl_qm_sink.
    xbuf_alloc[$wxfer, 3, write]
    immed32[sig_mask, 0]

    // send packet.
    dl_qm_sink[sig_mask, sig_scr_put, $wxfer]

    // receive packet
    dl_source[DL_THREAD_NO_ORDER, sig_mask]

.io_completed sig_scr_put

    // free the xfer registers allocated
    xbuf_free[$wxfer]

    // start again.
    br[loop#]   

#endif  /* DISABLE_IPV4 */

#ifdef USE_IMPORT_VAR
#ifdef IPV4_START_ME

_handle_exception_pkt#:
    
        dl_get_exception_pkt()

        br[_handle_exception_pkt#]  

#endif //IPV4_START_ME
#endif //USE_IMPORT_VAR

// We never execute the below code. This is here for completeness only.

term#:
    // frees the IP header cache
    dl_iphdr_cache_fini[]

    // Control should never come here.
kill#:
    nop
    nop

#endif  // __ETHERNET_IPV4_UC__


