/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   ix_sa_symbols.c
 *
 * Patches misc symbols for this configuration.
 **/
/*=========================================================================*/
#define IX_ERROR_FILE_IDENT "$Id: ix_sa_symbols.c,v 1.5.2.1 2004/03/11 17:50:12 ksandowi Exp $"

#include "ix_ossl.h"
#include "ix_cc_error.h"
#include "sa/internal/internal_sa.h"
#include "sa/ix_sa_cc_list.h"
#include "cc/ix_cc_eth_tx.h"

#if !defined(IX_CONFIGURATION_quad_gbeth_2401)
#error IX_CONFIGURATION_quad_gbeth_2401 not defined! Wrong configuration header.
#endif

#if (defined IX_PLATFORM_2401)
#if (defined USE_BB_DRV_CONFIG)
extern ix_uint32 hwConfigEthPortMask;/* ETH Port Mask */
extern ix_uint32 hwConfigEthMode[IX_CC_ETH_TX_MAX_NUM_PORTS]; /* ETH Port configuration mode value */
#endif /* USE_HW_CONFIG || USE_BB_DRV_CONFIG */
#endif /* IX_PLATFORM_2x01 */

/*  _ix_sa_patch_symbols */
/*  ---------------------------------------- */
/**
 * Patch miscelanious symbols.
 *
 * This function patches a variety of symbols not specifially associated
 * with a given Core Component.
 *
 *
 * @param arg_sa_ctrl System Application Control Structure
 * @return IX_SUCCESS, a pass through ix_error, or an ix_error with one
 *         of the following values.
 * @retval NONE
**/
ix_error
_ix_sa_patch_symbols(ix_sa_ctrl *arg_sa_ctrl)
{
    ix_imported_symbol aImportSymbols[7];
    ix_uint32 relBase = 0;
    ix_buffer_free_list_info hwFreeListInfo;
    void *pZeroBlock;
    ix_uint32 phys_meta_address = 0;
    ix_uint32 phys_data_address = 0;
    ix_memory_type memType;
    ix_uint32 channel = 0;
    ix_uint32 zboffset = 0;
    void *pPhysicalAddress = NULL;

#if (defined IX_PLATFORM_2401) || (defined IX_PLATFORM_2801)
#if (defined USE_BB_DRV_CONFIG)
	int i;

	if((hwConfigEthPortMask == 0x3) ||	/* MIC_C2xGB_BRD_ID or MIC_F2xGB_BRD_ID */
	   (hwConfigEthPortMask == 0x30))	/* MIC_C4xGB_MEZZ_ID or MIC_F4xGB_MEZZ_ID */
	{
		hwConfigEthPortMask |= 0xc;	/* Add backplane ports to the port's mask */
		for(i = 2; i < 4; i++)
			hwConfigEthMode[i] = IX_CC_ETH_TX_DRIVER_MODE_GIGA_FULL_DUPLEX |
        					 	 IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN |
                             	 IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8;
	}
	else /* all ports on baseboard: 2 backplane + 2 front coper (for baseboard spin 1A) */
	{
		hwConfigEthPortMask |= 0xf;	/* Add backplane ports to the port's mask */
		for(i = 0; i < 4; i++)
			hwConfigEthMode[i] = IX_CC_ETH_TX_DRIVER_MODE_GIGA_FULL_DUPLEX |
        					 	 IX_CC_ETH_TX_DRIVER_MODE_PARITY_EVEN |
                             	 IX_CC_ETH_TX_DRIVER_MODE_BLOCK_4_8;
	}
#endif /* USE_BB_DRV_CONFIG */
#endif /* IX_PLATFORM_2x01 */

    IX_ERROR_CHECK_ARG_NULL(1, arg_sa_ctrl);

    /* allocate a long work in sram to patch to the zeroblock symbol */
    IX_ERROR_CR(ix_rm_mem_alloc(IX_MEMORY_TYPE_SRAM, 0,
                                sizeof(ix_uint32)*16, &pZeroBlock));
    ix_ossl_memset(pZeroBlock, 0, sizeof(ix_uint32)*16);


    IX_ERROR_CR(ix_rm_buffer_free_list_get_info(arg_sa_ctrl->freelist[1],
                                                &hwFreeListInfo));

    IX_ERROR_CR(ix_rm_get_phys_offset((void*)hwFreeListInfo.m_pMetaBaseAddress,
                                      &memType, &channel, &phys_meta_address,
                                      &pPhysicalAddress));

    IX_ERROR_CR(ix_rm_get_phys_offset((void*)hwFreeListInfo.m_pDataBaseAddress,
                                      &memType, &channel, &phys_data_address,
                                      &pPhysicalAddress));

    IX_CC_SET_SRAM_CHANNEL_INTO_OFFSET(0, phys_meta_address);
    IX_CC_SET_SRAM_CHANNEL_INTO_OFFSET(0, phys_data_address);

    relBase = phys_data_address - (phys_meta_address *
                                   (hwFreeListInfo.m_DataElementSize/
                                    hwFreeListInfo.m_MetaElementSize));

    aImportSymbols[0].m_Value = phys_meta_address;
    aImportSymbols[0].m_Name  = "BUF_SRAM_BASE" ;

    aImportSymbols[1].m_Value = (ix_uint32) hwFreeListInfo.m_FreeListInfo;
    aImportSymbols[1].m_Name  = "BUF_FREE_LIST0" ;

    aImportSymbols[2].m_Value =  relBase ;
    aImportSymbols[2].m_Name  = "DL_REL_BASE" ;


    /* patch these symbols appropriatly */

    /*
     * On the 1st ME we run ether RX
     */
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[0],3,aImportSymbols));

    /*
     * On the 2nd,3rd and 8th MEs we run IPV4
     */
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[1],3,aImportSymbols));
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[2],3,aImportSymbols));
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[7],3,aImportSymbols));

    /*IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[4],3,aImportSymbols));*/

    /*
     * On the 6th and 7th MEs we run ether TX
     */
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[5],3,aImportSymbols));
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[6],3,aImportSymbols));


    /*
     * On the 4th ME that runs Queue Manager we can't patch DL_REL_BASE so patch only first
     * two vars
     */
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(g_aMicroengineNumberMapping[3],2,aImportSymbols));


    IX_ERROR_CR(ix_rm_get_phys_offset((void*)pZeroBlock,
                                      &memType, &channel, &zboffset,
                                      &pPhysicalAddress));

    aImportSymbols[0].m_Value = (ix_uint32)zboffset;
    aImportSymbols[0].m_Name  = "SRAM_ZERO_BLOCK";
    /*IX_ERROR_CR(ix_rm_ueng_patch_symbols(0x01,1,aImportSymbols));*/
    /*IX_ERROR_CR(ix_rm_ueng_patch_symbols(0x02,1,aImportSymbols));*/

    IX_ERROR_CR(ix_rm_ueng_patch_symbols(0x10,1,aImportSymbols));

    /*IX_ERROR_CR(ix_rm_ueng_patch_symbols(0x13,1,aImportSymbols));*/




/*
    printf("+++FLID: 0x%08lx\n", 1);
*/
    aImportSymbols[0].m_Value = (ix_uint32)hwFreeListInfo.m_FreeListInfo1;
    aImportSymbols[0].m_Name  = "FREE_LIST_ID";
    IX_ERROR_CR(ix_rm_ueng_patch_symbols(0,1,aImportSymbols));



/***************TEMPORARY REMOVE AS CCs ARE ADDED*************************/


    return IX_SUCCESS;
}








