/*===========================================================================
 * = COPYRIGHT INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a licence agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 * ===========================================================================
 */

/* =========================================================================*/
/**
 * @file   ix_sa_cc_list.c
 *
 * Definition of CC_INITIALIZATION funciton.
 *
 **/
/*=========================================================================*/
/* $Id: ix_sa_cc_list.c,v 1.4.2.1 2004/03/11 17:49:42 ksandowi Exp $ */
#include "ix_ossl.h"
#include "ix_cc_error.h"
#include "sa/ix_sa_cc_list.h"

#include "cc/ix_cc_ipv4.h"
#include "cc/ix_cc_stkdrv.h"
#include "cc/ix_cc_qm_frmwrk.h"
#include "cc/ix_cc_eth_tx.h"
#include "cc/ix_cc_sched.h"
#include "cc/ix_cc_eth_rx.h"
#include "sa/internal/build_header.h"

#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)
/*  _ix_sa_set_cc */
/*  ---------------------------------------- */
/**
 * This function is used to set a init and fini function for a CC
 *
 * @return IX_SUCCESS upon success or an ix_error with one of the following values.
 * @retval NONE
**/
ix_error
_ix_sa_set_cc(
    ix_sa_ccfunc	*arg_pCC_List,
    ix_uint32	arg_idx,
    ix_cc_init	arg_Init,
    ix_cc_fini	arg_Fini)
{
    ix_uint32	i;

    IX_ERROR_CHECK_ARG_NULL(1, arg_pCC_List);
    arg_pCC_List[arg_idx].init = arg_Init;
    arg_pCC_List[arg_idx].fini = arg_Fini;
    for (i = 0; i < IX_CC_INSTANCE_MAX; i++)
    {
        arg_pCC_List[arg_idx].cc_handle[i] = 0;
    }
    return IX_SUCCESS;
}
#endif

#if !defined(IX_CONFIGURATION_quad_gbeth_2401)
#error IX_CONFIGURATION_quad_gbeth_2401 not defined! Wrong configuration header.
#endif

#ifndef BUILD_VERSION_TEXT
#define BUILD_VERSION_TEXT
#define BUILD_VERSION_DESCRIPTION "private build"
#define SEPARATOR
#else
#define BUILD_VERSION_DESCRIPTION BUILD_VERSION_TEXT
#define SEPARATOR "/"
#endif


#if (_IX_OS_TYPE_ != _IX_OS_LINUX_KERNEL_)

char g_sa_uofFile[] = "/target/config/ixdp2401_be/"
                      BUILD_VERSION_TEXT
		      SEPARATOR
                      "quad_gbeth_2401.uof";
#else
char g_sa_uofFile[512] = "quad_gbeth_2401.uof";
#endif

/*  _ix_sa_cc_list */
/*  ---------------------------------------- */
/**
 * This function generates and returns the ix_sa_ccfunc array.
 *
 * An array containing pointers to various cc functions is returned
 * to be used during cc initialization.
 *
 * @return IX_SUCCESS, a pass through ix_error, or an ix_error with one
 *         of the following values.
 * @retval IX_CC_ERROR_NULL arg_pCC_List is NULL
**/
ix_error
_ix_sa_cc_list(ix_sa_ccfunc *arg_pCC_List)
{
    IX_ERROR_CHECK_ARG_NULL(1, arg_pCC_List);
    /*
     * print the official build number
     */
    ix_ossl_message_log("\n Build version:  "BUILD_VERSION_DESCRIPTION"\n");

    /* add one entry for each CC in this configuration.  example below.
     *   _ix_sa_set_cc
     *          Param #1: the cclist passed to _ix_sa_cc_list (arg_pCC_List)
     *          Param #2: Identifier of CC as defined in bindings.h
     *          Param #3: The CCs init function (include header in this file)
     *          Param #4: The CCs fini function
    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_DUMMY, _ix_sa_dummy_cc_init, _ix_sa_dummy_cc_fini);
    */


    /* Stack Driver */
    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_STKDRV, ix_cc_stkdrv_init, ix_cc_stkdrv_fini);

    /* Queue Manager*/
    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_QM, ix_cc_qm_init, ix_cc_qm_fini);

    /* IPV4 Forwarder */

    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_IPV4, ix_cc_ipv4_init, ix_cc_ipv4_fini);


    /* Eth Tx */
    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_ETH_TX, ix_cc_eth_tx_init, ix_cc_eth_tx_fini);

    /* Scheduler */
    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_SCHEDULER, ix_cc_sched_init, ix_cc_sched_fini);


    /* Eth Rx */
    _ix_sa_set_cc(arg_pCC_List,
                  IX_CC_ETH_RX, ix_cc_eth_rx_init, ix_cc_eth_rx_fini);
    return IX_SUCCESS;
}
