#
# ============================================================================
# = COPYRIGHT
#              INTEL CORPORATION PROPRIETARY INFORMATION
#   This software is supplied under the terms of a licence agreement or
#   nondisclosure agreement with Intel Corporation and may not be copied
#   or disclosed except in accordance with the terms in that agreement.
#      Copyright (C) 2003 Intel Corporation. All rights reserved.
#
# = PRODUCT
#      Intel(r) IXA SDK for the IXP2X00 Network Processor
#
# = FILENAME
#      ethernet_rtm_config.scr
#
# = DESCRIPTION
#      This file contains scripts to initialize the quad_gbeth_2401
#      application on an IXPD2401 platform.
#
# = AUTHOR
#      Tomasz Madajczak
#      tomasz.madajczak@intel.com
#
# = CHANGE HISTORY
#      02/26/2003      Created by Tomasz Madajczak
# ============================================================================
#

# 16-bit routes - Forward
#-----------------------------------------------

# Use either addV4L3Info or addV4EthEntry. The former adds only IP address and
# learns MAC address from ARP.
#./l2config addV4L3Info "1 16.1.0.10"
./l2config addV4EthEntry "1 16.1.0.10 0a:0c:14:37:10:a2 02:01:02:03:00:01 DEFAULT"
./rconfig addNextHop "1 1 1 0 1500 0 16.1.0.10 0"
./rconfig addRoute "16.1.0.0 255.255.0.0 1"

#./l2config addV4L3Info "2 16.2.0.10"
./l2config addV4EthEntry "2 16.2.0.10 0a:0c:14:37:20:a2 02:01:02:03:00:02 DEFAULT"
./rconfig addNextHop "2 1 2 1 1500 0 16.2.0.10 0"
./rconfig addRoute "16.2.0.0 255.255.0.0 2"

#./l2config addV4L3Info "3 16.3.0.10"
./l2config addV4EthEntry "3 16.3.0.10 0a:0c:14:37:30:a2 02:01:02:03:00:03 DEFAULT"
./rconfig addNextHop "3 1 3 2 1500 0 16.3.0.10 0"
./rconfig addRoute "16.3.0.0 255.255.0.0 3"

#./l2config addV4L3Info "4 16.4.0.10"
./l2config addV4EthEntry "4 16.4.0.10 0a:0c:14:37:40:a2 02:01:02:03:00:04 DEFAULT"
./rconfig addNextHop "4 1 4 3 1500 0 16.4.0.10 0"
./rconfig addRoute "16.4.0.0 255.255.0.0 4"


# Directed broadcast - Exception
#-----------------------------------------------
./rconfig addNextHop "50 1 50 0 1500 8 16.1.255.255 0"
./rconfig addRoute "16.1.255.255 255.255.255.255 50"
./l2config addV4EthEntry "50 16.1.255.255 ff:ff:ff:ff:ff:ff 02:01:02:03:00:01 DEFAULT"

./rconfig addNextHop "60 1 60 1 1500 8 16.2.255.255 0"
./rconfig addRoute "16.2.255.255 255.255.255.255 60"
./l2config addV4EthEntry "60 16.2.255.255 ff:ff:ff:ff:ff:ff 02:01:02:03:00:02 DEFAULT"

./rconfig addNextHop "70 1 70 2 1500 8 16.3.255.255 0"
./rconfig addRoute "16.3.255.255 255.255.255.255 70"
./l2config addV4EthEntry "70 16.3.255.255 ff:ff:ff:ff:ff:ff 02:01:02:03:00:03 DEFAULT"

./rconfig addNextHop "80 1 80 3 1500 8 16.4.255.255 0"
./rconfig addRoute "16.4.255.255 255.255.255.255 80"
./l2config addV4EthEntry "80 16.4.255.255 ff:ff:ff:ff:ff:ff 02:01:02:03:00:04 DEFAULT"


