/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a licence agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2003 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      xscale_init.h
 *
 * = DESCRIPTION
 *      This file contains definitions used by xscale_init files.
 *
 * = AUTHOR
 *      Adam Tumialis
 *      adam.tumialis@intel.com
 *
 * = CHANGE HISTORY
 *      06/17/2003      Initially created
 * ============================================================================
 */

#ifndef XSCALE_INIT_H
#define XSCALE_INIT_H

#ifndef XSCALE_INIT_FOR_LINUX

/* Macro to write and read one longword from memory
   the macro assumes that the memory being read or written to
   is mapped
 */
#define GET32(address)  	(*(volatile unsigned int *)(address))
#define PUT32(address,val)  (*(volatile unsigned int *)(address) = (val))

#define set_sram(a, b) 		PUT32(a, b)
#define set_dram(a, b) 		PUT32(a, b)

#define SDRAM_BEGIN	 0x2000000

#else

#include <stdio.h>
#include "linux_mmap_lib.h"

#define SDRAM_BEGIN	 0x0

int rtm_init(void);

#endif  /* XSCALE_INIT_FOR_LINUX */

#define SRAM_BEGIN       0x80000000
#define CHANNEL_0_OFFSET 0x00000000
#define CHANNEL_1_OFFSET 0x10000000
#define SCRATCH_BEGIN    0xca000000

#define SRAM_BASE_CH0	(SRAM_BEGIN + CHANNEL_0_OFFSET)
#define SRAM_BASE_CH1	(SRAM_BEGIN + CHANNEL_1_OFFSET)
#define SDRAM_BASE      SDRAM_BEGIN
#define SCRATCH_BASE    SCRATCH_BEGIN

#define SCRATCH_SIZE    0x4000 /* 16KB */

#define	SRAM_WRITE(a,b)		set_sram((a),(b))

#define	SDRAM_WRITE(a,b)	set_dram((a),(b))


#endif /* XSCALE_INIT_H */



