%{
#include <stdio.h>
#define SUCCESS 1

int yylex();
void yyerror(char *s);

%}

%start statement
%token course_num
%token ws
%token colon
%token semicolon
%token word
%token newline

%%

statement: course_num colon text semicolon newline {
	printf("Statement: Matched rule 1\n");
	return SUCCESS;
};

text:
ows word {
	printf("text: matched rule 1\n");
}; |
ows course_num {
	printf("text: matched rule 2\n");
}; |
text ows text {
	printf("text: matched rule 3\n");
};

ows: {
	printf("ows: matched rule 1: nothing\n");
}; |
ws {
	printf("ows: matched rule 2\n");
}

%%

void yyerror(char *err) {
	printf("Received parsing error: %s\n", err);
}

int main(void) {
	yyparse();
	return 0;
}
