/* Declarations */

%{
#include "y.tab.h"
%}

course_num	[0-9]+
ws		[\x20\x09]+
colon		:
semicolon	;
newline		\n
word		[a-zA-Z]+

%%

{course_num}	{
	printf("Course number: %s\n", yytext);
	return course_num;
}

{ws}	{
	printf("White spaces\n");
	return ws;
}

{colon} {
	printf("Colon\n");
	return colon;
}

{semicolon} {
	printf("Semicolon\n");
	return semicolon;
}

{newline} {
	printf("Newline\n");
	return newline;
}

{word} {
	printf("word: %s\n", yytext);
	return word;
}

%%

int yywrap(void) {
	return 1;
}
