%{
#include <stdio.h>     /* C declarations used in actions */
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

/* yyparse() calls yyerror() on error */
void yyerror (char *s);

/* yyparse() calls yylex() to get tokens */
extern int yylex();

%}

/* Various types values that we can get from lex */
%union {
	char str[512];
	int i;
}

/* The first rule that yacc should try to match */
%start statement

/*
 * Tokens that yacc expects from lex, essentially these are the tokens
 * declared in declaration section of lex file.
 */
%token t_number
%token t_ws
%token t_semicolon
%token t_colon
%token t_token
%token t_ret

/* Type of value returned for these tokens */
%type<i> t_number
%type<str> t_ws
%type<str> t_semicolon
%type<str> t_colon
%type<str> t_token
%type<str> ows
%type<str> string

%%

statement: t_number ows t_colon ows string t_semicolon t_ret {
	printf("Matched statement, course: %d, comment: '%s'\n", $1, $5);
	return 0;
};

ows: {
	printf("Matched ows rule 1\n", $$);
	snprintf($$, 512, "");
}; |
t_ws {
	printf("Matched ows rule 2\n", $$);
	snprintf($$, 512, "%s", $1);
};

string: ows t_token ows {
	printf("Matched string rule 1\n");
	snprintf($$, 512, "%s%s%s", $1, $2, $3);
}; |
string t_token ows {
	printf("Matched string rule 2\n");
	snprintf($$, 512, "%s%s%s", $1, $2, $3);
};


%%                     /* C code */

int yywrap(void) {
	return 1;
}


int main(int argc, char *argv[])
{
	printf("yyparse returned: %d\n", yyparse());
	return 0;
}

void yyerror (char *s) {fprintf (stderr, "%s\n", s);} 
