/**
 * @file lexer.l
 * A lexer for a very simple language
 *
 * Following are the valid statements in our language:
 * 15213: it was easy;
 * 15441: I dont know yet;
 *
 * Following are invalid statements in our language:
 * 15abc: it was easy;
 * 15213; it was easy;
 */

/*
 * Lex file is divided into 3 sections:
 */

/**
 * Section 1: Declarations
 * This section contains declarations of various tokens that are presenet
 * in our language
 */

/* BTW, You can embed C code in as follows: */
%{

#include <unistd.h>
#include "y.tab.h"

%}

/* Declarations: */
number		[0-9]*

/* whitespaces */
ws		[\x20\x09]*

colon		:

semicolon	;

/* newline */
ret		\x0a

/* word */
token		[a-zA-Z]*

%%

{number} {
	printf("number = %s\n", yytext);
	/*
	 * yylval is a union defined yacc file.
	 * you can use yylval to communicate values
	 * of a matched token back to the parser (yacc file).
	 *
	 * We are setting yylval.i to the integer value of yytext
	 */
	yylval.i = strtol(yytext, NULL, 10);

	return t_number;
}

{ws} {
	printf("whitespace\n");

	/* Whitespace is a string, so copying to yylval.str */
	strncpy(yylval.str, yytext, 512);
	return t_ws;
}

{colon} {
	printf("colon = %s\n", yytext);

	/* Treating colon as a string too! Just for the simplicity */
	strncpy(yylval.str, yytext, 512);
	return t_colon;
}

{ret} {
	printf("ret = %s\n", yytext);
	strncpy(yylval.str, yytext, 512);
	return t_ret;
}

{semicolon} {
	printf("semicolon = %s\n", yytext);
	strncpy(yylval.str, yytext, 512);
	return t_semicolon;
}

{token} {
	printf("token = %s\n", yytext);
	strncpy(yylval.str, yytext, 512);
	return t_token;
}

%%
